/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.templates;

import java.io.File;
import java.util.Hashtable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.ve.internal.java.vce.templates.TemplateObjectEmitter;
import org.eclipse.ve.internal.java.vce.templates.TemplatesException;

public class TemplateObjectFactory {
    public static final IPath OBJECT_DESTINATION_PATH = Platform.getPluginStateLocation((Plugin)Platform.getPlugin((String)"org.eclipse.ve.java.core")).append("JetObjects");
    static Hashtable fEmitters = new Hashtable();

    protected static TemplateObjectEmitter getEmitter(String[] templateURIPath, String template, long ts, String classname) {
        String tPath = JETCompiler.find((String[])templateURIPath, (String)template);
        TemplateObjectEmitter e = (TemplateObjectEmitter)fEmitters.get(tPath);
        if (e == null || e.getTemplateTimeStamp() < ts) {
            e = classname != null ? new TemplateObjectEmitter(templateURIPath, template, OBJECT_DESTINATION_PATH, classname) : new TemplateObjectEmitter(templateURIPath, template, OBJECT_DESTINATION_PATH);
            fEmitters.put(tPath, e);
        }
        return e;
    }

    protected static File getTemplate(String[] templateURIPath, String template) {
        try {
            String templateAbsoluteURI = JETCompiler.find((String[])templateURIPath, (String)template);
            File tf = new File(templateAbsoluteURI);
            if (!tf.canRead()) {
                return null;
            }
            return tf;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getClassSource(String[] templateURIPath, String template, String className, IProgressMonitor pm) throws TemplatesException {
        try {
            File tf = TemplateObjectFactory.getTemplate(templateURIPath, template);
            if (tf == null) {
                throw new JETException("Template not found: " + template);
            }
            TemplateObjectEmitter e = TemplateObjectFactory.getEmitter(templateURIPath, template, tf.lastModified(), null);
            return e.getObjectSource(pm);
        }
        catch (JETException e) {
            throw new TemplatesException(e);
        }
    }

    public static Object getClassInstance(String[] jdtCompileClassPath, String[] templateURIPath, String template, ClassLoader cl, String className, IProgressMonitor pm) throws TemplatesException {
        try {
            File tf = TemplateObjectFactory.getTemplate(templateURIPath, template);
            if (tf == null) {
                throw new JETException("Template not found: " + template);
            }
            TemplateObjectEmitter e = TemplateObjectFactory.getEmitter(templateURIPath, template, tf.lastModified(), className);
            return e.getObject(jdtCompileClassPath, e.getClassName(pm), cl, pm);
        }
        catch (JETException e) {
            throw new TemplatesException(e);
        }
    }
}

