/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.templates;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.ve.internal.java.vce.templates.TemplatesException;

public class TemplateUtil {
    private static final HashMap fClassPathMap = new HashMap();
    private static final HashMap fClassPathPreReqMap = new HashMap();
    private static List fPlatformJRE = null;

    public static boolean isDevMode(IPluginDescriptor desc) {
        File d = new File(TemplateUtil.getCorrectPath(ProxyPlugin.getPlugin().localizeFromPluginDescriptor(desc, "bin")));
        return d.canRead() && d.isDirectory() && d.list().length > 0;
    }

    public static String getPluginInstallPath(String plugin, String relativePath) {
        return TemplateUtil.getPluginInstallPath(Platform.getPlugin((String)plugin).getDescriptor(), relativePath);
    }

    public static String getPluginInstallPath(IPluginDescriptor pluginDescriptor, String relativePath) {
        return TemplateUtil.getCorrectPath(ProxyPlugin.getPlugin().localizeFromPluginDescriptor(pluginDescriptor, relativePath));
    }

    public static String getPluginSrcPath(String plugin, String relativePath) {
        ILibrary[] lib = Platform.getPlugin((String)plugin).getDescriptor().getRuntimeLibraries();
        if (lib == null || lib.length == 0) {
            return null;
        }
        Path src = new Path(lib[0].getPath().removeFileExtension().lastSegment());
        IPath p = src.append(relativePath);
        return TemplateUtil.getPluginInstallPath(plugin, p.toString());
    }

    public static List getPluginJarPath(String plugin) {
        List l = (List)fClassPathMap.get(plugin);
        if (l != null) {
            return l;
        }
        IPluginDescriptor desc = Platform.getPlugin((String)plugin).getDescriptor();
        ArrayList<String> list = new ArrayList<String>();
        if (!TemplateUtil.isDevMode(desc)) {
            ILibrary[] lib = desc.getRuntimeLibraries();
            int i = 0;
            while (i < lib.length) {
                String[] names = ProxyPlugin.getPlugin().localizeFromPluginDescriptorAndFragments(desc, lib[i].getPath().toString());
                if (names != null && names.length != 0) {
                    list.add(TemplateUtil.getCorrectPath(names[0]));
                }
                ++i;
            }
        } else {
            list.add(TemplateUtil.getCorrectPath(ProxyPlugin.getPlugin().localizeFromPluginDescriptor(desc, "bin")));
        }
        fClassPathMap.put(plugin, list);
        return list;
    }

    public static List getPluginAndPreReqJarPath(String plugin) {
        List lst = (List)fClassPathPreReqMap.get(plugin);
        if (lst != null) {
            return lst;
        }
        IPluginDescriptor desc = null;
        try {
            desc = Platform.getPlugin((String)plugin).getDescriptor();
        }
        catch (Exception exception) {
            return new ArrayList();
        }
        IPluginPrerequisite[] preReq = desc.getPluginPrerequisites();
        List l = TemplateUtil.getPluginJarPath(plugin);
        HashMap<String, String> beenThere = new HashMap<String, String>();
        beenThere.put(plugin, plugin);
        int i = 0;
        while (i < preReq.length) {
            String plgn = preReq[i].getUniqueIdentifier();
            if (beenThere.get(plgn) == null) {
                Iterator itr = TemplateUtil.getPluginAndPreReqJarPath(plgn, beenThere).iterator();
                while (itr.hasNext()) {
                    String path = (String)itr.next();
                    if (l.contains(path)) continue;
                    l.add(path);
                }
            }
            ++i;
        }
        fClassPathPreReqMap.put(plugin, l);
        return l;
    }

    private static List getPluginAndPreReqJarPath(String plugin, HashMap beenThere) {
        List lst = (List)fClassPathPreReqMap.get(plugin);
        if (lst != null) {
            return lst;
        }
        IPluginDescriptor desc = null;
        try {
            desc = Platform.getPlugin((String)plugin).getDescriptor();
        }
        catch (Exception exception) {
            return new ArrayList();
        }
        IPluginPrerequisite[] preReq = desc.getPluginPrerequisites();
        List l = TemplateUtil.getPluginJarPath(plugin);
        beenThere.put(plugin, plugin);
        int i = 0;
        while (i < preReq.length) {
            String plgn = preReq[i].getUniqueIdentifier();
            if (beenThere.get(plgn) == null) {
                Iterator itr = TemplateUtil.getPluginAndPreReqJarPath(plgn, beenThere).iterator();
                while (itr.hasNext()) {
                    l.add(itr.next());
                }
            }
            ++i;
        }
        fClassPathPreReqMap.put(plugin, l);
        return l;
    }

    /*
     * Unable to fully structure code
     */
    private static String getCorrectPath(String path) {
        buf = new StringBuffer();
        i = 0;
        while (i < path.length()) {
            block3: {
                c = path.charAt(i);
                if (BootLoader.getOS().equals("win32") && i == 0 && c == '/') break block3;
                if (c != '%' || i + 2 >= path.length()) ** GOTO lbl-1000
                c1 = path.charAt(i + 1);
                c2 = path.charAt(i + 2);
                if (c1 == '2' && c2 == '0') {
                    i += 2;
                } else lbl-1000:
                // 2 sources

                {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static List getPlatformJREPath() throws TemplatesException {
        if (fPlatformJRE != null) {
            return fPlatformJRE;
        }
        VMStandin detectedVMStandin = null;
        IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            String vmID;
            File detectedLocation = vmTypes[i].detectInstallLocation();
            if (detectedLocation != null && (detectedVMStandin = new VMStandin(vmTypes[i], vmID = String.valueOf("1"))) != null) {
                detectedVMStandin.setInstallLocation(detectedLocation);
                detectedVMStandin.setName(detectedVMStandin.getInstallLocation().getName());
                LibraryLocation[] locations = JavaRuntime.getLibraryLocations((IVMInstall)detectedVMStandin);
                fPlatformJRE = new ArrayList(locations.length);
                int j = 0;
                while (j < locations.length) {
                    IPath path = locations[j].getSystemLibraryPath();
                    if (!Path.EMPTY.equals((Object)path)) {
                        fPlatformJRE.add(path.toString());
                    }
                    ++j;
                }
                return fPlatformJRE;
            }
            ++i;
        }
        fPlatformJRE = Collections.EMPTY_LIST;
        return fPlatformJRE;
    }

    public static String getClassPath(Object o) {
        if (o == null) {
            return null;
        }
        return TemplateUtil.getClassPath(o.getClass());
    }

    public static String getClassPath(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String name = "/" + clazz.getName().replace('.', '/') + ".class";
        URL url = clazz.getResource(name);
        if (url == null) {
            return null;
        }
        String path = url.getFile();
        if (path.startsWith("/") && path.charAt(2) == ':') {
            path = path.substring(1);
        } else if (path.toLowerCase().startsWith("file:")) {
            int excMarkIndex = (path = path.substring(5)).indexOf("!");
            if (excMarkIndex != -1) {
                path = path.substring(0, excMarkIndex);
            }
        } else if (path.charAt(1) != ':') {
            return null;
        }
        return TemplateUtil.getCorrectPath(path);
    }

    public static long getTimeStamp(Object o) {
        return TemplateUtil.getTimeStamp(o.getClass());
    }

    public static long getTimeStamp(Class clazz) {
        String path = TemplateUtil.getClassPath(clazz);
        if (path == null) {
            return -1L;
        }
        File f = new File(path);
        if (!f.canRead()) {
            return -1L;
        }
        return f.lastModified();
    }

    public static ClassLoader getClassLoader(String plugin) {
        Plugin p = Platform.getPlugin((String)plugin);
        if (p != null) {
            return p.getDescriptor().getPluginClassLoader();
        }
        return null;
    }
}

