/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ve.internal.cde.palette.Category;
import org.eclipse.ve.internal.cde.palette.Entry;
import org.eclipse.ve.internal.cde.palette.Group;
import org.eclipse.ve.internal.cde.palette.PalettePackage;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.wizard.InternalMessages;

public class ClasspathWizardPage
extends WizardPage
implements IClasspathContainerPage,
IExecutableExtension {
    protected IClasspathEntry fContainerEntry;
    protected String variableName;
    protected IConfigurationElement configData;
    protected static Image fVariableImage;
    protected static Image fExternalJarImage;
    protected static Image fExternalJarWithSourceImage;

    public ClasspathWizardPage() {
        super(InternalMessages.getString("ClasspathWizardPage.PageName"));
        this.setImageDescriptor(JavaVEPlugin.getWizardTitleImageDescriptor());
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        this.setControl((Control)c);
        GridLayout layout = new GridLayout(2, false);
        c.setLayout((Layout)layout);
        if (this.configData == null) {
            this.setErrorMessage(MessageFormat.format(InternalMessages.getString("ClasspathWizardPage.NoConfigData.ErrorMessage_ERROR_"), this.variableName));
            new Label(c, 0).setText(MessageFormat.format(InternalMessages.getString("ClasspathWizardPage.NoConfigData.Label.ErrorMessage_ERROR_"), this.variableName));
            this.setControl((Control)c);
            return;
        }
        if (fVariableImage == null) {
            fVariableImage = JavaPlugin.getDefault().getImageRegistry().get("org.eclipse.jdt.ui.envvar_obj.gif");
        }
        new Label(c, 0).setImage(fVariableImage);
        Label label = new Label(c, 0);
        String[] existingVariableNames = JavaCore.getClasspathVariableNames();
        boolean variableExists = false;
        int i = 0;
        while (i < existingVariableNames.length) {
            if (existingVariableNames[i].equals(this.variableName)) {
                variableExists = true;
                break;
            }
            ++i;
        }
        if (!variableExists) {
            label.setText(MessageFormat.format(InternalMessages.getString("ClasspathWizardPage.JavaVariable.Created"), this.variableName));
        } else {
            label.setText(MessageFormat.format(InternalMessages.getString("ClasspathWizardPage.JavaVariable.Used"), this.variableName));
            this.createSpacer(c, 1);
            Label l2 = this.createIndentedLabel(c);
            l2.setText(JavaCore.getClasspathVariable((String)this.variableName).toString());
        }
        org.eclipse.swt.widgets.Group g = this.createGroup(c, 2);
        g.setText(InternalMessages.getString("ClasspathWizardPage.Group.Buildpath.Includes"));
        if (fExternalJarImage == null) {
            fExternalJarImage = JavaPlugin.getDefault().getImageRegistry().get("org.eclipse.jdt.ui.jar_l_obj.gif");
        }
        if (fExternalJarWithSourceImage == null) {
            fExternalJarWithSourceImage = JavaPlugin.getDefault().getImageRegistry().get("org.eclipse.jdt.ui.jar_lsrc_obj.gif");
        }
        IConfigurationElement[] entries = this.configData.getChildren("extend");
        int i2 = 0;
        while (i2 < entries.length) {
            IConfigurationElement iConfigurationElement = entries[i2];
            String runtime = iConfigurationElement.getAttributeAsIs("runtime");
            String source = iConfigurationElement.getAttributeAsIs("source");
            if (source == null) {
                new Label((Composite)g, 0).setImage(fExternalJarImage);
            } else {
                new Label((Composite)g, 0).setImage(fExternalJarWithSourceImage);
            }
            new Label((Composite)g, 0).setText(String.valueOf(this.variableName) + "/" + runtime);
            if (source != null) {
                this.createSpacer((Composite)g, 1);
                Label l = this.createIndentedLabel((Composite)g);
                l.setText(MessageFormat.format(InternalMessages.getString("ClasspathWizardPage.BuildPath.SourceAttachments.Message"), String.valueOf(this.variableName) + "/" + source));
            }
            ++i2;
        }
        String paletteExtension = this.configData.getAttributeAsIs("palettecats");
        if (paletteExtension != null) {
            ResourceSetImpl rs = new ResourceSetImpl();
            try {
                Resource r = rs.createResource(URI.createURI((String)paletteExtension));
                r.load(Collections.EMPTY_MAP);
                Collection categories = EcoreUtil.getObjectsByType((Collection)r.getContents(), (EClassifier)PalettePackage.eINSTANCE.getCategory());
                Iterator iter = categories.iterator();
                final ArrayList<Image> images = new ArrayList<Image>();
                while (iter.hasNext()) {
                    Category category = (Category)iter.next();
                    org.eclipse.swt.widgets.Group g2 = this.createGroup(c, 4);
                    g2.setText(MessageFormat.format(InternalMessages.getString("ClasspathWizardPage.Palette.Category.Added.Message"), category.getCategoryLabel().getStringValue()));
                    Iterator groups = category.getGroups().iterator();
                    while (groups.hasNext()) {
                        Group group = (Group)groups.next();
                        Iterator items = group.getEntries().iterator();
                        while (items.hasNext()) {
                            Entry element = (Entry)items.next();
                            String iconName = element.getIcon16Name();
                            try {
                                URL url = new URL(iconName);
                                Image image = ImageDescriptor.createFromURL((URL)url).createImage();
                                new Label((Composite)g2, 0).setImage(image);
                                images.add(image);
                            }
                            catch (MalformedURLException malformedURLException) {
                                new Label((Composite)g2, 0);
                            }
                            new Label((Composite)g2, 0).setText(element.getEntryLabel().getStringValue());
                        }
                    }
                    parent.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent event) {
                            Iterator iter = ((AbstractList)images).iterator();
                            while (iter.hasNext()) {
                                ((Image)iter.next()).dispose();
                            }
                        }
                    });
                }
            }
            catch (Exception exc) {
                new Label(c, 0).setText(MessageFormat.format(InternalMessages.getString("ClasspathWizardPage.LoadPaletteExtension.Exception.Message1_EXC_"), paletteExtension));
                new Label(c, 0).setText(MessageFormat.format(InternalMessages.getString("ClasspathWizardPage.LoadPaletteExtension.Exception.Message2"), exc.getMessage()));
                new Label(c, 0).setText(InternalMessages.getString("ClasspathWizardPage.LoadPaletteExtension.Exception.Message3"));
            }
        }
    }

    public boolean finish() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        if (this.configData != null) {
            JavaCore.getClasspathVariable((String)this.variableName);
            String pathAttribute = this.configData.getAttributeAsIs("path");
            final IPath containerPath = new Path("JAVA_BEANS").append(pathAttribute);
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                    try {
                        monitor.beginTask(InternalMessages.getString("ClasspathWizardPage.Finish.task.SettingProject"), 2000);
                        ClasspathWizardPage.this.setSelection(JavaCore.newContainerEntry((IPath)containerPath));
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var2_4 = null;
                    }
                    monitor.done();
                }
            };
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof CoreException) {
                    this.setErrorMessage(((CoreException)e.getTargetException()).getStatus().getMessage());
                } else {
                    this.setErrorMessage(e.getTargetException().getLocalizedMessage());
                }
                return false;
            }
        }
        return true;
    }

    protected IClasspathEntry[] addVariableEntry(IClasspathEntry[] raw, IClasspathEntry newEntry) {
        int i = 0;
        while (i < raw.length) {
            if (newEntry.equals(raw[i])) {
                return raw;
            }
            ++i;
        }
        IClasspathEntry[] newRaw = new IClasspathEntry[raw.length + 1];
        System.arraycopy(raw, 0, newRaw, 0, raw.length);
        newRaw[raw.length] = newEntry;
        return newRaw;
    }

    public IClasspathEntry getSelection() {
        return this.fContainerEntry;
    }

    protected Label createIndentedLabel(Composite c) {
        Label result = new Label(c, 0);
        GridData indentData = new GridData();
        indentData.horizontalIndent = 30;
        result.setLayoutData((Object)indentData);
        return result;
    }

    protected org.eclipse.swt.widgets.Group createGroup(Composite c, int rows) {
        org.eclipse.swt.widgets.Group g = new org.eclipse.swt.widgets.Group(c, 0);
        g.setLayout((Layout)new GridLayout(rows, false));
        GridData gData = new GridData(768);
        gData.horizontalSpan = 2;
        g.setLayoutData((Object)gData);
        return g;
    }

    protected void createSpacer(Composite c, int span) {
        Label label = new Label(c, 0);
        if (span > 1) {
            GridData data = new GridData();
            data.horizontalSpan = 2;
            label.setLayoutData((Object)data);
        }
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.fContainerEntry = containerEntry;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.variableName = (String)data;
            IConfigurationElement[] configDataArray = JavaVEPlugin.getPlugin().getRegistrations((IPath)new Path(this.variableName));
            if (configDataArray != null && configDataArray.length == 1) {
                this.configData = configDataArray[0];
            }
            this.setTitle(this.variableName);
        }
    }
}

