/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.wizard;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class ContainerInitializer
extends ClasspathContainerInitializer {
    public static final String JAVA_BEANS = "JAVA_BEANS";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        String variableName = containerPath.segment(1);
        if (JavaCore.getClasspathVariable((String)variableName) == null) {
            try {
                IConfigurationElement configElement = JavaVEPlugin.getPlugin().getRegistrations(containerPath.removeFirstSegments(1))[0];
                URL install = Platform.resolve((URL)configElement.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL());
                Path variablePath = new Path(install.getFile());
                JavaCore.setClasspathVariable((String)variableName, (IPath)variablePath, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException iOException) {}
        }
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        boolean wasAutobuild = ws.getDescription().isAutoBuilding();
        ws.getDescription().setAutoBuilding(false);
        try {
            this.removeFromClasspath(project, containerPath);
            Path javaBeansPath = new Path(variableName);
            IConfigurationElement[] configData = JavaVEPlugin.getPlugin().getRegistrations((IPath)javaBeansPath);
            IConfigurationElement[] extensions = configData[0].getChildren("extend");
            String pathAttribute = configData[0].getAttributeAsIs("path");
            int i = 0;
            while (true) {
                block10: {
                    if (i < extensions.length) break block10;
                    project.getProject().build(6, null);
                    break;
                }
                Path runtimePath = new Path(String.valueOf(pathAttribute) + "/" + extensions[i].getAttributeAsIs("runtime"));
                String sourceAttribute = extensions[i].getAttributeAsIs("source");
                Path sourcePath = null;
                if (sourceAttribute != null) {
                    sourcePath = new Path(String.valueOf(pathAttribute) + "/" + sourceAttribute);
                }
                String sourcePrefix = extensions[i].getAttributeAsIs("prefix");
                IPath sourcePrefixPath = null;
                if (sourcePrefix != null) {
                    String sourceRootVariableName = String.valueOf(variableName) + "_SRCROOT";
                    if (JavaCore.getClasspathVariable((String)sourceRootVariableName) == null) {
                        JavaCore.setClasspathVariable((String)sourceRootVariableName, (IPath)new Path(sourcePrefix), (IProgressMonitor)new NullProgressMonitor());
                    }
                    sourcePrefixPath = JavaCore.getClasspathVariable((String)sourceRootVariableName);
                }
                IClasspathEntry newVariableEntry = JavaCore.newVariableEntry((IPath)runtimePath, (IPath)sourcePath, sourcePrefixPath, (boolean)true);
                this.addToClasspath(project, newVariableEntry);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            ws.getDescription().setAutoBuilding(wasAutobuild);
            throw throwable;
        }
        {
            Object var17_20 = null;
        }
        ws.getDescription().setAutoBuilding(wasAutobuild);
    }

    protected void addToClasspath(IJavaProject project, IClasspathEntry newEntry) throws JavaModelException {
        IClasspathEntry[] raw = project.getRawClasspath();
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>(raw.length);
        int i = 0;
        while (i < raw.length) {
            classpathEntries.add(raw[i]);
            ++i;
        }
        Iterator iter = classpathEntries.iterator();
        while (iter.hasNext()) {
            IClasspathEntry existingEntry = (IClasspathEntry)iter.next();
            if (!existingEntry.equals(newEntry)) continue;
            return;
        }
        classpathEntries.add(newEntry);
        IClasspathEntry[] classpathEntriesArray = classpathEntries.toArray(new IClasspathEntry[0]);
        project.setRawClasspath(classpathEntriesArray, null);
    }

    protected void removeFromClasspath(IJavaProject project, IPath containerPath) throws JavaModelException {
        IClasspathEntry[] raw = project.getRawClasspath();
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>(raw.length);
        int i = 0;
        while (i < raw.length) {
            if (!raw[i].getPath().equals((Object)containerPath)) {
                classpathEntries.add(raw[i]);
            }
            ++i;
        }
        if (classpathEntries.size() != raw.length) {
            IClasspathEntry[] classpathEntriesArray = classpathEntries.toArray(new IClasspathEntry[0]);
            project.setRawClasspath(classpathEntriesArray, null);
        }
    }
}

