/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class FontPropertyEditor
extends JPanel {
    private static ResourceBundle resabtedit = ResourceBundle.getBundle("org.eclipse.ve.internal.jfc.beaninfo.vceedit");
    private Font fontValue;
    private static final String[] styleNames = new String[]{resabtedit.getString("plain"), resabtedit.getString("bold"), resabtedit.getString("italic"), resabtedit.getString("bold_italic")};
    private static final Integer[] sizeArray = new Integer[]{new Integer(8), new Integer(10), new Integer(12), new Integer(14), new Integer(18), new Integer(24), new Integer(36), new Integer(48), new Integer(72)};
    private static Vector fontNames = null;
    private static Vector lowerCaseFontNames = null;
    private static Vector pointSizes = null;
    private JTextField namesText = null;
    private JList namesList = null;
    private JList stylesList = null;
    private JTextField stylesText = null;
    private WholeNumberField sizeText = null;
    private JList sizeList = null;
    private JTextArea previewText = null;
    private boolean searchSelect = false;
    private boolean nameSelect = false;

    public FontPropertyEditor() {
        this(new Font("Dialog", 0, 12));
    }

    public FontPropertyEditor(Font startFont) {
        this.getPointSizes();
        this.initialize();
        this.setFontValue(startFont);
    }

    public Vector getPointSizes() {
        if (pointSizes == null) {
            pointSizes = new Vector<Integer>(Arrays.asList(sizeArray));
        }
        return pointSizes;
    }

    public Vector getFontNames() {
        if (fontNames == null) {
            fontNames = new Vector<String>(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()));
            Collections.sort(fontNames, new StringIgnoreCaseComparator());
        }
        return fontNames;
    }

    public Vector getLowerCaseFontNames() {
        if (lowerCaseFontNames == null) {
            lowerCaseFontNames = new Vector();
            Iterator itr = ((AbstractList)this.getFontNames()).iterator();
            while (itr.hasNext()) {
                lowerCaseFontNames.add(((String)itr.next()).toLowerCase());
            }
        }
        return lowerCaseFontNames;
    }

    private void initialize() {
        this.setPreferredSize(new Dimension(430, 250));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JSplitPane editPreviewSplit = new JSplitPane(0);
        editPreviewSplit.setOneTouchExpandable(true);
        JPanel optionsPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        optionsPanel.setLayout(gb);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 5, 5);
        c.gridy = 0;
        c.fill = 2;
        c.weighty = 0.0;
        c.gridx = 0;
        c.weightx = 1.0;
        optionsPanel.add((Component)new JLabel(resabtedit.getString("Name")), c);
        c.gridx = 1;
        c.weightx = 0.0;
        optionsPanel.add((Component)new JLabel(resabtedit.getString("Style")), c);
        c.gridx = 2;
        c.weightx = 0.0;
        optionsPanel.add((Component)new JLabel(resabtedit.getString("Size")), c);
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 0;
        c.weightx = 1.0;
        optionsPanel.add((Component)this.getNamesPanel(), c);
        c.gridx = 1;
        c.weightx = 0.0;
        optionsPanel.add((Component)this.getStylesPanel(), c);
        c.insets = new Insets(0, 0, 5, 0);
        c.gridx = 2;
        c.weightx = 0.0;
        optionsPanel.add((Component)this.getSizePanel(), c);
        optionsPanel.setMinimumSize(new Dimension(400, 150));
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        editPreviewSplit.setTopComponent(optionsPanel);
        JScrollPane previewPane = new JScrollPane();
        previewPane.setViewportView(this.getPreviewText());
        previewPane.setMinimumSize(new Dimension(3, 75));
        editPreviewSplit.setBottomComponent(previewPane);
        editPreviewSplit.setResizeWeight(0.75);
        this.add((Component)editPreviewSplit, "Center");
        this.recursiveSetBackground(this, SystemColor.control);
        this.initializeOptions();
    }

    private JTextArea getPreviewText() {
        if (this.previewText == null) {
            this.previewText = new JTextArea();
            this.previewText.setRows(1);
            this.previewText.setText(resabtedit.getString("font.previewtext"));
            this.previewText.setMargin(new Insets(5, 5, 5, 5));
        }
        return this.previewText;
    }

    private JPanel getNamesPanel() {
        JPanel namesPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        namesPanel.setLayout(gb);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 5, 0);
        c.gridy = 0;
        c.weighty = 0.0;
        c.fill = 2;
        namesPanel.add((Component)this.getNamesText(), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 1;
        JScrollPane namesScrollPane = new JScrollPane();
        namesScrollPane.setViewportView(this.getNamesList());
        namesPanel.add((Component)namesScrollPane, c);
        namesPanel.setPreferredSize(new Dimension(150, 100));
        namesPanel.setMinimumSize(new Dimension(150, 100));
        return namesPanel;
    }

    private JTextField getNamesText() {
        if (this.namesText == null) {
            this.namesText = new JTextField();
            this.namesText.getDocument().addDocumentListener(new DocumentListener(){

                public void updateSelection() {
                    if (!FontPropertyEditor.this.nameSelect) {
                        int newIndex = FontPropertyEditor.this.searchFontNames(FontPropertyEditor.this.getNamesText().getText());
                        if (FontPropertyEditor.this.getNamesList().getSelectedIndex() != newIndex) {
                            FontPropertyEditor.this.searchSelect = true;
                            FontPropertyEditor.this.getNamesList().setSelectedIndex(newIndex);
                            FontPropertyEditor.this.getNamesList().ensureIndexIsVisible(newIndex);
                            FontPropertyEditor.this.searchSelect = false;
                        }
                    }
                }

                public void changedUpdate(DocumentEvent e) {
                }

                public void insertUpdate(DocumentEvent e) {
                    this.updateSelection();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.updateSelection();
                }
            });
            this.namesText.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    FontPropertyEditor.this.namesText.selectAll();
                }
            });
        }
        return this.namesText;
    }

    private JList getNamesList() {
        if (this.namesList == null) {
            this.namesList = new JList();
            this.namesList.setSelectionMode(0);
            this.namesList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    String newName = (String)FontPropertyEditor.this.getNamesList().getSelectedValue();
                    if (newName != null) {
                        FontPropertyEditor.this.fontValue = new Font(newName, FontPropertyEditor.this.fontValue.getStyle(), FontPropertyEditor.this.fontValue.getSize());
                        if (!FontPropertyEditor.this.searchSelect) {
                            FontPropertyEditor.this.nameSelect = true;
                            FontPropertyEditor.this.getNamesText().setText(newName);
                            FontPropertyEditor.this.nameSelect = false;
                        }
                        FontPropertyEditor.this.updatePreview();
                    }
                }
            });
        }
        return this.namesList;
    }

    private JPanel getStylesPanel() {
        JPanel stylesPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        stylesPanel.setLayout(gb);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 5, 0);
        c.gridy = 0;
        c.weighty = 0.0;
        c.fill = 2;
        stylesPanel.add((Component)this.getStylesText(), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 1;
        JScrollPane stylesScrollPane = new JScrollPane();
        stylesScrollPane.setViewportView(this.getStylesList());
        stylesPanel.add((Component)stylesScrollPane, c);
        stylesPanel.setPreferredSize(new Dimension(110, 100));
        stylesPanel.setMinimumSize(new Dimension(110, 100));
        return stylesPanel;
    }

    private JTextField getStylesText() {
        if (this.stylesText == null) {
            this.stylesText = new JTextField();
            this.stylesText.setEnabled(false);
        }
        return this.stylesText;
    }

    private JList getStylesList() {
        if (this.stylesList == null) {
            this.stylesList = new JList();
            this.stylesList.setSelectionMode(0);
            this.stylesList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    String newStyle = (String)FontPropertyEditor.this.getStylesList().getSelectedValue();
                    if (newStyle != null) {
                        FontPropertyEditor.this.fontValue = new Font(FontPropertyEditor.this.fontValue.getName(), FontPropertyEditor.this.getStyleFromName(newStyle), FontPropertyEditor.this.fontValue.getSize());
                        FontPropertyEditor.this.updatePreview();
                        FontPropertyEditor.this.getStylesText().setText(newStyle);
                    }
                }
            });
        }
        return this.stylesList;
    }

    private JPanel getSizePanel() {
        JPanel sizePanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        sizePanel.setLayout(gb);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 5, 0);
        c.gridy = 0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)this.getSizeText(), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 1;
        JScrollPane sizeScrollPane = new JScrollPane();
        sizeScrollPane.setViewportView(this.getSizeList());
        sizePanel.add((Component)sizeScrollPane, c);
        sizePanel.setPreferredSize(new Dimension(110, 100));
        sizePanel.setMinimumSize(new Dimension(110, 100));
        return sizePanel;
    }

    private WholeNumberField getSizeText() {
        if (this.sizeText == null) {
            this.sizeText = new WholeNumberField();
            this.sizeText.getDocument().addDocumentListener(new DocumentListener(){

                public void updateFont() {
                    Integer newSize = new Integer(FontPropertyEditor.this.getSizeText().getValue());
                    FontPropertyEditor.this.fontValue = new Font(FontPropertyEditor.this.fontValue.getName(), FontPropertyEditor.this.fontValue.getStyle(), newSize);
                    Integer selectedSize = (Integer)FontPropertyEditor.this.getSizeList().getSelectedValue();
                    if (selectedSize == null || !selectedSize.equals(newSize)) {
                        if (FontPropertyEditor.this.getPointSizes().contains(newSize)) {
                            FontPropertyEditor.this.getSizeList().setSelectedValue(newSize, true);
                        } else {
                            FontPropertyEditor.this.getSizeList().clearSelection();
                        }
                    }
                    FontPropertyEditor.this.updatePreview();
                }

                public void changedUpdate(DocumentEvent e) {
                }

                public void insertUpdate(DocumentEvent e) {
                    this.updateFont();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.updateFont();
                }
            });
            this.sizeText.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    FontPropertyEditor.this.sizeText.selectAll();
                }
            });
        }
        return this.sizeText;
    }

    private JList getSizeList() {
        if (this.sizeList == null) {
            this.sizeList = new JList();
            this.sizeList.setSelectionMode(0);
            this.sizeList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    Integer newSize = (Integer)FontPropertyEditor.this.getSizeList().getSelectedValue();
                    if (newSize != null) {
                        FontPropertyEditor.this.fontValue = new Font(FontPropertyEditor.this.fontValue.getName(), FontPropertyEditor.this.fontValue.getStyle(), newSize);
                        if (newSize.intValue() != FontPropertyEditor.this.getSizeText().getValue()) {
                            FontPropertyEditor.this.getSizeText().setValue(newSize);
                        }
                        FontPropertyEditor.this.updatePreview();
                    }
                }
            });
        }
        return this.sizeList;
    }

    public int getStyleFromName(String name) {
        int style = 0;
        if (name.equalsIgnoreCase(resabtedit.getString("plain"))) {
            style = 0;
        } else if (name.equalsIgnoreCase(resabtedit.getString("bold"))) {
            style = 1;
        } else if (name.equalsIgnoreCase(resabtedit.getString("italic"))) {
            style = 2;
        } else if (name.equalsIgnoreCase(resabtedit.getString("bold_italic"))) {
            style = 3;
        }
        return style;
    }

    public String getNameFromStyle(int style) {
        String name = resabtedit.getString("plain");
        switch (style) {
            case 0: {
                name = resabtedit.getString("plain");
                break;
            }
            case 1: {
                name = resabtedit.getString("bold");
                break;
            }
            case 2: {
                name = resabtedit.getString("italic");
                break;
            }
            case 3: {
                name = resabtedit.getString("bold_italic");
            }
        }
        return name;
    }

    private void initializeOptions() {
        this.getNamesList().setListData(this.getFontNames().toArray());
        this.getStylesList().setListData(styleNames);
        this.getSizeList().setListData(this.getPointSizes());
    }

    private int searchFontNames(String search) {
        int index = 0;
        if (search.length() > 0) {
            search = search.toLowerCase();
            Vector lcfn = this.getLowerCaseFontNames();
            index = 0;
            while (index < lcfn.size() && ((String)lcfn.elementAt(index)).compareTo(search) < 0) {
                ++index;
            }
            if (index >= lcfn.size()) {
                index = lcfn.size();
            }
        }
        return index;
    }

    public void setFontValue(Font newFont) {
        this.fontValue = newFont;
        if (this.fontValue != null) {
            if (newFont.getSize() < 1) {
                newFont = newFont.deriveFont(1.0f);
            }
            this.getNamesList().clearSelection();
            this.selectFontName(this.fontValue.getName());
            this.getStylesList().setSelectedValue(this.getNameFromStyle(this.fontValue.getStyle()), true);
            this.getSizeText().setValue(this.fontValue.getSize());
        } else {
            this.getNamesList().clearSelection();
            this.getStylesList().clearSelection();
            this.getSizeList().clearSelection();
        }
        this.updatePreview();
    }

    private void selectFontName(String name) {
        ListModel lm = this.getNamesList().getModel();
        int i = 0;
        while (i < lm.getSize()) {
            String temp = (String)lm.getElementAt(i);
            if (name.equalsIgnoreCase(temp)) {
                this.getNamesList().setSelectedValue(temp, true);
                break;
            }
            ++i;
        }
    }

    public Font getFontValue() {
        return this.fontValue;
    }

    private void updatePreview() {
        this.getPreviewText().setFont(this.fontValue);
    }

    private void recursiveSetBackground(Container parent, Color bgColor) {
        if (parent instanceof JList || parent instanceof JTextComponent) {
            return;
        }
        parent.setBackground(bgColor);
        Component[] children = parent.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Container) {
                this.recursiveSetBackground((Container)children[i], bgColor);
            } else {
                children[i].setBackground(bgColor);
            }
            ++i;
        }
    }

    protected class StringIgnoreCaseComparator
    implements Comparator {
        protected StringIgnoreCaseComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).compareToIgnoreCase((String)o2);
            }
            return -1;
        }

        public boolean equals(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).equalsIgnoreCase((String)o2);
            }
            return false;
        }
    }

    protected class WholeNumberField
    extends JTextField {
        private NumberFormat integerFormatter = NumberFormat.getNumberInstance();

        public WholeNumberField() {
            this.integerFormatter.setParseIntegerOnly(true);
        }

        public int getValue() {
            int retVal = 1;
            try {
                retVal = this.integerFormatter.parse(this.getText()).intValue();
                if (retVal == 0) {
                    retVal = 1;
                }
            }
            catch (ParseException parseException) {
                retVal = sizeArray[0];
            }
            return retVal;
        }

        public void setValue(int value) {
            this.setText(this.integerFormatter.format(value));
        }

        protected Document createDefaultModel() {
            return new WholeNumberDocument();
        }

        protected class WholeNumberDocument
        extends PlainDocument {
            protected WholeNumberDocument() {
            }

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                char[] source = str.toCharArray();
                char[] result = new char[source.length];
                int j = 0;
                int i = 0;
                while (i < result.length) {
                    if (Character.isDigit(source[i])) {
                        result[j++] = source[i];
                    }
                    ++i;
                }
                super.insertString(offs, new String(result, 0, j), a);
            }
        }
    }
}

