/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.lang.reflect.Array;
import org.eclipse.jem.internal.proxy.core.IArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.ide.IDEArrayBeanProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IIDEBeanProxy;

public final class IDEArrayBeanTypeProxy
extends IDEBeanTypeProxy
implements IArrayBeanTypeProxy {
    IBeanTypeProxy fFinalComponentType;
    IBeanTypeProxy fComponentType;
    String fTypeName;

    IDEArrayBeanTypeProxy(IDEProxyFactoryRegistry aRegistry, String aTypeName, Class aClass) {
        super((ProxyFactoryRegistry)aRegistry, aClass);
        this.fTypeName = aTypeName;
    }

    public boolean isArray() {
        return true;
    }

    public String getTypeName() {
        return this.fTypeName;
    }

    public IBeanTypeProxy getFinalComponentType() {
        if (this.fFinalComponentType == null) {
            Class aType;
            int typeStart = this.getTypeName().lastIndexOf(91) + 1;
            this.fFinalComponentType = this.getTypeName().charAt(typeStart) == 'L' ? this.fProxyFactoryRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(this.getTypeName().substring(typeStart + 1, this.getTypeName().length() - 1)) : ((aType = (Class)IDEStandardBeanTypeProxyFactory.MAP_SHORTSIG_TO_TYPE.get(this.getTypeName().substring(typeStart, typeStart + 1))) != null ? this.fProxyFactoryRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(aType.getName()) : null);
        }
        return this.fFinalComponentType;
    }

    public IBeanTypeProxy getComponentType() {
        if (this.fComponentType == null) {
            this.fComponentType = this.getTypeName().charAt(1) != '[' ? this.getFinalComponentType() : this.fProxyFactoryRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(this.getTypeName().substring(1));
        }
        return this.fComponentType;
    }

    public int getDimensions() {
        return this.getTypeName().lastIndexOf(91) + 1;
    }

    public IConstructorProxy getNullConstructorProxy() {
        throw new UnsupportedOperationException();
    }

    public IConstructorProxy getConstructorProxy(String[] argumentClassNames) {
        throw new UnsupportedOperationException();
    }

    public IConstructorProxy getConstructorProxy(IBeanTypeProxy[] argumentTypes) {
        throw new UnsupportedOperationException();
    }

    public IFieldProxy getFieldProxy(String fieldName) {
        throw new UnsupportedOperationException();
    }

    public IMethodProxy getMethodProxy(String methodName, IBeanTypeProxy[] argumentTypes) {
        throw new UnsupportedOperationException();
    }

    public IMethodProxy getMethodProxy(String methodName, String[] argumentClassNames) {
        throw new UnsupportedOperationException();
    }

    public IMethodProxy getMethodProxy(String methodName, String argumentQualifiedTypeName) {
        throw new UnsupportedOperationException();
    }

    public IMethodProxy getMethodProxy(String methodName) {
        throw new UnsupportedOperationException();
    }

    IDEArrayBeanProxy createBeanProxyWith(int[] dimensions) throws ThrowableProxy {
        Object array;
        if (dimensions == null || dimensions.length == 0) {
            return this.createBeanProxyWith(new int[1]);
        }
        IBeanTypeProxy compType = null;
        int numDims = this.getDimensions();
        if (numDims <= dimensions.length) {
            compType = this.getFinalComponentType();
        } else {
            String compClass = this.getTypeName().substring(dimensions.length);
            compType = this.fProxyFactoryRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(compClass);
        }
        if (dimensions.length == 1) {
            array = Array.newInstance(((IDEBeanTypeProxy)compType).fClass, dimensions[0]);
            return new IDEArrayBeanProxy(this.fProxyFactoryRegistry, array, null);
        }
        array = Array.newInstance(((IDEBeanTypeProxy)compType).fClass, dimensions);
        return new IDEArrayBeanProxy(this.fProxyFactoryRegistry, array, null);
    }

    protected IIDEBeanProxy newBeanProxy(Object anObject) {
        return new IDEArrayBeanProxy(this.fProxyFactoryRegistry, anObject, this);
    }

    public String getFormalTypeName() {
        String name = this.getTypeName();
        int dims = name.lastIndexOf(91) + 1;
        String type = this.getFinalComponentType().getTypeName();
        StringBuffer formalType = new StringBuffer(type.length() + "[]".length() * dims);
        formalType.append(type);
        int i = 0;
        while (i < dims) {
            formalType.append("[]");
            ++i;
        }
        return formalType.toString();
    }
}

