/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.ide.IDEBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEConstructorTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEFieldTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEMethodTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;

public class IDEMethodProxyFactory
implements IMethodProxyFactory {
    protected final IDEProxyFactoryRegistry fProxyFactoryRegistry;
    protected static final Map primLookup = new HashMap();
    IDEBeanTypeProxy fieldType;
    IDEBeanTypeProxy methodType;
    IDEBeanTypeProxy constructorType;

    static {
        primLookup.put("int", Integer.TYPE);
        primLookup.put("char", Character.TYPE);
        primLookup.put("long", Long.TYPE);
        primLookup.put("short", Short.TYPE);
        primLookup.put("double", Double.TYPE);
        primLookup.put("boolean", Boolean.TYPE);
        primLookup.put("byte", Byte.TYPE);
        primLookup.put("float", Float.TYPE);
    }

    IDEMethodProxyFactory(IDEProxyFactoryRegistry aRegistry) {
        this.fProxyFactoryRegistry = aRegistry;
        this.fProxyFactoryRegistry.registerMethodProxyFactory(this);
        this.fieldType = new IDEFieldTypeProxy(aRegistry);
        this.methodType = new IDEMethodTypeProxy(aRegistry);
        this.constructorType = new IDEConstructorTypeProxy(aRegistry);
        this.fProxyFactoryRegistry.getBeanTypeProxyFactory().registerBeanTypeProxy((IBeanTypeProxy)this.fieldType, true);
        this.fProxyFactoryRegistry.getBeanTypeProxyFactory().registerBeanTypeProxy((IBeanTypeProxy)this.methodType, true);
        this.fProxyFactoryRegistry.getBeanTypeProxyFactory().registerBeanTypeProxy((IBeanTypeProxy)this.constructorType, true);
    }

    IConstructorProxy getConstructorProxy(Constructor aConstructor) {
        return (IConstructorProxy)this.constructorType.newBeanProxy(aConstructor);
    }

    IConstructorProxy getConstructorProxy(Class aClass, Class[] args) {
        try {
            Constructor ctor = aClass.getConstructor(args);
            return this.getConstructorProxy(ctor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    IFieldProxy getFieldProxy(Field aField) {
        return (IFieldProxy)this.fieldType.newBeanProxy(aField);
    }

    IMethodProxy getMethodProxy(Method aMethod) {
        return (IMethodProxy)this.methodType.newBeanProxy(aMethod);
    }

    public IMethodProxy getMethodProxy(String className, String methodName, String[] parameterTypes) {
        try {
            Class aClass = this.fProxyFactoryRegistry.loadClass(className);
            return this.getMethodProxy(aClass, methodName, parameterTypes);
        }
        catch (ClassNotFoundException exc) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)exc));
            return null;
        }
    }

    public IMethodProxy getMethodProxy(Class cls, String methodName, String[] parameterTypes) {
        try {
            Class[] parmClasses = null;
            if (parameterTypes != null) {
                parmClasses = new Class[parameterTypes.length];
                int i = 0;
                while (i < parmClasses.length) {
                    Class temp = (Class)primLookup.get(parameterTypes[i]);
                    if (temp == null) {
                        temp = this.fProxyFactoryRegistry.loadClass(parameterTypes[i]);
                    }
                    parmClasses[i] = temp;
                    ++i;
                }
            }
            return this.getMethodProxy(cls.getMethod(methodName, parmClasses));
        }
        catch (ClassNotFoundException e) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
        }
        return null;
    }

    IMethodProxy getMethodProxy(Class aClass, String methodName, Class[] args) {
        try {
            Method method = aClass.getMethod(methodName, args);
            return this.getMethodProxy(method);
        }
        catch (NoSuchMethodException exc) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "Unable to find method " + aClass.getName() + ":" + methodName + " args=" + args, (Throwable)exc));
            return null;
        }
    }

    IMethodProxy getMethodProxy(IDEBeanTypeProxy aTypeProxy, String methodName, String[] parameterTypes) {
        return this.getMethodProxy(aTypeProxy.fClass, methodName, parameterTypes);
    }

    public void terminateFactory() {
    }
}

