/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.codegen;

import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.ve.internal.java.codegen.core.IDiagramModelInstance;
import org.eclipse.ve.internal.java.codegen.java.ExpressionDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.ExpressionDecoderHelper;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.IExpressionDecoder;
import org.eclipse.ve.internal.java.codegen.java.IJavaFeatureMapper;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.ExpressionTemplate;
import org.eclipse.ve.internal.jcm.MemberContainer;

public class ConstraintDecoderHelper
extends ExpressionDecoderHelper {
    public static final String DIMENSION_CLASS = "java.awt.Dimension";
    public static final String RECTANGLE_CLASS = "java.awt.Rectangle";
    int[] fConstraints = null;

    public ConstraintDecoderHelper(BeanPart bean, Statement exp, IJavaFeatureMapper fm, IExpressionDecoder owner) {
        super(bean, exp, fm, owner);
    }

    public static void addRactangleFeatureValue(MemberContainer pOwner, EObject target, int[] args, EStructuralFeature sf, IDiagramModelInstance cm) throws Exception {
        if (args.length != 4) {
            throw new RuntimeException("Invalid Args");
        }
        IJavaObjectInstance value = (IJavaObjectInstance)CodeGenUtil.createInstance((String)RECTANGLE_CLASS, (IDiagramModelInstance)cm);
        value.setInitializationString("new java.awt.Rectangle(" + Integer.toString(args[0]) + "," + Integer.toString(args[1]) + "," + Integer.toString(args[2]) + "," + Integer.toString(args[3]) + ")");
        CodeGenUtil.propertyCleanup((EObject)target, (EStructuralFeature)sf);
        pOwner.getProperties().add(value);
        target.eSet(sf, (Object)value);
    }

    public static void addDimensionFeatureValue(MemberContainer pOwner, EObject target, int[] args, EStructuralFeature sf, IDiagramModelInstance cm) throws Exception {
        if (args.length != 2) {
            throw new RuntimeException("Invalid args");
        }
        IJavaObjectInstance value = (IJavaObjectInstance)CodeGenUtil.createInstance((String)DIMENSION_CLASS, (IDiagramModelInstance)cm);
        value.setInitializationString("new java.awt.Dimension(" + Integer.toString(args[0]) + "," + Integer.toString(args[1]) + ")");
        CodeGenUtil.propertyCleanup((EObject)target, (EStructuralFeature)sf);
        pOwner.getProperties().add(value);
        target.eSet(sf, (Object)value);
    }

    protected boolean addConstraintFeature() throws CodeGenException {
        block10: {
            if (this.fbeanPart.getEObject() == null || this.fFmapper.getMethodName() == null) {
                throw new CodeGenException("null EObject:" + this.fExpr);
            }
            try {
                if (this.fFmapper.getMethodName().equals("setBounds")) {
                    if (((MessageSend)this.fExpr).arguments.length == 4) {
                        this.fConstraints = new int[4];
                        int i = 0;
                        while (i < 4) {
                            this.fConstraints[i] = Integer.parseInt(((MessageSend)this.fExpr).arguments[i].toString());
                            ++i;
                        }
                        ConstraintDecoderHelper.addRactangleFeatureValue((MemberContainer)this.fbeanPart.getInitMethod().getCompMethod(), this.fbeanPart.getEObject(), this.fConstraints, this.fFmapper.getFeature(null), this.fOwner.getCompositionModel());
                        break block10;
                    }
                    CodeGenUtil.logParsingError((String)this.fExpr.toString(), (String)this.fbeanPart.getInitMethod().getMethodName(), (String)"Invalid Format: bound, number of arguments is not 4", (boolean)false);
                    return false;
                }
                if (this.fFmapper.getMethodName().equals("setSize")) {
                    if (((MessageSend)this.fExpr).arguments.length == 2) {
                        this.fConstraints = new int[2];
                        int i = 0;
                        while (i < 2) {
                            this.fConstraints[i] = Integer.parseInt(((MessageSend)this.fExpr).arguments[i].toString());
                            ++i;
                        }
                        ConstraintDecoderHelper.addDimensionFeatureValue((MemberContainer)this.fbeanPart.getInitMethod().getCompMethod(), this.fbeanPart.getEObject(), this.fConstraints, this.fFmapper.getFeature(null), this.fOwner.getCompositionModel());
                        break block10;
                    }
                    CodeGenUtil.logParsingError((String)this.fExpr.toString(), (String)this.fbeanPart.getInitMethod().getMethodName(), (String)"Invalid Format: size, number of arguments is not 2", (boolean)false);
                    return false;
                }
                if (((MessageSend)this.fExpr).arguments.length == 1 && ((MessageSend)this.fExpr).arguments[1] instanceof StringLiteral) {
                    String constraint = ((MessageSend)this.fExpr).arguments[1].toString();
                    CodeGenUtil.addConstraintString((MemberContainer)this.fbeanPart.getInitMethod().getCompMethod(), (EObject)this.fbeanPart.getEObject(), (String)constraint, (EStructuralFeature)this.fFmapper.getFeature(null), (IDiagramModelInstance)this.fOwner.getCompositionModel());
                    break block10;
                }
                return false;
            }
            catch (Exception e) {
                throw new CodeGenException((Throwable)e);
            }
        }
        return true;
    }

    protected String getArgs(String exp) {
        int[] indexes = this.getArgsIndexes(exp);
        if (indexes == null) {
            return null;
        }
        return exp.substring(indexes[0], indexes[1] + 1);
    }

    protected int[] getArgsIndexes(String exp) {
        int left = exp.indexOf(40);
        int right = exp.indexOf(41);
        if (left < 0 || right < 0) {
            return null;
        }
        if (++left > --right) {
            return null;
        }
        int[] indexes = new int[]{left, right};
        return indexes;
    }

    protected int[] parseArgs(String exp) {
        if (exp == null || this.getArgs(exp) == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(this.getArgs(exp), ",");
        int[] args = new int[st.countTokens()];
        int i = 0;
        while (i < args.length) {
            args[i] = Integer.parseInt(st.nextToken().trim());
            ++i;
        }
        return args;
    }

    protected boolean sameConstraints(int[] A, int[] B) {
        if (A.length != B.length) {
            return false;
        }
        int i = 0;
        while (i < A.length) {
            if (A[i] != B[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected int[] getCompositionConstraints() throws CodeGenException {
        IJavaObjectInstance curValue = (IJavaObjectInstance)this.fbeanPart.getEObject().eGet(this.fFmapper.getFeature(this.fExpr));
        return this.parseArgs(curValue.getInitializationString());
    }

    protected String constraintsToString(int[] constraints) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < constraints.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(Integer.toString(constraints[i]));
            ++i;
        }
        return sb.toString();
    }

    public String primRefreshFromComposition(String expSig) throws CodeGenException {
        int[] curConstraints = this.getCompositionConstraints();
        if (this.fConstraints != null) {
            if (this.sameConstraints(curConstraints, this.fConstraints)) {
                this.fExprSig = expSig;
            } else if (curConstraints.length != this.fConstraints.length) {
                this.fExprSig = this.generate(null);
                this.fExprSig = this.fExprSig.substring(0, this.fExprSig.indexOf(")") + 1);
            } else {
                int[] curArgsIndexes = this.getArgsIndexes(expSig);
                String newArgs = this.constraintsToString(curConstraints);
                this.fConstraints = curConstraints;
                this.fExprSig = String.valueOf(expSig.substring(0, curArgsIndexes[0])) + newArgs + expSig.substring(curArgsIndexes[1] + 1, expSig.length());
            }
        }
        return this.fExprSig;
    }

    public boolean primIsDeleted() {
        return this.fbeanPart.getEObject().eGet(this.fFmapper.getFeature(this.fExpr)) == null;
    }

    public boolean decode() throws CodeGenException {
        return this.addConstraintFeature();
    }

    public void delete() {
        this.unadaptToCompositionModel();
        EStructuralFeature sf = this.fFmapper.getFeature(this.fExpr);
        IJavaObjectInstance parent = (IJavaObjectInstance)this.fbeanPart.getEObject();
        EObject setting = (EObject)parent.eGet(sf);
        if (setting != null) {
            this.cleanProperty(setting);
        }
        parent.eUnset(sf);
    }

    /*
     * WARNING - void declaration
     */
    protected ExpressionTemplate getExpressionTemplate(String[] args) throws CodeGenException {
        void var2_2;
        String mtd;
        if (this.fFmapper.getDecorator() != null) {
            return super.getExpressionTemplate(args);
        }
        if (this.fConstraints.length == 2) {
            mtd = "setSize";
        } else if (this.fConstraints.length == 4) {
            mtd = "setBounds";
        } else {
            throw new CodeGenException("Can not resolve write method");
        }
        String sel = this.fbeanPart.getSimpleName();
        ExpressionTemplate exp = new ExpressionTemplate(sel, (String)var2_2, args, null, 0);
        exp.setLineSeperator(this.fbeanPart.getModel().getLineSeperator());
        return exp;
    }

    public String generate(Object[] noArgs) throws CodeGenException {
        if (this.fFmapper.getFeature(null) == null) {
            throw new CodeGenException("null Feature");
        }
        try {
            this.fConstraints = this.getCompositionConstraints();
        }
        catch (CodeGenException codeGenException) {
            return null;
        }
        ExpressionTemplate exp = this.getExpressionTemplate(new String[]{this.constraintsToString(this.fConstraints)});
        this.fExprSig = exp.toString();
        return this.fExprSig;
    }

    public boolean isImplicit(Object[] args) {
        return false;
    }

    public Object[] getArgsHandles(Statement expr) {
        return null;
    }

    public void adaptToCompositionModel(IExpressionDecoder decoder) {
        super.adaptToCompositionModel(decoder);
        IJavaInstance o = (IJavaInstance)this.fbeanPart.getEObject().eGet(this.fFmapper.getFeature(null));
        if (o != null) {
            o.eAdapters().add(new ExpressionDecoderAdapter(decoder).getShadowSourceRangeAdapter());
        }
    }

    public void unadaptToCompositionModel() {
        ICodeGenAdapter a;
        super.unadaptToCompositionModel();
        IJavaInstance o = (IJavaInstance)this.fbeanPart.getEObject().eGet(this.fFmapper.getFeature(null));
        if (o != null && (a = (ICodeGenAdapter)EcoreUtil.getExistingAdapter((Notifier)o, (Object)ICodeGenAdapter.JVE_CODEGEN_EXPRESSION_SOURCE_RANGE)) != null) {
            o.eAdapters().remove(a);
        }
    }

    protected int getSFPriority() {
        return 5 + super.getSFPriority();
    }
}

