/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.workbench;

import com.ibm.etools.emf.ecore.utilities.DefaultOverridableResourceFactoryRegistry;
import com.ibm.etools.emf.workbench.EMFNatureFactory;
import com.ibm.etools.emf.workbench.ProjectResourceSet;
import com.ibm.etools.emf.workbench.ProjectResourceSetImpl;
import com.ibm.etools.emf.workbench.ReferencedXMIFactoryImpl;
import com.ibm.etools.emf.workbench.ResourceSetWorkbenchSynchronizer;
import com.ibm.etools.emf.workbench.WorkbenchURIConverter;
import com.ibm.etools.emf.workbench.WorkbenchURIConverterImpl;
import com.ibm.etools.emf.workbench.WorkspaceResourceHandler;
import com.ibm.etools.emf.workbench.plugin.EMFWorkbenchPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.resource.Resource;

public class EMFNature {
    protected IProject project;
    protected ProjectResourceSet resourceSet;

    public EMFNature(IProject aProject) {
        this.project = aProject;
    }

    public void dispose() {
        if (this.resourceSet != null) {
            this.resourceSet.release();
        }
        this.resourceSet = null;
        this.project = null;
    }

    public IProject getProject() {
        return this.project;
    }

    public ProjectResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = this.createResourceSet();
            this.initializeResourceSet(this.resourceSet);
        }
        return this.resourceSet;
    }

    public boolean hasResourceSet() {
        return this.resourceSet != null;
    }

    protected void initializeResourceSet(ProjectResourceSet aResourceSet) {
        this.createResourceSetSynchronizer(aResourceSet);
        aResourceSet.setURIConverter(this.createURIConverter(aResourceSet));
        DefaultOverridableResourceFactoryRegistry reg = new DefaultOverridableResourceFactoryRegistry();
        ReferencedXMIFactoryImpl factory = new ReferencedXMIFactoryImpl();
        reg.getExtensionToFactoryMap().put("*", factory);
        reg.getExtensionToFactoryMap().put("xmi", factory);
        aResourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)reg);
        aResourceSet.add(new WorkspaceResourceHandler());
        EMFWorkbenchPlugin.getDefault().addExtendedResourceHandlers(aResourceSet);
    }

    protected ProjectResourceSet createResourceSet() {
        return new ProjectResourceSetImpl(this.getProject());
    }

    protected WorkbenchURIConverter createURIConverter(ProjectResourceSet aResourceSet) {
        return new WorkbenchURIConverterImpl((IContainer)this.getProject(), aResourceSet.getSynchronizer());
    }

    protected ResourceSetWorkbenchSynchronizer createResourceSetSynchronizer(ProjectResourceSet aResourceSet) {
        return EMFNatureFactory.INSTANCE.createSynchronizer(aResourceSet, this.getProject());
    }
}

