/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.workbench;

import com.ibm.etools.emf.workbench.ProjectResourceSet;
import com.ibm.etools.emf.workbench.WorkbenchURIConverter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;

public class ProjectUtilities {
    private static final String copyright = "(c) Copyright IBM Corporation 2002.";
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public static void addNatureToProject(IProject proj, String natureId) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
        newNatures[0] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, null);
    }

    public static void addNatureToProjectLast(IProject proj, String natureId) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, null);
    }

    public static void addReferenceProjects(IProject project, List toBeAddedProjectsList) throws CoreException {
        IProjectDescription description = project.getDescription();
        IProject[] projects = description.getReferencedProjects();
        ArrayList<Project> projectsList = new ArrayList<Project>();
        int i = 0;
        while (i < projects.length) {
            projectsList.add((Project)projects[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < toBeAddedProjectsList.size()) {
            projectsList.add((Project)toBeAddedProjectsList.get(i2));
            ++i2;
        }
        Project[] refProjects = new Project[projectsList.size()];
        int i3 = 0;
        while (i3 < refProjects.length) {
            refProjects[i3] = (Project)projectsList.get(i3);
            ++i3;
        }
        description.setReferencedProjects((IProject[])refProjects);
        project.setDescription(description, null);
    }

    public static void addReferenceProjects(IProject project, IProject projectToBeAdded) throws CoreException {
        IProjectDescription description = project.getDescription();
        IProject[] projects = description.getReferencedProjects();
        ArrayList<Object> projectsList = new ArrayList<Object>();
        int i = 0;
        while (i < projects.length) {
            projectsList.add((Project)projects[i]);
            ++i;
        }
        projectsList.add(projectToBeAdded);
        Project[] refProjects = new Project[projectsList.size()];
        int i2 = 0;
        while (i2 < refProjects.length) {
            refProjects[i2] = (Project)projectsList.get(i2);
            ++i2;
        }
        description.setReferencedProjects((IProject[])refProjects);
        project.setDescription(description, null);
    }

    public static void forceAutoBuild(IProject project, IProgressMonitor progressMonitor) {
        try {
            project.build(6, progressMonitor);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static boolean getCurrentAutoBuildSetting() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription wd = workspace.getDescription();
        return wd.isAutoBuilding();
    }

    public static IProject getProject(Object object, String natureId) {
        IProject result = null;
        IResource selectedResource = null;
        result = null;
        if (object instanceof EObject) {
            result = ProjectUtilities.getProject((EObject)object);
        } else if (object instanceof IResource) {
            selectedResource = (IResource)object;
        } else if (object instanceof IAdaptable) {
            selectedResource = (IResource)((IAdaptable)object).getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = ProjectUtilities.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        }
        if (selectedResource != null) {
            result = selectedResource.getProject();
        }
        if (result != null && result.isOpen()) {
            try {
                if (result.hasNature(natureId)) {
                    return result;
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static IProject getProject(EObject aRefObject) {
        if (aRefObject != null) {
            URIConverter converter;
            ResourceSet set;
            Resource resource = aRefObject.eResource();
            ResourceSet resourceSet = set = resource == null ? null : resource.getResourceSet();
            if (set instanceof ProjectResourceSet) {
                return ((ProjectResourceSet)set).getProject();
            }
            URIConverter uRIConverter = converter = set == null ? null : set.getURIConverter();
            if (converter != null && converter instanceof WorkbenchURIConverter && ((WorkbenchURIConverter)converter).getOutputContainer() != null) {
                return ((WorkbenchURIConverter)converter).getOutputContainer().getProject();
            }
        }
        return null;
    }

    public static void removeReferenceProjects(IProject project, List toBeRemovedProjectList) throws CoreException {
        IProjectDescription description = project.getDescription();
        IProject[] projects = description.getReferencedProjects();
        ArrayList<Project> projectsList = new ArrayList<Project>();
        int i = 0;
        while (i < projects.length) {
            projectsList.add((Project)projects[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < toBeRemovedProjectList.size()) {
            ((AbstractCollection)projectsList).remove(toBeRemovedProjectList.get(i2));
            ++i2;
        }
        Project[] refProjects = new Project[projectsList.size()];
        int i3 = 0;
        while (i3 < refProjects.length) {
            refProjects[i3] = (Project)projectsList.get(i3);
            ++i3;
        }
        description.setReferencedProjects((IProject[])refProjects);
        project.setDescription(description, null);
    }

    public static void removeReferenceProjects(IProject project, IProject toBeRemovedProject) throws CoreException {
        IProjectDescription description = project.getDescription();
        IProject[] projects = description.getReferencedProjects();
        ArrayList<Project> projectsList = new ArrayList<Project>();
        int i = 0;
        while (i < projects.length) {
            projectsList.add((Project)projects[i]);
            ++i;
        }
        ((AbstractCollection)projectsList).remove(toBeRemovedProject);
        Project[] refProjects = new Project[projectsList.size()];
        int i2 = 0;
        while (i2 < refProjects.length) {
            refProjects[i2] = (Project)projectsList.get(i2);
            ++i2;
        }
        description.setReferencedProjects((IProject[])refProjects);
        project.setDescription(description, null);
    }

    public static void turnAutoBuildOff() {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription wd = workspace.getDescription();
            wd.setAutoBuilding(false);
            workspace.setDescription(wd);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void turnAutoBuildOn() {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription wd = workspace.getDescription();
            wd.setAutoBuilding(true);
            workspace.setDescription(wd);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void turnAutoBuildOn(boolean aBoolean) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription wd = workspace.getDescription();
            wd.setAutoBuilding(aBoolean);
            workspace.setDescription(wd);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static boolean addToBuildSpec(String builderID, IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            newCommands[newCommands.length - 1] = command;
            description.setBuildSpec(newCommands);
            project.setDescription(description, null);
        }
        return !found;
    }

    public static boolean removeFromBuildSpec(String builderID, IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            ICommand[] newCommands = new ICommand[commands.length - 1];
            int newCount = 0;
            int i2 = 0;
            while (i2 < commands.length) {
                if (!commands[i2].getBuilderName().equals(builderID)) {
                    newCommands[newCount] = commands[i2];
                    ++newCount;
                }
                ++i2;
            }
            description.setBuildSpec(newCommands);
            project.setDescription(description, null);
        }
        return found;
    }

    public static void ensureContainerNotReadOnly(IResource resource) {
        if (resource != null && !resource.exists()) {
            IContainer container = resource.getParent();
            while (container != null && !container.isReadOnly()) {
                container = container.getParent();
            }
            if (container != null) {
                container.setReadOnly(false);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

