/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.workbench;

import com.ibm.etools.emf.ecore.utilities.IDUtil;
import com.ibm.etools.emf.workbench.ReferencedResource;
import com.ibm.etools.emf.workbench.WorkbenchResourceHelper;
import com.ibm.etools.emf.workbench.plugin.EMFWorkbenchPlugin;
import com.ibm.etools.xmi.helpers.CompatibilityXMIResourceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class ReferencedXMIResourceImpl
extends CompatibilityXMIResourceImpl
implements ReferencedResource {
    private static final String TO_STRING = "ReferencedXMIResource, file = ";
    private static final String READ_COUNT_TO_STRING = " R= ";
    private static final String WRITE_COUNT_TO_STRING = " W= ";
    private int readReferenceCount = 1;
    private int editReferenceCount = 0;
    protected boolean isNew = true;
    protected long synchronizationStamp;
    protected IFile file;
    protected ResourceSet previousResourceSet;
    protected boolean forceRefresh;

    public ReferencedXMIResourceImpl() {
    }

    public ReferencedXMIResourceImpl(URI uri) {
        super(uri);
    }

    public boolean isConsistent() {
        if (this.getFile() == null || !this.getFile().isAccessible()) {
            return true;
        }
        if (!this.getFile().isSynchronized(0)) {
            return false;
        }
        if (this.synchronizationStamp == 0L) {
            return true;
        }
        return this.synchronizationStamp == EMFWorkbenchPlugin.getResourceHelper().computeModificationStamp(this);
    }

    public long getSynchronizationStamp() {
        return this.synchronizationStamp;
    }

    public void setSynchronizationStamp(long aLong) {
        this.synchronizationStamp = aLong;
    }

    public void accessForRead() {
        this.checkDeleted();
        if (!this.isNew()) {
            ++this.readReferenceCount;
        }
        this.isNew = false;
    }

    public void accessForWrite() {
        this.checkDeleted();
        ++this.editReferenceCount;
        if (this.isNew) {
            --this.readReferenceCount;
        }
        this.isNew = false;
        if (!this.isTrackingModification()) {
            this.setTrackingModification(true);
        }
    }

    protected void checkDeleted() {
        if (this.getResourceSet() == null) {
            throw new RuntimeException("This resource has been deleted and can no longer be used.");
        }
    }

    public void collectContainedObjects(List collecting, EObject parentObject) {
        Iterator children = parentObject.eContents().iterator();
        while (children.hasNext()) {
            EObject child = (EObject)children.next();
            collecting.add(child);
            this.collectContainedObjects(collecting, child);
        }
    }

    public void ensureFullIDHydration() {
        ArrayList<EObject> allRefObjects = new ArrayList<EObject>();
        Iterator rootObjects = this.getContents().iterator();
        while (rootObjects.hasNext()) {
            EObject child = (EObject)rootObjects.next();
            allRefObjects.add(child);
            this.collectContainedObjects(allRefObjects, child);
        }
        Iterator iter = allRefObjects.iterator();
        while (iter.hasNext()) {
            IDUtil.assignID((EObject)((EObject)iter.next()), (XMLResource)this);
        }
    }

    protected void unloadIfNecessary() {
        if (this.getTotalReferenceCount() <= 0 || this.editReferenceCount <= 0 && this.isModified()) {
            this.unload();
        }
    }

    protected int getTotalReferenceCount() {
        return this.editReferenceCount + this.readReferenceCount;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isReadOnly() {
        return this.editReferenceCount <= 0;
    }

    public boolean isShared() {
        return this.getTotalReferenceCount() > 1;
    }

    public boolean isSharedForWrite() {
        return this.editReferenceCount > 1;
    }

    public void preDelete() {
    }

    public void releaseFromRead() {
        --this.readReferenceCount;
        if (this.readReferenceCount < 0) {
            throw new RuntimeException("Read reference count error:  " + this.toString());
        }
        this.unloadIfNecessary();
    }

    public void releaseFromWrite() {
        --this.editReferenceCount;
        if (this.editReferenceCount < 0) {
            throw new RuntimeException("Write reference count error:  " + this.toString());
        }
        this.unloadIfNecessary();
    }

    public void saveIfNecessary() throws Exception {
        if (!this.isSharedForWrite()) {
            this.save(Collections.EMPTY_MAP);
        }
    }

    public String toString() {
        return TO_STRING + this.getURI().toString() + READ_COUNT_TO_STRING + new Integer(this.readReferenceCount) + WRITE_COUNT_TO_STRING + new Integer(this.editReferenceCount);
    }

    public boolean needsToSave() {
        return this.isModified() && !this.isSharedForWrite();
    }

    public IFile getFile() {
        if (!(this.file == null || this.file.isAccessible() && this.previousResourceSet == this.getResourceSet())) {
            this.file = null;
            this.synchronizationStamp = 0L;
        }
        if (this.file == null) {
            WorkbenchResourceHelper helper = EMFWorkbenchPlugin.getResourceHelper();
            this.file = helper.isPlatformResourceURI(this.getURI()) ? helper.getPlatformFile(this.getURI()) : helper.internalGetFile(this);
            this.previousResourceSet = this.getResourceSet();
        }
        return this.file;
    }

    public void setForceRefresh(boolean b) {
        this.forceRefresh = b;
    }

    public boolean shouldForceRefresh() {
        return this.forceRefresh;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void basicDoLoad(InputStream arg0, Map arg1) throws IOException {
        boolean isTrackingMods = this.isTrackingModification();
        try {
            if (isTrackingMods) {
                this.setTrackingModification(false);
            }
            super.basicDoLoad(arg0, arg1);
            this.cacheSynchronizationStamp();
            Object var5_4 = null;
            if (!isTrackingMods) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!isTrackingMods) throw throwable;
            this.setTrackingModification(true);
            throw throwable;
        }
        this.setTrackingModification(true);
    }

    protected void doUnload() {
        this.file = null;
        this.synchronizationStamp = 0L;
        if (this.isTrackingModification() && this.editReferenceCount < 1) {
            this.setTrackingModification(false);
        }
        super.doUnload();
        this.setForceRefresh(false);
        this.setModified(false);
    }

    public void save(Map options) throws IOException {
        super.save(options);
        this.cacheSynchronizationStamp();
    }

    private void cacheSynchronizationStamp() {
        WorkbenchResourceHelper helper = EMFWorkbenchPlugin.getResourceHelper();
        this.setSynchronizationStamp(helper.computeModificationStamp(this.getFile()));
    }

    public boolean wasReverted() {
        return false;
    }
}

