/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.workbench;

import com.ibm.etools.emf.ecore.utilities.ExtendedEcoreUtil;
import com.ibm.etools.emf.workbench.EMFNature;
import com.ibm.etools.emf.workbench.EMFNatureContributor;
import com.ibm.etools.emf.workbench.EMFNatureFactory;
import com.ibm.etools.emf.workbench.ProjectResourceSet;
import com.ibm.etools.emf.workbench.ReferencedResource;
import com.ibm.etools.emf.workbench.WorkbenchURIConverter;
import com.ibm.etools.emf.workbench.WorkspaceResourceHandler;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.InternalEList;

public class WorkbenchResourceHelper {
    protected static Class REFERENCED_RES_CLASS = class$com$ibm$etools$emf$workbench$ReferencedResource == null ? (class$com$ibm$etools$emf$workbench$ReferencedResource = WorkbenchResourceHelper.class$("com.ibm.etools.emf.workbench.ReferencedResource")) : class$com$ibm$etools$emf$workbench$ReferencedResource;
    protected static Boolean HEADLESS = null;
    protected WorkspaceResourceHandler workspaceURILoader = new WorkspaceResourceHandler();
    static /* synthetic */ Class class$com$ibm$etools$emf$workbench$ReferencedResource;

    protected void resolveContainedProxies(EObject refObject) {
        EList contained = refObject.eContents();
        int i = 0;
        while (i < contained.size()) {
            EObject mofObject = (EObject)contained.get(i);
            this.resolveProxies(mofObject);
            ++i;
        }
    }

    public EMFNatureFactory getEMFNatureFactory() {
        return EMFNatureFactory.INSTANCE;
    }

    protected void resolveNonContainedProxies(EObject refObject) {
        EList references = refObject.eClass().getEAllReferences();
        int i = 0;
        while (i < references.size()) {
            EReference reference = (EReference)references.get(i);
            if (!reference.isContainment()) {
                if (reference.isMany()) {
                    List value = (List)refObject.eGet((EStructuralFeature)reference);
                    int j = 0;
                    while (j < value.size()) {
                        value.get(j);
                        ++j;
                    }
                } else {
                    refObject.eGet((EStructuralFeature)reference);
                }
            }
            ++i;
        }
    }

    public static boolean isReferencedResource(Resource aResource) {
        return REFERENCED_RES_CLASS.isInstance(aResource);
    }

    public void resolveProxies(Resource resource) {
        if (resource != null) {
            EList topLevels = resource.getContents();
            int i = 0;
            while (i < topLevels.size()) {
                EObject mofObject = (EObject)topLevels.get(i);
                this.resolveProxies(mofObject);
                ++i;
            }
        }
    }

    public List gatherProxies(Resource resource) {
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList list = new ArrayList();
        EList topLevels = resource.getContents();
        int size = topLevels.size();
        int i = 0;
        while (i < size) {
            EObject mofObject = (EObject)topLevels.get(i);
            this.gatherProxies((InternalEObject)mofObject, list);
            ++i;
        }
        return list;
    }

    protected void gatherProxies(InternalEObject refObject, List proxies) {
        if (refObject == null) {
            return;
        }
        EList contains = refObject.eClass().getEAllContainments();
        if (contains != null) {
            int size = contains.size();
            EStructuralFeature sf = null;
            int i = 0;
            while (i < size) {
                sf = (EStructuralFeature)contains.get(i);
                this.gatherProxies(refObject, sf, proxies);
                ++i;
            }
        }
    }

    protected void gatherProxies(InternalEObject refObject, EStructuralFeature sf, List proxies) {
        Object value = null;
        InternalEObject proxy = null;
        if ((sf.isMany() || refObject.eIsSet(sf)) && (value = refObject.eGet(sf, false)) != null) {
            if (sf.isMany()) {
                Iterator j = ((InternalEList)value).basicIterator();
                while (j.hasNext()) {
                    proxy = (InternalEObject)j.next();
                    if (!proxy.eIsProxy()) continue;
                    proxies.add(proxy);
                }
            } else if (((InternalEObject)value).eIsProxy()) {
                proxies.add(value);
            }
        }
    }

    protected void resolveProxies(EObject refObject) {
        if (refObject != null) {
            this.resolveNonContainedProxies(refObject);
            this.resolveContainedProxies(refObject);
        }
    }

    public EMFNature getEMFNature(IProject aProject) {
        return EMFNatureFactory.INSTANCE.getEMFNature(aProject);
    }

    public Resource createResource(URI uri) {
        ResourceSet set = this.getResourceSet(uri);
        if (set != null) {
            return set.createResource(uri);
        }
        return null;
    }

    public Resource getExistingOrCreateResource(URI uri) {
        return this.getExistingOrCreateResource(uri, this.getResourceSet(uri));
    }

    public Resource getExistingOrCreateResource(URI uri, ResourceSet set) {
        Resource res = null;
        if (set != null && (res = set.getResource(uri, false)) == null) {
            res = set.createResource(uri);
        }
        return res;
    }

    public EMFNature createEMFNature(IProject aProject, EMFNatureContributor contributor) {
        return EMFNatureFactory.INSTANCE.createEMFNature(aProject, contributor);
    }

    public IFile getFile(Resource aResource) {
        if (aResource != null) {
            if (WorkbenchResourceHelper.isReferencedResource(aResource)) {
                return ((ReferencedResource)aResource).getFile();
            }
            return this.internalGetFile(aResource);
        }
        return null;
    }

    public boolean isPlatformResourceURI(URI uri) {
        return "platform".equals(uri.scheme()) && "resource".equals(uri.segment(0));
    }

    public IFile getPlatformFile(URI uri) {
        if (this.isPlatformResourceURI(uri)) {
            String fileString = uri.path();
            fileString = fileString.substring("resource".length() + 1);
            return this.getWorkspace().getRoot().getFile((IPath)new Path(fileString));
        }
        return null;
    }

    public IFile internalGetFile(Resource aResource) {
        if (aResource != null) {
            URI uri = aResource.getURI();
            IFile file = this.getPlatformFile(uri);
            if (file == null) {
                URIConverter converter;
                URI convertedUri;
                ResourceSet set = aResource.getResourceSet();
                if (set != null && !uri.equals((Object)(convertedUri = (converter = set.getURIConverter()).normalize(uri)))) {
                    return this.getPlatformFile(convertedUri);
                }
            } else {
                return file;
            }
        }
        return null;
    }

    public boolean cacheResource(Resource aResource) {
        ResourceSet set;
        if (aResource != null && (set = this.getResourceSet(aResource.getURI())) != null) {
            return set.getResources().add(aResource);
        }
        return false;
    }

    public boolean cacheResource(IProject aProject, Resource aResource, IPath fullPath) {
        if (aProject == null || aResource == null || !aProject.isAccessible()) {
            return false;
        }
        ResourceSet set = this.getResourceSet(aProject);
        if (set != null) {
            URI converted = set.getURIConverter().normalize(aResource.getURI());
            if (converted != aResource.getURI()) {
                aResource.setURI(converted);
            }
            return set.getResources().add(aResource);
        }
        return false;
    }

    public String getActualProjectRelativeURI(IResource aResource) {
        if (aResource == null || !aResource.isAccessible()) {
            return null;
        }
        IProject project = aResource.getProject();
        IPath path = this.getPathInProject(project, aResource.getFullPath());
        return path.makeRelative().toString();
    }

    public IPath getPathInProject(IProject project, IPath fullPath) {
        List containers = this.getProjectURIConverterContainers(project);
        if (!containers.isEmpty()) {
            return this.getPathFromContainers(containers, fullPath);
        }
        return fullPath;
    }

    protected List getProjectURIConverterContainers(IProject project) {
        WorkbenchURIConverter conv;
        EMFNature nature = this.createEMFNature(project, null);
        if (nature != null && (conv = (WorkbenchURIConverter)nature.getResourceSet().getURIConverter()) != null) {
            return conv.getInputContainers();
        }
        return Collections.EMPTY_LIST;
    }

    public IPath getPathFromContainers(List containers, IPath fullPath) {
        IContainer container = null;
        int size = containers.size();
        int matching = -1;
        int i = 0;
        while (i < size) {
            container = (IContainer)containers.get(i);
            IPath containerPath = container.getFullPath();
            matching = fullPath.matchingFirstSegments(containerPath);
            if (matching > 0 && matching == containerPath.segmentCount()) {
                IPath result = fullPath.removeFirstSegments(matching);
                result = result.makeRelative();
                return result;
            }
            ++i;
        }
        return fullPath;
    }

    public boolean hasContainerStructure(IProject project, URI uri) {
        if (project != null && uri != null) {
            Path path = new Path(uri.toString());
            List containers = this.getProjectURIConverterContainers(project);
            int segmentCount = path.segmentCount();
            IPath containerPath = segmentCount > 1 ? path.removeLastSegments(1) : null;
            IContainer container = null;
            int i = 0;
            while (i < containers.size()) {
                IFolder folder;
                container = (IContainer)containers.get(i);
                if (container.isAccessible() && (segmentCount == 1 ? container == project : containerPath != null && (folder = container.getFolder(containerPath)) != null && folder.isAccessible())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Resource getResource(URI uri) {
        return this.workspaceURILoader.getResource(null, uri);
    }

    public Resource getResource(IFile aFile) {
        return this.getResource(aFile, false);
    }

    public Resource getResource(IFile aFile, boolean loadOnDemand) {
        if (aFile != null) {
            return this.getResource(URI.createPlatformResourceURI((String)aFile.getFullPath().toString()), loadOnDemand);
        }
        return null;
    }

    public Resource load(IFile aFile) {
        return this.getResource(aFile, true);
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        ResourceSet set = this.getResourceSet(uri);
        if (set != null) {
            return set.getResource(uri, loadOnDemand);
        }
        return null;
    }

    public ResourceSet getResourceSet(URI uri) {
        String projectName = null;
        if (this.isPlatformResourceURI(uri)) {
            projectName = uri.segment(1);
        } else {
            URI fileURI = URI.createFileURI((String)uri.toString());
            projectName = fileURI.segment(0);
        }
        IProject project = this.getWorkspace().getRoot().getProject(projectName);
        if (project != null && project.isAccessible()) {
            return this.getResourceSet(project);
        }
        return null;
    }

    public Resource getOrCreateResource(URI uri, ResourceSet set) throws WrappedException {
        try {
            return set.getResource(uri, true);
        }
        catch (WrappedException e) {
            if (ExtendedEcoreUtil.getFileNotFoundDetector().isFileNotFound(e)) {
                return set.getResource(uri, false);
            }
            throw e;
        }
    }

    public ResourceSet getResourceSet(IProject project) {
        EMFNature nat = this.createEMFNature(project, null);
        if (nat != null) {
            return nat.getResourceSet();
        }
        return null;
    }

    public boolean saveResourceToFile(Resource aResource, IFile aFile) throws Exception {
        return this.saveResourceToFile(aResource, aFile, null);
    }

    public boolean saveResourceToFile(Resource aResource, IFile aFile, Map saveOptions) throws Exception {
        URIConverter conv;
        ResourceSet set;
        if (aResource != null && aFile != null && !aFile.exists() && (set = aResource.getResourceSet()) != null && (conv = set.getURIConverter()) != null && conv instanceof WorkbenchURIConverter) {
            OutputStream os;
            int fileCount;
            WorkbenchURIConverter wbConv = (WorkbenchURIConverter)conv;
            String uri = aResource.getURI().toString();
            Path resPath = new Path(uri);
            IPath filePath = aFile.getProjectRelativePath();
            int resCount = resPath.segmentCount();
            if (resCount <= (fileCount = filePath.segmentCount()) && resPath.equals((Object)(filePath = filePath.removeFirstSegments(fileCount - resCount))) && (os = wbConv.createOutputStream(URI.createPlatformResourceURI((String)aFile.toString()))) != null) {
                try {
                    aResource.save(os, saveOptions);
                    Object var14_13 = null;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    os.close();
                    throw throwable;
                }
                os.close();
                return true;
            }
        }
        return false;
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected boolean isSameProject(Resource resourceA, Resource resourceB) {
        IProject pA = this.getProject(resourceA);
        IProject pB = this.getProject(resourceB);
        if (pA != null && pB != null) {
            return pA.equals((Object)pB);
        }
        return true;
    }

    public IProject getProject(Resource res) {
        IFile file;
        IProject proj = this.getProject(res.getResourceSet());
        if (proj == null && (file = this.getFile(res)) != null) {
            proj = file.getProject();
        }
        return proj;
    }

    protected IProject getProject(ResourceSet set) {
        if (set != null && set instanceof ProjectResourceSet) {
            ProjectResourceSet pset = (ProjectResourceSet)set;
            return pset.getProject();
        }
        return null;
    }

    protected boolean isRegisteredURIMapping(String href) {
        if (href != null) {
            String file = href;
            int index = href.indexOf(35);
            if (index > -1) {
                file = href.substring(0, index);
            }
            return URIConverter.URI_MAP.get(file) != null;
        }
        return false;
    }

    public long computeModificationStamp(ReferencedResource resource) {
        return this.computeModificationStamp(resource.getFile());
    }

    public long computeModificationStamp(IFile file) {
        if (file == null) {
            return 0L;
        }
        long currentStamp = file.getModificationStamp();
        IPath path = file.getLocation();
        if (path != null) {
            return path.toFile().lastModified();
        }
        return currentStamp;
    }

    public void removeAndUnloadAll(List resources, ResourceSet aSet) {
        if (aSet == null || resources == null || resources.isEmpty()) {
            return;
        }
        aSet.getResources().removeAll(resources);
        int i = 0;
        while (i < resources.size()) {
            Resource res = (Resource)resources.get(i);
            res.unload();
            ++i;
        }
    }

    public boolean becomeProxy(EObject anObject) {
        Resource res;
        if (anObject != null && (res = anObject.eResource()) != null) {
            URI uri = res.getURI();
            ((InternalEObject)anObject).eSetProxyURI(uri.appendFragment(res.getURIFragment(anObject)));
            return true;
        }
        return false;
    }

    public boolean isResourceNotFound(WrappedException wrappedEx) {
        Exception excep = wrappedEx.exception();
        while (excep instanceof WrappedException) {
            excep = ((WrappedException)((Object)excep)).exception();
        }
        return this.primIsResourceNotFound(excep);
    }

    private boolean primIsResourceNotFound(Exception excep) {
        if (excep instanceof ResourceException) {
            IStatus status = ((ResourceException)excep).getStatus();
            return status.getCode() == 368;
        }
        return false;
    }

    public boolean isResourceNotFound(Resource.IOWrappedException wrappedEx) {
        return this.primIsResourceNotFound(wrappedEx.getWrappedException());
    }

    public URI getNonPlatformURI(URI platformURI) {
        if (this.isPlatformResourceURI(platformURI)) {
            String uriString = this.primGetNonPlatformURIString(platformURI);
            return URI.createURI((String)uriString);
        }
        return platformURI;
    }

    public String getNonPlatformURIString(URI platformURI) {
        if (this.isPlatformResourceURI(platformURI)) {
            return this.primGetNonPlatformURIString(platformURI);
        }
        return platformURI.toString();
    }

    private String primGetNonPlatformURIString(URI platformURI) {
        String uriString = platformURI.toString();
        return uriString.substring(19, uriString.length());
    }

    public static boolean isHeadless() {
        if (HEADLESS == null) {
            IPluginDescriptor desc = Platform.getPluginRegistry().getPluginDescriptor("org.eclipse.ui");
            HEADLESS = new Boolean(desc == null || !desc.isPluginActivated());
        }
        return HEADLESS;
    }

    public boolean isPlatformPluginResourceURI(URI uri) {
        return "platform".equals(uri.scheme()) && "plugin".equals(uri.segment(0));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

