/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.ecore.utilities;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class IDUtil {
    public static void assignID(EObject object) {
        Resource aResource = object.eResource();
        if (aResource instanceof XMLResource) {
            IDUtil.assignID(object, (XMLResource)aResource);
        }
    }

    public static String getOrAssignID(EObject object) {
        Resource aResource = object.eResource();
        if (aResource instanceof XMLResource) {
            return IDUtil.getOrAssignID(object, (XMLResource)aResource);
        }
        return null;
    }

    public static String getOrAssignID(EObject object, XMLResource aResource) {
        String id = aResource.getID(object);
        if (id == null) {
            return IDUtil.assignID(object, aResource);
        }
        return id;
    }

    public static String assignID(EObject object, XMLResource aResource) {
        String name = IDUtil.getBaseIDForAssignment(object);
        if (name == null) {
            return null;
        }
        String id = IDUtil.ensureUniqueID(aResource, name);
        aResource.setID(object, id);
        return id;
    }

    protected static String ensureUniqueID(XMLResource aResource, String baseIDName) {
        baseIDName = baseIDName + "_";
        long currentTime = System.currentTimeMillis();
        String id = baseIDName + currentTime;
        Map idMap = aResource.getIDToEObjectMap();
        while (idMap.get(id) != null) {
            id = baseIDName + ++currentTime;
        }
        return id;
    }

    protected static String getBaseIDForAssignment(EObject object) {
        EClass metaO = object.eClass();
        return metaO.getName();
    }
}

