/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.ecore.utilities;

import com.ibm.etools.emf.ecore.utilities.ExtendedEcoreUtil;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class IsLoadingProxyAdapter
extends AdapterImpl {
    private Resource resource;
    private Adapter targetAdapter;
    private EObject targetObject;

    public IsLoadingProxyAdapter(Adapter aTargetAdapter, EObject aTargetObject) {
        this.targetAdapter = aTargetAdapter;
        this.targetObject = aTargetObject;
    }

    public void notifyChanged(Notification msg) {
        if (this.resource != null) {
            if (msg.getFeatureID(null) == 4 && msg.getEventType() == 1) {
                this.removeProxySupport();
                this.reset();
            }
        } else if (this.cacheResource()) {
            this.targetAdapter.notifyChanged(msg);
            this.reset();
        }
    }

    private boolean cacheResource() {
        if (this.getTarget() != null) {
            EObject eObj = (EObject)this.getTarget();
            this.resource = eObj.eResource();
            if (this.resource != null) {
                eObj.eAdapters().remove((Object)this);
                if (ExtendedEcoreUtil.isLoading(this.resource)) {
                    this.resource.eAdapters().add(this);
                } else {
                    this.targetObject.eAdapters().add(this.targetAdapter);
                    return true;
                }
            }
        }
        return false;
    }

    private void removeProxySupport() {
        this.getTarget().eAdapters().remove((Object)this);
        this.targetObject.eAdapters().add(this.targetAdapter);
    }

    private void reset() {
        this.resource = null;
        this.targetAdapter = null;
        this.targetObject = null;
    }
}

