/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf2xml.impl;

import com.ibm.etools.emf2xml.EMF2DOMAdapter;
import com.ibm.etools.emf2xml.impl.AbstractEMF2DOMAdapterImpl;
import com.ibm.etools.emf2xml.impl.EMF2DOMRenderer;
import com.ibm.etools.emf2xml.impl.LinkUpdaterTarget;
import com.ibm.etools.emf2xml.impl.ReadAheadHelper;
import com.ibm.etools.emf2xml.impl.Translator;
import com.ibm.etools.emf2xml.util.DOMUtilities;
import com.ibm.etools.emf2xml.util.FeatureValueConversionException;
import com.ibm.etools.wft.util.Revisit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EMF2DOMAdapterImpl
extends AbstractEMF2DOMAdapterImpl
implements EMF2DOMAdapter {
    protected EObject fEObject;
    protected static EcorePackage ECORE_PACKAGE = EcorePackage.eINSTANCE;

    public EMF2DOMAdapterImpl(Notifier object, Node node, EMF2DOMRenderer renderer, Translator translator) {
        super(object, node, renderer, translator);
    }

    public EMF2DOMAdapterImpl(Node node, EMF2DOMRenderer renderer, Translator translator) {
        this.fNode = node;
        this.fRenderer = renderer;
        this.fTranslator = translator;
        this.setTargetFromNode();
        this.addEMFAdapter();
    }

    public EObject getEObject() {
        return this.fEObject;
    }

    protected void setTargetFromNode() {
        this.setTarget((Notifier)this.fTranslator.createEMFObject(this.fNode.getNodeName(), this.extractReadAheadName()));
    }

    protected String extractReadAheadName() {
        if (!this.fTranslator.hasReadAheadNames()) {
            return null;
        }
        String readAheadName = null;
        ReadAheadHelper helper = this.fTranslator.getReadAheadHelper(this.fNode.getNodeName());
        if (helper == null) {
            return null;
        }
        Node child = null;
        String[] names = helper.getValues();
        if (helper.getChildDOMName() == null) {
            int i = 0;
            while (i < names.length) {
                child = DOMUtilities.getNodeChild(this.fNode, names[i]);
                if (child != null) {
                    readAheadName = names[i];
                    break;
                }
                ++i;
            }
        } else {
            child = DOMUtilities.getNodeChild(this.fNode, helper.getChildDOMName());
            if (child != null) {
                readAheadName = DOMUtilities.getChildText(child);
            }
        }
        if (readAheadName == null) {
            readAheadName = names[0];
        }
        return readAheadName;
    }

    public void setTarget(Notifier newTarget) {
        super.setTarget(newTarget);
        this.fEObject = (EObject)newTarget;
    }

    protected void addDOMAdapter() {
        this.primAddDOMAdapter(this.fNode, this);
        NodeList childNodes = this.fNode.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            Translator map;
            Node childNode = childNodes.item(j);
            short nodeType = childNode.getNodeType();
            if (!DOMUtilities.isTextNode(childNode) && nodeType != 8 && (map = this.findTranslator(childNode.getNodeName(), false)) != null && map.isManagedByParent()) {
                this.addDOMAdapter(childNode);
            }
            ++j;
        }
    }

    protected Text createTextNode(Document doc, Translator map, String text) {
        return map.isCDATAContent() ? doc.createCDATASection(text) : doc.createTextNode(text);
    }

    protected Translator findTranslator(String tagName, boolean attributeMap) {
        Translator[] maps = this.getChildTranslators();
        int i = 0;
        while (i < maps.length) {
            Translator map = maps[i];
            if (map.isMapFor(tagName) && attributeMap == map.isDOMAttribute()) {
                return maps[i];
            }
            ++i;
        }
        return null;
    }

    protected Text findOrCreateTextNode(Node parent, Translator map, String text) {
        Text textNode = DOMUtilities.getChildTextNode(parent);
        if (textNode != null) {
            textNode.setData(text);
        } else if (!this.isEmptyTag((Element)parent)) {
            Text newNode = this.createTextNode(parent.getOwnerDocument(), map, text);
            DOMUtilities.insertBeforeNode(parent, newNode, null);
            return newNode;
        }
        return textNode;
    }

    protected boolean isEmptyTag(Element parent) {
        Revisit.toDo();
        return false;
    }

    protected EMF2DOMAdapter getExistingAdapter(Node aNode) {
        EMF2DOMAdapter adapter = this.primGetExistingAdapter(aNode);
        if (adapter != null && adapter.isMOFProxy()) {
            this.removeDOMAdapter(aNode, adapter);
            adapter.getTarget().eAdapters().remove(adapter);
            adapter = null;
        }
        return adapter;
    }

    public boolean isMOFProxy() {
        if (this.fEObject == null) {
            return false;
        }
        return ((InternalEObject)this.fEObject).eIsProxy();
    }

    protected void primUpdateDOM() {
        Translator[] maps = this.getChildTranslators();
        int i = 0;
        while (i < maps.length) {
            this.updateDOMFeature(maps[i], this.getNode(), this.getEObject());
            ++i;
        }
    }

    protected void primUpdateDOMFeature(Translator map, Node node, EObject mofObject) {
        Object attrValue = null;
        boolean isSet = false;
        attrValue = map.getMOFValue(mofObject);
        isSet = map.isIDMap() ? attrValue != null : map.isSetMOFValue(mofObject);
        if (map.isDOMAttribute()) {
            Element e = (Element)this.createDOMPath(node, map);
            if (attrValue != null && isSet) {
                e.setAttribute(map.getDOMName(mofObject), map.convertValueToString(attrValue, mofObject));
            } else {
                e.removeAttribute(map.getDOMName(mofObject));
            }
        } else {
            this.updateDOMSubtree(map, node, mofObject, attrValue);
        }
    }

    protected void primUpdateDOMLinkFeature(Translator map, Node node, EObject mofObject) {
        LinkUpdaterTarget.INSTANCE.updateDOM(map, node, mofObject);
    }

    protected void primUpdateDOMMultiFeature(Translator map, Node node, EObject mofObject) {
        List mofChildren = map.getMOFChildren(mofObject);
        List domChildren = this.getDOMChildren(node, map);
        this.primUpdateDOMMultiFeature(map, node, mofChildren, domChildren, (Notifier)mofObject);
    }

    protected void primUpdateMOFLinkFeature(Translator map, Node node, EObject mofObject) {
        LinkUpdaterTarget.INSTANCE.updateMOF(map, node, mofObject);
    }

    protected void primUpdateMOFMultiFeature(Translator map, Node node, EObject mofObject) {
        if (map.isManagedByParent()) {
            this.updateMOFMultiPrimitiveFeature(map, node, mofObject);
            return;
        }
        List nodeChildren = this.getDOMChildren(node, map);
        List mofChildren = map.getMOFChildren(mofObject);
        this.primUpdateMOFMultiFeature(map, node, mofChildren, nodeChildren);
    }

    protected void removeDOMChildren(Node parent, Translator map) {
        String[] domNames = map.getDOMNames();
        HashSet<String> domNamesSet = new HashSet<String>(domNames.length);
        int i = 0;
        while (i < domNames.length) {
            domNamesSet.add(domNames[i]);
            ++i;
        }
        NodeList nl = parent.getChildNodes();
        ArrayList<Node> toRemove = new ArrayList<Node>();
        int i2 = 0;
        while (i2 < nl.getLength()) {
            Node childNode = nl.item(i2);
            if (domNamesSet.contains(childNode.getNodeName())) {
                toRemove.add(childNode);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < toRemove.size()) {
            Node childNode = (Node)toRemove.get(i3);
            this.removeDOMChild(parent, childNode, true);
            ++i3;
        }
    }

    protected final void updateDOMLinkFeature(Translator map, Node node, EObject mofObject) {
        boolean notificationFlag = this.isNotificationEnabled();
        this.primUpdateDOMLinkFeature(map, node, mofObject);
    }

    protected final void updateDOMMultiFeature(Translator map, Node node, EObject mofObject) {
        boolean notificationFlag = this.isNotificationEnabled();
        try {
            this.setNotificationEnabled(false);
            this.primUpdateDOMMultiFeature(map, node, mofObject);
            Object var6_5 = null;
            this.setNotificationEnabled(notificationFlag);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setNotificationEnabled(notificationFlag);
            throw throwable;
        }
    }

    protected void updateDOMSubtree(Translator map, Node node, EObject mofObject, Object attrValue) {
        if (map.featureExists(mofObject)) {
            EStructuralFeature feature = map.getFeature();
            if ((ECORE_PACKAGE.getEEnum().isInstance((Object)feature.getEType()) || ECORE_PACKAGE.getEBoolean() == feature.getEType()) && ((EAttribute)feature).isUnsettable() && !map.isSetMOFValue(mofObject)) {
                attrValue = null;
            }
        } else {
            attrValue = map.extractStringValue(mofObject);
        }
        Document doc = node.getOwnerDocument();
        if (attrValue != null) {
            Node parent = this.createDOMPath(node, map);
            if (map.isManagedByParent()) {
                Element child = map.isDOMTextValue() ? (Element)parent : this.findOrCreateNode((Element)parent, map, map.getDOMName(attrValue));
                this.findOrCreateTextNode(child, map, map.convertValueToString(attrValue, mofObject));
            } else {
                EObject mofValue = (EObject)attrValue;
                EMF2DOMAdapter valueAdapter = (EMF2DOMAdapter)EcoreUtil.getExistingAdapter((Notifier)mofValue, (Object)AbstractEMF2DOMAdapterImpl.ADAPTER_CLASS);
                if (valueAdapter != null) {
                    valueAdapter.updateDOM();
                } else {
                    this.removeDOMChildren(parent, map);
                    EMF2DOMAdapter adapter = this.createAdapter(mofValue, map);
                    List mofChildren = map.getMOFChildren(mofObject);
                    List domChildren = this.getDOMChildren(parent, map);
                    Node insertBeforeNode = this.findInsertBeforeNode(parent, map, mofChildren, 0, domChildren);
                    DOMUtilities.insertBeforeNodeAndWhitespace(parent, adapter.getNode(), insertBeforeNode);
                    boolean notificationFlag = adapter.isNotificationEnabled();
                    adapter.setNotificationEnabled(false);
                    try {
                        this.indent(adapter.getNode(), map);
                        Object var15_16 = null;
                        adapter.setNotificationEnabled(notificationFlag);
                    }
                    catch (Throwable throwable) {
                        Object var15_17 = null;
                        adapter.setNotificationEnabled(notificationFlag);
                        throw throwable;
                    }
                    adapter.updateDOM();
                }
            }
        } else {
            Node child = this.findDOMNode(node, map);
            if (child != null) {
                this.removeDOMChild((Element)child.getParentNode(), (Element)child);
            }
        }
    }

    public void primUpdateMOF() {
        Translator[] maps = this.getChildTranslators();
        int i = 0;
        while (i < maps.length) {
            this.updateMOFFeature(maps[i], this.getNode(), this.getEObject());
            ++i;
        }
    }

    public void updateMOFFeature(Translator map, Node node, EObject mofObject) {
        if (!this.isNotificationEnabled()) {
            return;
        }
        if (map.isMultiValued()) {
            this.updateMOFMultiFeature(map, node, mofObject);
            return;
        }
        boolean notificationFlag = this.isNotificationEnabled();
        boolean hasChanged = false;
        try {
            this.setNotificationEnabled(false);
            hasChanged = this.primUpdateMOFFeature(map, node, mofObject);
            Object var7_6 = null;
            this.setNotificationEnabled(notificationFlag);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setNotificationEnabled(notificationFlag);
            throw throwable;
        }
        if (map.isTargetLinkMap() && hasChanged) {
            this.updateMOFLinkFeature(map, node, mofObject);
        }
    }

    protected final void updateMOFMultiFeature(Translator map, Node node, EObject mofObject) {
        boolean notificationFlag = this.isNotificationEnabled();
        try {
            this.setNotificationEnabled(false);
            this.primUpdateMOFMultiFeature(map, node, mofObject);
            Object var6_5 = null;
            this.setNotificationEnabled(notificationFlag);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setNotificationEnabled(notificationFlag);
            throw throwable;
        }
    }

    protected final void updateMOFLinkFeature(Translator map, Node node, EObject mofObject) {
        boolean notificationFlag = this.isNotificationEnabled();
        try {
            this.setNotificationEnabled(false);
            this.primUpdateMOFLinkFeature(map, node, mofObject);
            Object var6_5 = null;
            this.setNotificationEnabled(notificationFlag);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setNotificationEnabled(notificationFlag);
            throw throwable;
        }
    }

    protected void updateMOFMultiPrimitiveFeature(Translator map, Node node, EObject mofObject) {
        List nodeChildren = this.getDOMChildren(node, map);
        List mofChildren = map.getMOFChildren(mofObject);
        map.clearList(mofObject);
        int i = 0;
        while (i < nodeChildren.size()) {
            Node child = (Node)nodeChildren.get(i);
            Object attributeValue = this.extractValue(child, map, mofObject);
            if (attributeValue != null) {
                map.setMOFValue((Notifier)mofObject, attributeValue, i);
            }
            this.addDOMAdapter(child);
            ++i;
        }
        if (map.hasDOMPath() && nodeChildren.isEmpty() && this.findDOMPath(node, map, false) != null) {
            map.setMOFValueFromEmptyDOMPath(mofObject);
        }
    }

    protected boolean primUpdateMOFFeature(Translator map, Node node, EObject mofObject) {
        if (!map.featureExists(mofObject)) {
            return false;
        }
        Object domValue = null;
        EStructuralFeature feature = map.getFeature();
        boolean updateMOFAttAdapter = false;
        boolean isUnset = false;
        EMF2DOMAdapter attrAdapter = null;
        Node child = this.findDOMNode(node, map, true);
        if (map.isDOMAttribute() && child != null) {
            Attr domAttr = (Attr)child.getAttributes().getNamedItem(map.getDOMName(mofObject));
            if (domAttr != null) {
                domValue = domAttr.getValue();
                domValue = map.convertStringToValue((String)domValue, mofObject);
            } else {
                isUnset = true;
            }
        } else if (child != null) {
            if (!map.isManagedByParent()) {
                attrAdapter = this.createAdapter((Element)child, map);
                updateMOFAttAdapter = true;
                domValue = attrAdapter.getTarget();
            } else {
                this.addDOMAdapter(child);
                domValue = this.extractValue(child, map, mofObject);
            }
        } else {
            isUnset = true;
        }
        boolean hasChanged = true;
        try {
            if (map.isIDMap()) {
                map.setMOFValue(mofObject, (String)domValue);
            } else {
                Object oldValue = null;
                oldValue = map.getMOFValue(mofObject);
                boolean isSet = map.isSetMOFValue(mofObject);
                if (oldValue == domValue) {
                    if (oldValue == null || isSet) {
                        hasChanged = false;
                    }
                } else if (domValue == null && !isSet) {
                    hasChanged = false;
                } else if (oldValue != null && oldValue.equals(domValue) && isSet) {
                    hasChanged = false;
                }
                if (oldValue == null && domValue == null && map.isSetMOFValue(mofObject) == isUnset) {
                    hasChanged = true;
                }
                if (hasChanged) {
                    if (!(feature.getEType() instanceof EDataType)) {
                        this.removeMOFValue((EObject)oldValue, map);
                    }
                    if (domValue == null) {
                        map.unSetMOFValue(mofObject);
                    } else {
                        map.setMOFValue(mofObject, domValue);
                    }
                    if (domValue == null && !ECORE_PACKAGE.getEEnum().isInstance((Object)feature.getEType()) || isUnset) {
                        map.unSetMOFValue(mofObject);
                    }
                    if (updateMOFAttAdapter) {
                        attrAdapter.updateMOF();
                    }
                }
            }
        }
        catch (FeatureValueConversionException ex) {
            map.unSetMOFValue(mofObject);
        }
        return hasChanged;
    }

    protected Node findDOMNode(Node parent, Translator map) {
        return this.findDOMNode(parent, map, false);
    }

    protected Node findDOMNode(Node parent, Translator map, boolean addAdapters) {
        Node curNode = this.findDOMPath(parent, map, addAdapters);
        if (map.isDOMTextValue() || map.isDOMAttribute() || curNode == null) {
            return curNode;
        }
        String[] domNames = map.getDOMNames();
        Node node = null;
        int i = 0;
        while (i < domNames.length) {
            String nodeName = domNames[i];
            node = DOMUtilities.getNodeChild(curNode, nodeName);
            if (node != null) {
                if (!addAdapters || map == null && !map.isManagedByParent()) break;
                this.addDOMAdapter(curNode);
                break;
            }
            ++i;
        }
        return node;
    }

    protected Object extractValue(Node node, Translator map, EObject emfObject) {
        if (map.isEmptyTag() && !map.isDOMAttribute() && !map.isDOMTextValue() && map.isBooleanFeature()) {
            return Boolean.TRUE;
        }
        Text textNode = DOMUtilities.getChildTextNode(node);
        String trimmedValue = null;
        if (textNode != null) {
            trimmedValue = textNode.getNodeValue();
        }
        try {
            return map.convertStringToValue(trimmedValue, emfObject);
        }
        catch (FeatureValueConversionException ex) {
            return null;
        }
    }

    protected boolean isTargetEObject() {
        return true;
    }

    public final void updateDOMFeature(Translator map, Node node, EObject mofObject) {
        if (!this.isNotificationEnabled()) {
            return;
        }
        try {
            this.preUpdateDOMFeature(map, node, mofObject);
            if (map.isMultiValued()) {
                this.updateDOMMultiFeature(map, node, mofObject);
                Object var8_4 = null;
                this.postUpdateDOMFeature(map, node, mofObject);
                return;
            }
            boolean notificationFlag = this.isNotificationEnabled();
            try {
                this.setNotificationEnabled(false);
                this.primUpdateDOMFeature(map, node, mofObject);
                Object var6_8 = null;
                this.setNotificationEnabled(notificationFlag);
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.setNotificationEnabled(notificationFlag);
                throw throwable;
            }
            if (map.isTargetLinkMap()) {
                this.updateDOMLinkFeature(map, node, mofObject);
            }
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.postUpdateDOMFeature(map, node, mofObject);
            throw throwable;
        }
        Object var8_5 = null;
        this.postUpdateDOMFeature(map, node, mofObject);
    }

    protected void postUpdateDOMFeature(Translator map, Node node, EObject mofObject) {
    }

    protected void preUpdateDOMFeature(Translator map, Node node, EObject mofObject) {
    }

    public void notifyChanged(Notification msg) {
        if (this.isDependencyFeature(msg)) {
            this.handleDependencyFeature(msg);
        }
        if (!this.isNotificationEnabled()) {
            return;
        }
        this.debugMOFNotify(msg);
        switch (msg.getEventType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Translator translator = this.findTranslator(msg);
                if (translator == null) {
                    return;
                }
                this.updateDOMFeature(translator, this.getNode(), this.fEObject);
            }
        }
    }

    protected boolean isDependencyFeature(Notification msg) {
        switch (msg.getEventType()) {
            case 1: {
                return this.fTranslator.isDependencyParent() && this.fTranslator.getDependencyFeature() == msg.getFeature();
            }
        }
        return false;
    }

    protected void handleDependencyFeature(Notification msg) {
        if (msg.getOldValue() != null) {
            this.removeDependencyAdapter((EObject)msg.getOldValue());
        }
        if (msg.getNewValue() != null) {
            this.addDependencyAdapter((EObject)msg.getNewValue());
        }
    }

    protected void removeDependencyAdapter(EObject obj) {
        Adapter existing = EcoreUtil.getExistingAdapter((Notifier)obj, (Object)"EMF2DOMDependencyAdapter");
        if (existing != null) {
            obj.eAdapters().remove(existing);
        }
    }

    protected void addDependencyAdapter(EObject child) {
        Adapter existing = EcoreUtil.getExistingAdapter((Notifier)child, (Object)"EMF2DOMDependencyAdapter");
        if (existing != null) {
            return;
        }
        DependencyAdapter forwarder = new DependencyAdapter();
        child.eAdapters().add(forwarder);
        forwarder.setTarget((Notifier)child);
    }

    private class DependencyAdapter
    extends AdapterImpl {
        static final String KEY = "EMF2DOMDependencyAdapter";

        private DependencyAdapter() {
        }

        public void notifyChanged(Notification msg) {
            EMF2DOMAdapterImpl.this.notifyChanged(msg);
        }

        public boolean isAdapterForType(Object type) {
            return KEY.equals(type);
        }
    }
}

