/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf2xml.impl;

import com.ibm.etools.emf2xml.EMF2DOMAdapter;
import com.ibm.etools.emf2xml.Renderer;
import com.ibm.etools.emf2xml.TranslatorResource;
import com.ibm.etools.emf2xml.impl.AbstractRendererImpl;
import com.ibm.etools.emf2xml.impl.RootEMF2DOMAdapterImpl;
import com.ibm.etools.emf2xml.util.DOMLoadOptions;
import com.ibm.etools.emf2xml.util.DOMUtilities;
import com.ibm.etools.wft.util.Revisit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.emf.common.util.WrappedException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EMF2DOMRenderer
extends AbstractRendererImpl
implements Renderer {
    protected Map domAdapterRegistry;
    protected boolean needsToCreateDOM = true;
    protected Document document;

    public EMF2DOMRenderer() {
        if (this.managesDOMAdapters()) {
            this.initDOMAdapterRegistry();
        }
    }

    public void doLoad(InputStream in, Map options) {
        this.needsToCreateDOM = false;
        if (in != null) {
            this.loadDocument(in, options);
            EMF2DOMAdapter adapter = this.createRootDOMAdapter();
            adapter.updateMOF();
        }
    }

    protected void loadDocument(InputStream in, Map options) {
        try {
            DOMLoadOptions domOpts = new DOMLoadOptions();
            domOpts.setAllowJavaEncodings(true);
            domOpts.setExpandEntityRefererences(true);
            domOpts.setValidate(true);
            this.document = DOMUtilities.loadDocument(in, domOpts, this.getResource().getEntityResolver());
        }
        catch (ParserConfigurationException ex) {
            throw new WrappedException((Exception)ex);
        }
        catch (IOException iox) {
            throw new WrappedException((Exception)iox);
        }
        catch (SAXException sax) {
            throw new WrappedException((Exception)sax);
        }
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        this.createDOMTreeIfNecessary();
        this.serializeDocument(outputStream);
    }

    protected boolean managesDOMAdapters() {
        return true;
    }

    protected void initDOMAdapterRegistry() {
        if (this.domAdapterRegistry == null) {
            this.domAdapterRegistry = new HashMap();
        }
    }

    public void registerDOMAdapter(Node node, EMF2DOMAdapter adapter) {
        this.domAdapterRegistry.put(node, adapter);
    }

    public EMF2DOMAdapter getExistingDOMAdapter(Node node) {
        return (EMF2DOMAdapter)this.domAdapterRegistry.get(node);
    }

    public void removeDOMAdapter(Node aNode, EMF2DOMAdapter anAdapter) {
        this.domAdapterRegistry.remove(aNode);
    }

    public void prepareToAddContents() {
    }

    protected Node createDOMTree() {
        this.createDocument();
        EMF2DOMAdapter adapter = this.createRootDOMAdapter();
        adapter.updateDOM();
        this.needsToCreateDOM = false;
        return this.document;
    }

    protected EMF2DOMAdapter createRootDOMAdapter() {
        RootEMF2DOMAdapterImpl root = new RootEMF2DOMAdapterImpl(this.getResource(), this.document, this, this.getResource().getRootTranslator());
        this.registerDOMAdapter(this.document, root);
        return root;
    }

    protected void createDOMTreeIfNecessary() {
        if (this.needsToCreateDOM) {
            this.createDOMTree();
        }
    }

    protected void createDocument() {
        TranslatorResource res = this.getResource();
        res.setDefaults();
        Object builder = null;
        try {
            this.document = DOMUtilities.createNewDocument(res.getDoctype(), res.getPublicId(), res.getSystemId());
        }
        catch (ParserConfigurationException e) {
            throw new WrappedException((Exception)e);
        }
        catch (SAXException e) {
            throw new WrappedException((Exception)e);
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }

    public void serializeDocument(OutputStream out) throws IOException {
        OutputFormat format = this.createOutputFormat();
        Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer(out, format);
        serializer.asDOMSerializer().serialize(this.document);
    }

    protected OutputFormat createOutputFormat() {
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        format.setLineSeparator(DOMUtilities.NEWLINE_STRING);
        format.setEncoding(this.getResource().getEncoding());
        format.setVersion(this.getResource().getXMLVersion());
        return format;
    }

    public void replaceDocumentType(String docTypeName, String publicId, String systemId) {
        Revisit.revisit();
        Document newDoc = null;
        try {
            newDoc = DOMUtilities.createNewDocument(docTypeName, publicId, systemId);
        }
        catch (ParserConfigurationException e) {
            throw new WrappedException((Exception)e);
        }
        catch (SAXException e) {
            throw new WrappedException((Exception)e);
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
        this.replaceNode(this.document.getDocumentElement(), newDoc, newDoc);
        this.readapt(this.document, newDoc);
        this.document = newDoc;
    }

    protected void replaceNode(Node oldChild, Node newParent, Document newDoc) {
        Node newChild = newDoc.importNode(oldChild, false);
        newParent.appendChild(newChild);
        this.readapt(oldChild, newChild);
        NodeList children = oldChild.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            this.replaceNode(children.item(i), newChild, newDoc);
            ++i;
        }
    }

    protected void readapt(Node oldChild, Node newChild) {
        EMF2DOMAdapter adapter = this.getExistingDOMAdapter(oldChild);
        if (adapter != null) {
            this.registerDOMAdapter(newChild, adapter);
            if (adapter.getNode() == oldChild) {
                adapter.setNode(newChild);
            }
        }
    }

    public int getVersionID() {
        return this.getResource().getVersionID();
    }
}

