/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.encoders;

import com.ibm.etools.encoders.EncoderDecoder;
import com.ibm.etools.encoders.PassthruEncoderDecoder;
import com.ibm.etools.encoders.XMLValueEncoderDecoder;
import java.util.HashMap;
import java.util.Map;

public class EncoderDecoderRegistry {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected static EncoderDecoderRegistry _defaultInstance;
    public static final EncoderDecoder INITIAL_DEFAULT_ENCODER;
    protected Map encoders = new HashMap();
    protected Object defaultEncoderKey;

    public EncoderDecoderRegistry() {
        this.initializeDefaultEncoders();
    }

    public void addEncoderDecoder(EncoderDecoder encoderDecoder) {
        this.encoders.put(encoderDecoder.getClass().getName(), encoderDecoder);
        if (this.defaultEncoderKey == null) {
            this.defaultEncoderKey = encoderDecoder.getClass().getName();
        }
    }

    public EncoderDecoder getDefaultEncoderDecoder() {
        if (this.defaultEncoderKey == null) {
            return null;
        }
        return (EncoderDecoder)this.encoders.get(this.defaultEncoderKey);
    }

    public static EncoderDecoderRegistry getDefaultRegistry() {
        if (_defaultInstance == null) {
            _defaultInstance = new EncoderDecoderRegistry();
        }
        return _defaultInstance;
    }

    public EncoderDecoder getEncoderDecoder(Object key) {
        return (EncoderDecoder)this.encoders.get(key);
    }

    public void initializeDefaultEncoders() {
        this.setDefaultEncoderDecoder(INITIAL_DEFAULT_ENCODER);
        this.addEncoderDecoder(new XMLValueEncoderDecoder());
    }

    public void removeEncoderDecoder(Object key) {
        if (this.encoders.containsKey(key)) {
            this.encoders.remove(key);
        }
    }

    public void setDefaultEncoderDecoder(EncoderDecoder encoder) {
        this.defaultEncoderKey = encoder.getClass().getName();
        if (!this.encoders.containsKey(this.defaultEncoderKey)) {
            this.addEncoderDecoder(encoder);
        }
    }

    static {
        INITIAL_DEFAULT_ENCODER = PassthruEncoderDecoder.INSTANCE;
    }
}

