/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wft.util;

import com.ibm.etools.wft.nls.ResourceHandler;
import com.ibm.etools.wft.util.ExceptionHelper;
import com.ibm.etools.wft.util.IWFTWrappedException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class WFTWrappedRuntimeException
extends RuntimeException
implements IWFTWrappedException {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Exception nestedException;

    public WFTWrappedRuntimeException() {
    }

    public WFTWrappedRuntimeException(Exception e) {
        this.setNestedException(e);
    }

    public WFTWrappedRuntimeException(String s) {
        super(s);
    }

    public WFTWrappedRuntimeException(String s, Exception e) {
        super(s);
        this.setNestedException(e);
    }

    public String[] getAllMessages() {
        return ExceptionHelper.getAllMessages(this);
    }

    public String getConcatenatedMessages() {
        return ExceptionHelper.getConcatenatedMessages(this);
    }

    public Exception getInnerMostNestedException() {
        Exception n = this.getNestedException();
        if (n == null) {
            return this;
        }
        if (n instanceof IWFTWrappedException) {
            return ((IWFTWrappedException)((Object)n)).getInnerMostNestedException();
        }
        return n;
    }

    public Exception getNestedException() {
        return this.nestedException;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        if (this.nestedException != null) {
            s.println(this);
            s.println(ResourceHandler.getString("Stack_trace_of_nested_exce_ERROR_"));
            this.nestedException.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (this.nestedException != null) {
            s.println(this);
            s.println(ResourceHandler.getString("Stack_trace_of_nested_exce_ERROR_"));
            this.nestedException.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    public void setNestedException(Exception newNestedException) {
        this.nestedException = newNestedException;
    }
}

