/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMRegistryController;

class REMMasterServerThread
extends Thread {
    protected ServerSocket masterServerSocket;
    protected REMRegistryController registryController;
    protected boolean shuttingDown = false;
    static boolean LINUX_1_3 = "linux".equalsIgnoreCase(System.getProperty("os.name")) && System.getProperty("java.version", "").startsWith("1.3");

    public REMMasterServerThread(REMRegistryController registryController) {
        super("Remote Proxy Master Server Thread");
        this.registryController = registryController;
        try {
            this.masterServerSocket = new ServerSocket(0, 50, InetAddress.getByName("localhost"));
            if (LINUX_1_3) {
                this.masterServerSocket.setSoTimeout(1000);
            }
        }
        catch (SocketException e) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
        }
        catch (IOException e) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
        }
    }

    public ServerSocket getMasterSocket() {
        return this.masterServerSocket;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block12: {
            try {
                while (this.masterServerSocket != null) {
                    Object var2_3;
                    Socket incoming = null;
                    try {
                        incoming = this.masterServerSocket.accept();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        continue;
                    }
                    try {
                        this.processRequest(incoming);
                    }
                    catch (Throwable throwable) {
                        var2_3 = null;
                        try {
                            incoming.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        var2_3 = null;
                    }
                    try {}
                    catch (IOException iOException) {}
                    incoming.close();
                    incoming = null;
                }
            }
            catch (Exception e) {
                if (this.shuttingDown) break block12;
                ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
            }
        }
        this.shutdown();
    }

    public void requestShutdown() {
        if (this.masterServerSocket == null) {
            return;
        }
        try {
            this.shuttingDown = true;
            this.masterServerSocket.close();
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processRequest(Socket remote) throws IOException {
        DataInputStream in = new DataInputStream(remote.getInputStream());
        DataOutputStream out = new DataOutputStream(remote.getOutputStream());
        try {
            try {
                byte cmd = in.readByte();
                switch (cmd) {
                    case 16: {
                        int registryID = in.readInt();
                        out.writeBoolean(this.registryController.getRegistry(new Integer(registryID)) != null);
                        out.flush();
                        break;
                    }
                    case 17: {
                        int registryID = in.readInt();
                        int remoteServerPort = in.readInt();
                        REMProxyFactoryRegistry registry = this.registryController.getRegistry(new Integer(registryID));
                        if (registry != null) {
                            registry.setServerPort(remoteServerPort);
                            out.writeBoolean(true);
                        } else {
                            out.writeBoolean(false);
                        }
                        out.flush();
                        break;
                    }
                    case 18: {
                        int registryID = in.readInt();
                        REMProxyFactoryRegistry registry = this.registryController.getRegistry(new Integer(registryID));
                        if (registry != null) {
                            out.writeInt(registry.getCallbackServerPort());
                        } else {
                            out.writeInt(-1);
                        }
                        out.flush();
                        break;
                    }
                }
            }
            catch (Exception e) {
                ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var8_14 = null;
        }
        try {}
        catch (IOException iOException) {}
        in.close();
        try {}
        catch (IOException iOException) {
            return;
        }
        out.close();
    }

    private void shutdown() {
        this.requestShutdown();
        this.masterServerSocket = null;
    }
}

