/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.CommandErrorException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.common.remote.TransmitableArray;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMConnection;
import org.eclipse.jem.internal.proxy.remote.IREMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMAbstractBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyConstants;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;

final class REMMethodProxy
extends REMAbstractBeanProxy
implements IREMMethodProxy {
    private IBeanTypeProxy fDeclaringType;
    private String fMethodName;
    private IBeanTypeProxy[] fParameterTypes;
    private IBeanTypeProxy fReturnType;

    REMMethodProxy(REMProxyFactoryRegistry aRegistry, Integer anID) {
        super(aRegistry, anID);
    }

    public IBeanTypeProxy getClassType() {
        if (this.fDeclaringType == null) {
            this.fDeclaringType = (IBeanTypeProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getMethodDeclaringClassMessage().invokeCatchThrowableExceptions((IBeanProxy)this);
        }
        return this.fDeclaringType;
    }

    public String getName() {
        if (this.fMethodName == null) {
            IStringBeanProxy proxy = (IStringBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getMethodMethodNameMessage().invokeCatchThrowableExceptions((IBeanProxy)this);
            this.fMethodName = proxy != null ? proxy.stringValue() : "";
        }
        return this.fMethodName;
    }

    public IBeanTypeProxy[] getParameterTypes() {
        if (this.fParameterTypes == null) {
            IArrayBeanProxy parmTypes = (IArrayBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getMethodParameterTypesMessage().invokeCatchThrowableExceptions((IBeanProxy)this);
            if (parmTypes == null) {
                this.fParameterTypes = new IBeanTypeProxy[0];
            } else {
                int len = parmTypes.getLength();
                this.fParameterTypes = new IBeanTypeProxy[len];
                int i = 0;
                while (i < len) {
                    try {
                        this.fParameterTypes[i] = (IBeanTypeProxy)parmTypes.get(i);
                    }
                    catch (ThrowableProxy throwableProxy) {}
                    ++i;
                }
                this.fFactory.releaseProxy((IBeanProxy)parmTypes);
            }
        }
        return this.fParameterTypes;
    }

    public IBeanTypeProxy getReturnType() {
        if (this.fReturnType == null) {
            this.fReturnType = (IBeanTypeProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getMethodReturnTypeMessage().invokeCatchThrowableExceptions((IBeanProxy)this);
        }
        return this.fReturnType;
    }

    public IBeanProxy invoke(IBeanProxy subject) throws ThrowableProxy {
        return this.invoke(subject, (IBeanProxy[])null);
    }

    public IBeanProxy invoke(IBeanProxy subject, IBeanProxy[] parms) throws ThrowableProxy {
        return this.invokeWithParms(subject, parms);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBeanProxy invokeWithParms(IBeanProxy subject, Object[] parms) throws ThrowableProxy {
        IREMConnection connect = this.fFactory.getFreeConnection();
        if (connect == null) return null;
        REMStandardBeanProxyFactory proxyFactory = (REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory();
        proxyFactory.startTransaction();
        try {
            Commands.ValueObject subjectValue = new Commands.ValueObject();
            if (subject != null) {
                ((IREMBeanProxy)subject).renderBean(subjectValue);
            }
            Commands.ValueObject parmsValue = new Commands.ValueObject();
            if (parms != null) {
                IStandardBeanTypeProxyFactory typeFactory = this.fFactory.getBeanTypeProxyFactory();
                class Retriever
                implements Commands.ValueRetrieve {
                    int index;
                    Object[] array;
                    Commands.ValueObject worker;
                    final /* synthetic */ REMMethodProxy this$0;
                    private final /* synthetic */ IStandardBeanTypeProxyFactory val$typeFactory;

                    public Retriever(REMMethodProxy rEMMethodProxy, Object[] anArray, IStandardBeanTypeProxyFactory iStandardBeanTypeProxyFactory) {
                        this.this$0 = rEMMethodProxy;
                        this.val$typeFactory = iStandardBeanTypeProxyFactory;
                        this.index = 0;
                        this.worker = new Commands.ValueObject();
                        this.array = anArray;
                    }

                    public Commands.ValueObject nextValue() {
                        if (this.index < this.array.length) {
                            Object parm;
                            if ((parm = this.array[this.index++]) != null) {
                                if (parm instanceof IREMBeanProxy) {
                                    ((IREMBeanProxy)parm).renderBean(this.worker);
                                } else if (parm instanceof TransmitableArray) {
                                    this.worker.setArrayIDS((Commands.ValueRetrieve)new Retriever(this.this$0, ((TransmitableArray)parm).array, this.val$typeFactory), ((TransmitableArray)parm).array.length, ((TransmitableArray)parm).componentTypeID);
                                } else {
                                    IREMBeanProxy type = (IREMBeanProxy)this.val$typeFactory.getBeanTypeProxy(parm.getClass().getName());
                                    if (type == null) {
                                        throw new IllegalArgumentException();
                                    }
                                    int classID = type.getID();
                                    this.worker.setAsObject(parm, classID);
                                }
                            } else {
                                this.worker.set();
                            }
                            return this.worker;
                        }
                        return null;
                    }
                }
                parmsValue.setArrayIDS((Commands.ValueRetrieve)new Retriever(this, parms, typeFactory), parms.length, 23);
            }
            Commands.ValueObject returnValue = new Commands.ValueObject();
            try {
                this.invoke(connect, proxyFactory, subjectValue, parmsValue, returnValue);
                IBeanProxy iBeanProxy = proxyFactory.getBeanProxy(returnValue);
                Object var10_12 = null;
                proxyFactory.stopTransaction();
                if (connect == null) return iBeanProxy;
                this.fFactory.returnConnection(connect);
                return iBeanProxy;
            }
            catch (CommandException e) {
                if (e.isRecoverable()) {
                    ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
                    IBeanProxy iBeanProxy = null;
                    Object var10_15 = null;
                    proxyFactory.stopTransaction();
                    if (connect == null) return iBeanProxy;
                    this.fFactory.returnConnection(connect);
                    return iBeanProxy;
                }
                this.fFactory.closeConnection(connect);
                connect = null;
                connect = this.fFactory.getFreeConnection();
                if (connect != null) {
                    try {
                        this.invoke(connect, proxyFactory, subjectValue, parmsValue, returnValue);
                        IBeanProxy iBeanProxy = proxyFactory.getBeanProxy(returnValue);
                        Object var10_13 = null;
                        proxyFactory.stopTransaction();
                        if (connect == null) return iBeanProxy;
                        this.fFactory.returnConnection(connect);
                        return iBeanProxy;
                    }
                    catch (CommandException eAgain) {
                        this.fFactory.closeConnection(connect);
                        connect = null;
                        ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)eAgain));
                        IBeanProxy iBeanProxy = null;
                        Object var10_14 = null;
                        proxyFactory.stopTransaction();
                        if (connect == null) return iBeanProxy;
                        this.fFactory.returnConnection(connect);
                        return iBeanProxy;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            proxyFactory.stopTransaction();
            if (connect == null) throw throwable;
            this.fFactory.returnConnection(connect);
            throw throwable;
        }
        {
            Object var10_17 = null;
            proxyFactory.stopTransaction();
            if (connect == null) return null;
            this.fFactory.returnConnection(connect);
            return null;
        }
    }

    private void invoke(IREMConnection connect, REMStandardBeanProxyFactory proxyFactory, Commands.ValueObject subjectValue, Commands.ValueObject parmsValue, Commands.ValueObject returnValue) throws ThrowableProxy, CommandException {
        try {
            connect.invokeMethod(this.getID(), subjectValue, parmsValue, returnValue);
        }
        catch (CommandErrorException e) {
            proxyFactory.processErrorReturn(e);
        }
    }

    public IBeanProxy invoke(IBeanProxy subject, IBeanProxy parm) throws ThrowableProxy {
        return this.invoke(subject, new IBeanProxy[]{parm});
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject) {
        try {
            return this.invoke(subject);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
            this.fFactory.releaseProxy((IBeanProxy)e);
            return null;
        }
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject, IBeanProxy[] parms) {
        try {
            return this.invoke(subject, parms);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
            this.fFactory.releaseProxy((IBeanProxy)e);
            return null;
        }
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject, IBeanProxy parm) {
        try {
            return this.invoke(subject, parm);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
            this.fFactory.releaseProxy((IBeanProxy)e);
            return null;
        }
    }

    public IBeanTypeProxy getTypeProxy() {
        return ((REMMethodProxyFactory)this.fFactory.getMethodProxyFactory()).methodType;
    }

    public void release() {
        this.fDeclaringType = null;
        this.fParameterTypes = null;
        this.fReturnType = null;
        super.release();
    }
}

