/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.common.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.CommandErrorException;
import org.eclipse.jem.internal.proxy.common.remote.UnexpectedCommandException;
import org.eclipse.jem.internal.proxy.common.remote.UnexpectedExceptionCommandException;

public class Commands {
    public static final HashMap MAP_SHORTSIG_TO_TYPE = new HashMap(8);
    public static final HashMap MAP_TYPENAME_TO_SHORTSIG = new HashMap(8);
    public static final byte GET_CLASS = 1;
    public static final byte VALUE = 2;
    public static final byte QUIT_CONNECTION = 4;
    public static final byte TERMINATE_SERVER = 5;
    public static final byte ERROR = 6;
    public static final byte RELEASE_OBJECT = 7;
    public static final byte GET_CLASS_RETURN = 8;
    public static final byte GET_METHOD = 9;
    public static final byte GET_CTOR = 10;
    public static final byte NEW_INIT_STRING = 11;
    public static final byte GET_CLASS_FROM_ID = 12;
    public static final byte GET_CLASS_ID_RETURN = 13;
    public static final byte GET_OBJECT_DATA = 14;
    public static final byte INVOKE = 15;
    public static final byte ALIVE = 16;
    public static final byte REMOTE_STARTED = 17;
    public static final byte GET_CALLBACK_PORT = 18;
    public static final byte CALLBACK = -1;
    public static final byte CALLBACK_DONE = -2;
    public static final byte CALLBACK_STREAM = -3;
    public static final byte CALLBACK_STREAM_TERMINATE = -4;
    public static final int UNKNOWN_COMMAND_SENT = 1;
    public static final int GET_CLASS_NOT_FOUND = 2;
    public static final int CANNOT_EVALUATE_STRING = 3;
    public static final int CLASS_CAST_EXCEPTION = 4;
    public static final int GET_METHOD_NOT_FOUND = 5;
    public static final int THROWABLE_SENT = 6;
    public static final int NOT_AN_ID = -1;
    public static final int VOID_TYPE = 0;
    public static final int BOOLEAN_TYPE = 1;
    public static final int BOOLEAN_CLASS = 2;
    public static final int INTEGER_TYPE = 3;
    public static final int INTEGER_CLASS = 4;
    public static final int BYTE_TYPE = 5;
    public static final int BYTE_CLASS = 6;
    public static final int CHARACTER_TYPE = 7;
    public static final int CHARACTER_CLASS = 8;
    public static final int DOUBLE_TYPE = 9;
    public static final int DOUBLE_CLASS = 10;
    public static final int FLOAT_TYPE = 11;
    public static final int FLOAT_CLASS = 12;
    public static final int SHORT_TYPE = 13;
    public static final int SHORT_CLASS = 14;
    public static final int LONG_TYPE = 15;
    public static final int LONG_CLASS = 16;
    public static final int STRING_CLASS = 17;
    public static final int BIG_DECIMAL_CLASS = 18;
    public static final int BIG_INTEGER_CLASS = 19;
    public static final int NUMBER_CLASS = 20;
    public static final int THROWABLE_CLASS = 21;
    public static final int CLASS_CLASS = 22;
    public static final int OBJECT_CLASS = 23;
    public static final int ACCESSIBLEOBJECT_CLASS = 24;
    public static final int METHOD_CLASS = 25;
    public static final int FIELD_CLASS = 26;
    public static final int CONSTRUCTOR_CLASS = 27;
    public static final int GET_METHOD_ID = 28;
    public static final int IVMSERVER_CLASS = 29;
    public static final int ICALLBACK_CLASS = 30;
    public static final int REMOTESERVER_ID = 31;
    public static final int REMOTEVMSERVER_CLASS = 32;
    public static final int INITIALIZECALLBACK_METHOD_ID = 33;
    public static final int THREAD_CLASS = 33;
    public static final int FIRST_FREE_ID = 34;
    public static final byte VOID = 0;
    public static final byte BYTE = 5;
    public static final byte L_BYTE = 6;
    public static final byte CHAR = 7;
    public static final byte L_CHAR = 8;
    public static final byte DOUBLE = 9;
    public static final byte L_DOUBLE = 10;
    public static final byte FLOAT = 11;
    public static final byte L_FLOAT = 12;
    public static final byte INT = 3;
    public static final byte L_INT = 4;
    public static final byte LONG = 15;
    public static final byte L_LONG = 16;
    public static final byte SHORT = 13;
    public static final byte L_SHORT = 14;
    public static final byte BOOL = 1;
    public static final byte L_BOOL = 2;
    public static final byte STRING = 17;
    public static final byte OBJECT = 23;
    public static final byte OBJECT_ID = 50;
    public static final byte NEW_OBJECT_ID = 51;
    public static final byte THROW = 52;
    public static final byte ARRAY_IDS = 53;
    public static final Object UNKNOWN_READ_TYPE;
    public static final Object UNKNOWN_WRITE_TYPE;
    public static final Object TYPE_INVALID_FOR_COMMAND;
    public static final Object UNKNOWN_COMMAND;
    public static final Object SOME_UNEXPECTED_EXCEPTION;
    public static final Object TOO_MANY_BYTES;
    public static final byte NO_TYPE_CHECK = -1;

    static {
        MAP_SHORTSIG_TO_TYPE.put("B", Byte.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("C", Character.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("D", Double.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("F", Float.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("I", Integer.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("J", Long.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("S", Short.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("Z", Boolean.TYPE);
        MAP_TYPENAME_TO_SHORTSIG.put("byte", "B");
        MAP_TYPENAME_TO_SHORTSIG.put("char", "C");
        MAP_TYPENAME_TO_SHORTSIG.put("double", "D");
        MAP_TYPENAME_TO_SHORTSIG.put("float", "F");
        MAP_TYPENAME_TO_SHORTSIG.put("int", "I");
        MAP_TYPENAME_TO_SHORTSIG.put("long", "J");
        MAP_TYPENAME_TO_SHORTSIG.put("short", "S");
        MAP_TYPENAME_TO_SHORTSIG.put("boolean", "Z");
        UNKNOWN_READ_TYPE = "UNKNOWN_READ_TYPE";
        UNKNOWN_WRITE_TYPE = "UNKNOWN_WRITE_TYPE";
        TYPE_INVALID_FOR_COMMAND = "TYPE_INVALID_FOR_COMMAND";
        UNKNOWN_COMMAND = "UNKNOWN_COMMAND";
        SOME_UNEXPECTED_EXCEPTION = "SOME_UNEXPECTED_EXCEPTION";
        TOO_MANY_BYTES = "TOO_MANY_BYTES";
    }

    public static void readValue(DataInputStream is, ValueObject value) throws CommandException {
        try {
            value.anObject = null;
            value.type = is.readByte();
            switch (value.type) {
                case 5: 
                case 6: {
                    value.aByte = is.readByte();
                    break;
                }
                case 7: 
                case 8: {
                    value.aChar = is.readChar();
                    break;
                }
                case 9: 
                case 10: {
                    value.aDouble = is.readDouble();
                    break;
                }
                case 11: 
                case 12: {
                    value.aFloat = is.readFloat();
                    break;
                }
                case 3: 
                case 4: {
                    value.anInt = is.readInt();
                    break;
                }
                case 50: {
                    value.objectID = is.readInt();
                    break;
                }
                case 51: {
                    value.classID = is.readInt();
                    value.objectID = is.readInt();
                    break;
                }
                case 52: {
                    value.classID = is.readInt();
                    value.objectID = is.readInt();
                    break;
                }
                case 13: 
                case 14: {
                    value.aShort = is.readShort();
                    break;
                }
                case 15: 
                case 16: {
                    value.aLong = is.readLong();
                    break;
                }
                case 1: 
                case 2: {
                    value.aBool = is.readBoolean();
                    break;
                }
                case 17: {
                    value.anObject = is.readUTF();
                    break;
                }
                case 23: {
                    value.classID = is.readInt();
                    ObjectInputStream oi = new ObjectInputStream(is);
                    value.anObject = oi.readObject();
                    oi = null;
                    break;
                }
                case 53: {
                    value.classID = is.readInt();
                    value.anInt = is.readInt();
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new UnexpectedCommandException(UNKNOWN_READ_TYPE, false, new Byte(value.type));
                }
            }
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static void readArray(DataInputStream is, int arraySize, ValueSender valueSender, ValueObject value) throws CommandException {
        RuntimeException exception = null;
        int i = 0;
        while (i < arraySize) {
            block9: {
                Commands.readValue(is, value);
                if (exception == null) {
                    try {
                        if (value.type != 53) {
                            valueSender.sendValue(value);
                            break block9;
                        }
                        ValueSender nestedSender = null;
                        try {
                            nestedSender = valueSender.nestedArray(value);
                        }
                        catch (RuntimeException e) {
                            exception = e;
                            nestedSender = new ValueSender(){

                                public void sendValue(ValueObject value) {
                                }

                                public ValueSender nestedArray(ValueObject arrayValue) {
                                    return this;
                                }
                            };
                        }
                        Commands.readArray(is, value.anInt, nestedSender, value);
                        if (exception != null) {
                            throw exception;
                        }
                    }
                    catch (RuntimeException e) {
                        exception = e;
                    }
                }
            }
            ++i;
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void writeValue(DataOutputStream os, ValueObject value, boolean asValueCommand) throws CommandException {
        try {
            if (asValueCommand) {
                os.writeByte(2);
            }
            switch (value.type) {
                case 5: 
                case 6: {
                    os.writeByte(value.type);
                    os.writeByte(value.aByte);
                    break;
                }
                case 7: 
                case 8: {
                    os.writeByte(value.type);
                    os.writeChar(value.aChar);
                    break;
                }
                case 9: 
                case 10: {
                    os.writeByte(value.type);
                    os.writeDouble(value.aDouble);
                    break;
                }
                case 11: 
                case 12: {
                    os.writeByte(value.type);
                    os.writeFloat(value.aFloat);
                    break;
                }
                case 3: 
                case 4: {
                    os.writeByte(value.type);
                    os.writeInt(value.anInt);
                    break;
                }
                case 50: {
                    os.writeByte(value.type);
                    os.writeInt(value.objectID);
                    break;
                }
                case 51: {
                    os.writeByte(value.type);
                    os.writeInt(value.classID);
                    os.writeInt(value.objectID);
                    break;
                }
                case 52: {
                    os.writeByte(value.type);
                    os.writeInt(value.classID);
                    os.writeInt(value.objectID);
                    break;
                }
                case 13: 
                case 14: {
                    os.writeByte(value.type);
                    os.writeShort(value.aShort);
                    break;
                }
                case 15: 
                case 16: {
                    os.writeByte(value.type);
                    os.writeLong(value.aLong);
                    break;
                }
                case 1: 
                case 2: {
                    os.writeByte(value.type);
                    os.writeBoolean(value.aBool);
                    break;
                }
                case 17: {
                    os.writeByte(value.type);
                    os.writeUTF((String)value.anObject);
                    break;
                }
                case 23: {
                    os.writeByte(value.type);
                    os.writeInt(value.classID);
                    ObjectOutputStream oos = new ObjectOutputStream(os);
                    oos.writeObject(value.anObject);
                    oos.flush();
                    oos = null;
                    break;
                }
                case 53: {
                    os.writeByte(value.type);
                    os.writeInt(value.classID);
                    os.writeInt(value.anInt);
                    ValueRetrieve retriever = (ValueRetrieve)value.anObject;
                    ValueObject nextEntry = null;
                    while ((nextEntry = retriever.nextValue()) != null) {
                        Commands.writeValue(os, nextEntry, false);
                    }
                    break;
                }
                case 0: {
                    os.writeByte(value.type);
                    break;
                }
                default: {
                    os.writeByte(0);
                    throw new UnexpectedCommandException(UNKNOWN_WRITE_TYPE, true, value);
                }
            }
            if (asValueCommand) {
                os.flush();
            }
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static int readBytes(DataInputStream is, byte[] bytes) throws CommandException {
        try {
            int bytesToRead = -1;
            try {
                bytesToRead = is.readInt();
            }
            catch (EOFException eOFException) {}
            if (bytesToRead == -1) {
                return -1;
            }
            if (bytesToRead > bytes.length) {
                throw new UnexpectedCommandException(TOO_MANY_BYTES, false, new Integer(bytesToRead));
            }
            int start = 0;
            int toRead = bytesToRead;
            while (toRead > 0) {
                int bytesRead = is.read(bytes, start, toRead);
                if (bytesRead == -1) {
                    return bytesToRead != toRead ? bytesToRead - toRead : -1;
                }
                start += bytesRead;
                toRead -= bytesRead;
            }
            return bytesToRead;
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static void writeBytes(DataOutputStream os, byte[] bytes, int bytesToWrite) throws CommandException {
        try {
            os.writeInt(bytesToWrite);
            os.write(bytes, 0, bytesToWrite);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static void sendQuitCommand(DataOutputStream os) throws IOException {
        os.writeByte(4);
        os.flush();
    }

    public static void sendTerminateCommand(DataOutputStream os) throws IOException {
        os.writeByte(5);
        os.flush();
    }

    public static void releaseObjectCommand(DataOutputStream os, int id) throws IOException {
        os.writeByte(7);
        os.writeInt(id);
        os.flush();
    }

    public static void sendCallbackCommand(DataOutputStream os, int callbackID, int msgID) throws CommandException {
        try {
            os.writeByte(-1);
            os.writeInt(callbackID);
            os.writeInt(msgID);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static void sendCallbackDoneCommand(DataOutputStream os, ValueObject value) throws CommandException {
        try {
            os.writeByte(-2);
            Commands.writeValue(os, value, false);
            os.flush();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static void sendCallbackStreamCommand(DataOutputStream os, int callbackID, int msgID) throws CommandException {
        try {
            os.writeByte(-3);
            os.writeInt(callbackID);
            os.writeInt(msgID);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static void readBackValue(DataInputStream is, ValueObject value, byte expectedType) throws CommandException {
        try {
            byte v = is.readByte();
            switch (v) {
                case 2: {
                    Commands.readValue(is, value);
                    if (expectedType != -1 && expectedType != value.type && (expectedType != 50 || value.type != 51)) {
                        throw new UnexpectedCommandException(TYPE_INVALID_FOR_COMMAND, true, value);
                    }
                    break;
                }
                case 6: {
                    int code = is.readInt();
                    Commands.readValue(is, value);
                    throw new CommandErrorException(code, value);
                }
                default: {
                    throw new UnexpectedCommandException(UNKNOWN_COMMAND, false, new Byte(v));
                }
            }
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static GetClassReturn sendGetClassCommand(DataOutputStream os, DataInputStream is, String className) throws CommandException {
        try {
            os.writeByte(1);
            os.writeUTF(className);
            os.flush();
            GetClassReturn ret = new GetClassReturn();
            byte v = is.readByte();
            switch (v) {
                case 8: {
                    ret.classID = is.readInt();
                    ret.isInterface = is.readBoolean();
                    ret.isAbstract = is.readBoolean();
                    ret.superClassname = is.readUTF();
                    return ret;
                }
                case 6: {
                    int code = is.readInt();
                    ValueObject value = new ValueObject();
                    Commands.readValue(is, value);
                    throw new CommandErrorException(code, value);
                }
            }
            throw new UnexpectedCommandException(UNKNOWN_COMMAND, false, new Byte(v));
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static GetClassIDReturn sendGetClassFromIDCommand(DataOutputStream os, DataInputStream is, int classID) throws CommandException {
        try {
            os.writeByte(12);
            os.writeInt(classID);
            os.flush();
            GetClassIDReturn ret = new GetClassIDReturn();
            byte v = is.readByte();
            switch (v) {
                case 13: {
                    ret.className = is.readUTF();
                    ret.isInterface = is.readBoolean();
                    ret.isAbstract = is.readBoolean();
                    ret.superClassname = is.readUTF();
                    return ret;
                }
                case 6: {
                    int code = is.readInt();
                    ValueObject value = new ValueObject();
                    Commands.readValue(is, value);
                    throw new CommandErrorException(code, value);
                }
            }
            throw new UnexpectedCommandException(UNKNOWN_COMMAND, false, new Byte(v));
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static void sendGetObjectData(DataOutputStream os, DataInputStream is, int objectID, ValueObject valueReturn) throws CommandException {
        try {
            os.writeByte(14);
            os.writeInt(objectID);
            os.flush();
            Commands.readBackValue(is, valueReturn, (byte)51);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static void sendErrorCommand(DataOutputStream os, int code, ValueObject errorValue) throws CommandException {
        try {
            os.writeByte(6);
            os.writeInt(code);
            Commands.writeValue(os, errorValue, false);
            os.flush();
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static void sendNewInstance(DataOutputStream os, DataInputStream is, int classId, String initializationString, ValueObject newValueReturn) throws CommandException {
        try {
            os.writeByte(11);
            os.writeInt(classId);
            os.writeUTF(initializationString);
            os.flush();
            Commands.readBackValue(is, newValueReturn, (byte)-1);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static void sendInvokeMethodCommand(DataOutputStream os, DataInputStream is, int methodID, ValueObject invokeOn, ValueObject parms, ValueObject valueReturn) throws CommandException {
        try {
            os.writeByte(15);
            os.writeInt(methodID);
            Commands.writeValue(os, invokeOn, false);
            Commands.writeValue(os, parms, false);
            os.flush();
            Commands.readBackValue(is, valueReturn, (byte)-1);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static class ValueObject {
        public byte type = 0;
        public byte aByte;
        public char aChar;
        public double aDouble;
        public float aFloat;
        public int anInt;
        public short aShort;
        public long aLong;
        public boolean aBool;
        public int objectID;
        public int classID;
        public Object anObject;

        public Object getAsObject() {
            switch (this.type) {
                case 0: {
                    return null;
                }
                case 5: 
                case 6: {
                    return new Byte(this.aByte);
                }
                case 7: 
                case 8: {
                    return new Character(this.aChar);
                }
                case 9: 
                case 10: {
                    return new Double(this.aDouble);
                }
                case 11: 
                case 12: {
                    return new Float(this.aFloat);
                }
                case 3: 
                case 4: {
                    return new Integer(this.anInt);
                }
                case 13: 
                case 14: {
                    return new Short(this.aShort);
                }
                case 15: 
                case 16: {
                    return new Long(this.aLong);
                }
                case 1: 
                case 2: {
                    return this.aBool ? Boolean.TRUE : Boolean.FALSE;
                }
                case 17: {
                    return (String)this.anObject;
                }
                case 23: {
                    return this.anObject;
                }
            }
            return null;
        }

        public void setAsObject(Object value, int valueClassID) {
            switch (valueClassID) {
                case 0: {
                    this.set();
                    break;
                }
                case 6: {
                    this.set((Byte)value);
                    break;
                }
                case 8: {
                    this.set((Character)value);
                    break;
                }
                case 10: {
                    this.set((Double)value);
                    break;
                }
                case 12: {
                    this.set((Float)value);
                    break;
                }
                case 4: {
                    this.set((Integer)value);
                    break;
                }
                case 14: {
                    this.set((Short)value);
                    break;
                }
                case 16: {
                    this.set((Long)value);
                    break;
                }
                case 2: {
                    this.set((Boolean)value);
                    break;
                }
                case 17: {
                    this.set((String)value);
                    break;
                }
                default: {
                    this.set(value, valueClassID);
                }
            }
        }

        public void set() {
            this.type = 0;
            this.anObject = null;
        }

        public void set(byte value) {
            this.type = (byte)5;
            this.aByte = value;
            this.anObject = null;
        }

        public void set(Byte value) {
            this.type = (byte)6;
            this.aByte = value;
            this.anObject = null;
        }

        public void set(char value) {
            this.type = (byte)7;
            this.aChar = value;
            this.anObject = null;
        }

        public void set(Character value) {
            this.type = (byte)8;
            this.aChar = value.charValue();
            this.anObject = null;
        }

        public void set(double value) {
            this.type = (byte)9;
            this.aDouble = value;
            this.anObject = null;
        }

        public void set(Double value) {
            this.type = (byte)10;
            this.aDouble = value;
            this.anObject = null;
        }

        public void set(float value) {
            this.type = (byte)11;
            this.aFloat = value;
            this.anObject = null;
        }

        public void set(Float value) {
            this.type = (byte)12;
            this.aFloat = value.floatValue();
            this.anObject = null;
        }

        public void set(int value) {
            this.type = (byte)3;
            this.anInt = value;
            this.anObject = null;
        }

        public void set(Integer value) {
            this.type = (byte)4;
            this.anInt = value;
            this.anObject = null;
        }

        public void set(short value) {
            this.type = (byte)13;
            this.aShort = value;
            this.anObject = null;
        }

        public void set(Short value) {
            this.type = (byte)14;
            this.aShort = value;
            this.anObject = null;
        }

        public void set(long value) {
            this.type = (byte)15;
            this.aLong = value;
            this.anObject = null;
        }

        public void set(Long value) {
            this.type = (byte)16;
            this.aLong = value;
            this.anObject = null;
        }

        public void set(boolean value) {
            this.type = 1;
            this.aBool = value;
            this.anObject = null;
        }

        public void set(Boolean value) {
            this.type = (byte)2;
            this.aBool = value;
            this.anObject = null;
        }

        public void set(String value) {
            this.type = (byte)17;
            this.anObject = value;
        }

        public void set(Object value, int classObjectID) {
            this.type = (byte)23;
            this.classID = classObjectID;
            this.anObject = value;
        }

        public void setObjectID(int value) {
            this.type = (byte)50;
            this.objectID = value;
            this.anObject = null;
        }

        public void setArrayIDS(ValueRetrieve retriever, int arraySize, int componentType) {
            this.type = (byte)53;
            this.classID = componentType;
            this.anInt = arraySize;
            this.anObject = retriever;
        }

        public void setObjectID(int value, int classObjectID) {
            this.type = (byte)51;
            this.objectID = value;
            this.classID = classObjectID;
            this.anObject = null;
        }

        public void setException(int throwID, int throwClassID) {
            this.type = (byte)52;
            this.objectID = throwID;
            this.classID = throwClassID;
            this.anObject = null;
        }
    }

    public static interface ValueSender {
        public void sendValue(ValueObject var1);

        public ValueSender nestedArray(ValueObject var1);
    }

    public static interface ValueRetrieve {
        public ValueObject nextValue() throws EOFException;
    }

    public static class GetClassReturn {
        public int classID;
        public boolean isInterface;
        public boolean isAbstract;
        public String superClassname;
    }

    public static class GetClassIDReturn {
        public String className;
        public boolean isInterface;
        public boolean isAbstract;
        public String superClassname;
    }
}

