/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ve.internal.cde.core.AlignmentTabPage;
import org.eclipse.ve.internal.cde.core.AlignmentWindowAction;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.EditDomain;

public class AlignmentWindow
extends Window {
    protected List tabClasses = new ArrayList(2);
    protected List tabs = new ArrayList(2);
    protected TabFolder tabFolder;
    private Point location;
    protected AlignmentWindowAction windowAction;
    protected ISelection selection = StructuredSelection.EMPTY;
    protected IEditorPart editorPart;
    static /* synthetic */ Class class$0;

    public AlignmentWindow(Shell parentShell, AlignmentWindowAction windowAction) {
        super(parentShell);
        this.setShellStyle(2160);
        this.windowAction = windowAction;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CDEMessages.getString("AlignmentWindow.title"));
    }

    protected Point getInitialSize() {
        Point initSize = this.getShell().computeSize(-1, -1, true);
        if (initSize.x < 100) {
            initSize.x = 100;
        }
        if (initSize.x < 90) {
            initSize.y = 90;
        }
        return initSize;
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.getLocation() == null) {
            return super.getInitialLocation(initialSize);
        }
        Rectangle displayBounds = this.getShell().getDisplay().getClientArea();
        Point loc = this.getLocation();
        if (loc.x + initialSize.x > displayBounds.x + displayBounds.width) {
            loc.x = displayBounds.x + displayBounds.width - initialSize.x;
        }
        if (loc.y + initialSize.y > displayBounds.y + displayBounds.height) {
            loc.y = displayBounds.y + displayBounds.height - initialSize.y;
        }
        this.setLocation(loc);
        return loc;
    }

    protected Control createContents(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < this.tabs.size()) {
            block4: {
                AlignmentTabPage page = (AlignmentTabPage)this.tabs.get(i);
                if (page == null) {
                    try {
                        page = this.createTabPage(i);
                    }
                    catch (CoreException e) {
                        CDEPlugin.getPlugin().getLog().log(e.getStatus());
                        this.tabs.remove(i);
                        this.tabClasses.remove(i);
                        --i;
                        break block4;
                    }
                }
                this.createTabItem(page);
            }
            ++i;
        }
        this.tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AlignmentWindow.this.tabFolder = null;
            }
        });
        return this.tabFolder;
    }

    protected void createTabItem(AlignmentTabPage page) {
        TabItem tab = new TabItem(this.tabFolder, 0);
        tab.setData((Object)page);
        tab.setText(page.getText());
        tab.setToolTipText(page.getToolTipText());
        tab.setImage(page.getImage());
        if (this.tabFolder.getItemCount() == 1) {
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TabItem newSelectedTab = (TabItem)e.item;
                    AlignmentWindow.this.createPageControl(newSelectedTab);
                }
            });
            this.createPageControl(tab);
        }
    }

    private void createPageControl(TabItem tab) {
        AlignmentTabPage page;
        if (tab != null && !tab.isDisposed() && tab.getControl() == null && (page = (AlignmentTabPage)tab.getData()) != null) {
            tab.setControl(page.getControl((Composite)this.tabFolder));
            Point size = this.getInitialSize();
            Point location = this.getInitialLocation(size);
            this.getShell().setBounds(location.x, location.y, size.x, size.y);
        }
    }

    protected AlignmentTabPage createTabPage(int i) throws CoreException {
        try {
            AlignmentTabPage page = (AlignmentTabPage)((Class)this.tabClasses.get(i)).newInstance();
            page.setSelectionProvider(this.windowAction.getSelectionProvider());
            page.setEditorPart(this.editorPart);
            page.update(this.selection);
            this.tabs.set(i, page);
            return page;
        }
        catch (InstantiationException e) {
            throw new CoreException((IStatus)new Status(2, CDEPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
        }
        catch (IllegalAccessException e) {
            throw new CoreException((IStatus)new Status(2, CDEPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
        }
    }

    public void hide() {
        Shell shell = this.getShell();
        if (shell != null) {
            shell.setVisible(false);
        }
    }

    public boolean isHidden() {
        Shell shell = this.getShell();
        return shell != null ? !shell.isVisible() : true;
    }

    protected void addTabPage(Class tabPageClass) {
        if (!this.tabClasses.contains(tabPageClass)) {
            this.tabClasses.add(tabPageClass);
            this.tabs.add(null);
            if (this.tabFolder != null) {
                int i = this.tabClasses.size() - 1;
                try {
                    AlignmentTabPage page = this.createTabPage(i);
                    this.createTabItem(page);
                }
                catch (CoreException e) {
                    CDEPlugin.getPlugin().getLog().log(e.getStatus());
                    this.tabs.remove(i);
                    this.tabClasses.remove(i);
                }
            }
        }
    }

    public void update(ISelection selection) {
        this.selection = selection;
        int i = 0;
        while (i < this.tabs.size()) {
            AlignmentTabPage page = (AlignmentTabPage)this.tabs.get(i);
            if (page != null) {
                page.update(selection);
            }
            ++i;
        }
    }

    public void setEditorPart(IEditorPart editorPart) {
        this.editorPart = editorPart;
        if (editorPart != null) {
            EditDomain dom;
            AlignmentWindowAction.AlignmentTabController tabs;
            org.eclipse.gef.EditDomain odom;
            EditPartViewer primaryViewer;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.gef.EditPartViewer;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((primaryViewer = (EditPartViewer)editorPart.getAdapter((Class)clazz)) != null && (odom = primaryViewer.getEditDomain()) instanceof EditDomain && (tabs = (AlignmentWindowAction.AlignmentTabController)(dom = (EditDomain)odom).getViewerData(primaryViewer, "alignmentTab_Key")) != null) {
                tabs.setAlignWindowAction(this.windowAction);
                List tabClasses = tabs.getTabClasses();
                int i = 0;
                while (i < tabClasses.size()) {
                    this.addTabPage((Class)tabClasses.get(i));
                    ++i;
                }
            }
        }
        int i = 0;
        while (i < this.tabs.size()) {
            AlignmentTabPage page = (AlignmentTabPage)this.tabs.get(i);
            if (page != null) {
                page.setEditorPart(editorPart);
            }
            ++i;
        }
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public Point getLocation() {
        return this.location;
    }
}

