/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ve.internal.cde.core.AlignmentWindow;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.EditDomain;

public class AlignmentWindowAction
extends Action {
    public static String ACTION_ID = "AlignmentWindowAction";
    protected static Point fDialogLoc;
    protected AlignmentWindow fDialog;
    protected IWorkbenchWindow workbenchWindow;
    protected IEditorPart editorPart;
    protected IEditorActionBarContributor contributor;
    protected static final String WINDOW_TITLE;
    protected static final String ALIGNMENT_TAB_KEY = "alignmentTab_Key";
    private IPartListener alignmentWindowPartListener = new IPartListener(){
        private boolean currentEPBeingClosed = false;

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                this.currentEPBeingClosed = false;
                AlignmentWindowAction.this.setEditorPart((IEditorPart)part);
            } else if (this.currentEPBeingClosed) {
                this.currentEPBeingClosed = false;
                AlignmentWindowAction.this.setEditorPart(null);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == AlignmentWindowAction.this.editorPart) {
                this.currentEPBeingClosed = true;
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private ISelectionListener selListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (AlignmentWindowAction.this.fDialog != null && !AlignmentWindowAction.this.fDialog.isHidden()) {
                AlignmentWindowAction.this.update(selection);
            }
        }
    };
    private ISelectionProvider selectionProvider = new ISelectionProvider(){
        private ISelection selection = StructuredSelection.EMPTY;

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }
    };
    static /* synthetic */ Class class$0;

    static {
        WINDOW_TITLE = CDEMessages.getString("AlignmentWindow.title");
    }

    public static void addAlignmentTab(EditPartViewer viewer, Class tabClass) {
        org.eclipse.gef.EditDomain odom = viewer.getEditDomain();
        if (odom instanceof EditDomain) {
            EditDomain dom = (EditDomain)odom;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.ve.internal.cde.core.AlignmentTabPage;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(tabClass)) {
                throw new IllegalArgumentException(tabClass.toString());
            }
            AlignmentTabController tabs = (AlignmentTabController)dom.getViewerData(viewer, ALIGNMENT_TAB_KEY);
            if (tabs == null) {
                tabs = new AlignmentTabController();
                dom.setViewerData(viewer, ALIGNMENT_TAB_KEY, tabs);
            }
            tabs.add(tabClass);
        }
    }

    public AlignmentWindowAction(IWorkbenchWindow workbenchWindow, IEditorActionBarContributor contributor) {
        super(CDEMessages.getString("AlignmentWindowAction.label"), 2);
        this.setId(ACTION_ID);
        this.setImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/elcl16/aligndialog_obj.gif"));
        this.setDisabledImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/dlcl16/aligndialog_obj.gif"));
        this.setHoverImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/clcl16/aligndialog_obj.gif"));
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("checked".equals(event.getProperty())) {
                    AlignmentWindowAction.this.setTooltip();
                }
            }
        });
        this.setTooltip();
        this.workbenchWindow = workbenchWindow;
        this.contributor = contributor;
        workbenchWindow.getSelectionService().addSelectionListener(this.selListener);
        workbenchWindow.getPartService().addPartListener(this.alignmentWindowPartListener);
    }

    private void setTooltip() {
        this.setToolTipText(this.isChecked() ? CDEMessages.getString("AlignmentWindowAction.tooltip.hide") : CDEMessages.getString("AlignmentWindowAction.tooltip.show"));
    }

    protected void updateTabs(final Class tabClass) {
        this.workbenchWindow.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AlignmentWindowAction.this.fDialog != null) {
                    AlignmentWindowAction.this.fDialog.addTabPage(tabClass);
                }
            }
        });
    }

    protected void setEditorPart(IEditorPart anEditorPart) {
        if (this.editorPart == anEditorPart) {
            return;
        }
        this.editorPart = anEditorPart;
        if (this.editorPart != null && this.editorPart.getEditorSite().getActionBarContributor() == this.contributor) {
            this.run();
        } else if (this.fDialog != null) {
            this.fDialog.hide();
            this.fDialog.setEditorPart(null);
            this.update((ISelection)StructuredSelection.EMPTY);
        }
    }

    ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public void dispose() {
        this.workbenchWindow.getSelectionService().removeSelectionListener(this.selListener);
        this.workbenchWindow.getPartService().removePartListener(this.alignmentWindowPartListener);
        this.editorPart = null;
        this.contributor = null;
        this.workbenchWindow = null;
        if (this.fDialog != null) {
            this.fDialog.close();
            this.fDialog = null;
        }
    }

    public void run() {
        if (!this.isChecked()) {
            if (this.fDialog != null) {
                this.fDialog.close();
                this.fDialog = null;
            }
        } else {
            if (this.fDialog == null) {
                this.fDialog = new AlignmentWindow(this.workbenchWindow.getShell(), this);
                if (fDialogLoc == null) {
                    Preferences preferences = CDEPlugin.getPlugin().getPluginPreferences();
                    int x = preferences.getInt(CDEPlugin.ALIGNMENTWINDOW_X);
                    int y = preferences.getInt(CDEPlugin.ALIGNMENTWINDOW_Y);
                    this.fDialog.setLocation(new Point(x, y));
                    fDialogLoc = this.fDialog.getLocation();
                } else {
                    this.fDialog.setLocation(fDialogLoc);
                }
                this.fDialog.open();
                this.fDialog.getShell().addControlListener(new ControlListener(){

                    public void controlMoved(ControlEvent event) {
                        fDialogLoc = AlignmentWindowAction.this.fDialog.getShell().getLocation();
                    }

                    public void controlResized(ControlEvent event) {
                    }
                });
                this.fDialog.getShell().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        AlignmentWindowAction.this.persistPreferences();
                        AlignmentWindowAction.this.setChecked(false);
                        AlignmentWindowAction.this.fDialog = null;
                        AlignmentWindowAction.this.update((ISelection)StructuredSelection.EMPTY);
                    }
                });
            } else {
                this.fDialog.open();
            }
            this.fDialog.setEditorPart(this.editorPart);
            this.update(this.workbenchWindow.getSelectionService().getSelection());
        }
    }

    protected void persistPreferences() {
        if (fDialogLoc != null) {
            Preferences preferences = CDEPlugin.getPlugin().getPluginPreferences();
            preferences.setValue(CDEPlugin.ALIGNMENTWINDOW_X, AlignmentWindowAction.fDialogLoc.x);
            preferences.setValue(CDEPlugin.ALIGNMENTWINDOW_Y, AlignmentWindowAction.fDialogLoc.y);
        }
    }

    protected void update(ISelection selection) {
        this.selectionProvider.setSelection(selection);
        if (this.fDialog != null) {
            this.fDialog.update(selection);
        }
    }

    protected static class AlignmentTabController {
        private AlignmentWindowAction alignWindowAction;
        private List tabClasses = new ArrayList(1);

        protected AlignmentTabController() {
        }

        public void setAlignWindowAction(AlignmentWindowAction alignWindowAction) {
            this.alignWindowAction = alignWindowAction;
        }

        public AlignmentWindowAction getAlignWindowAction() {
            return this.alignWindowAction;
        }

        public List getTabClasses() {
            return this.tabClasses;
        }

        public void add(Class tabClass) {
            if (!this.tabClasses.contains(tabClass)) {
                this.tabClasses.add(tabClass);
                if (this.getAlignWindowAction() != null) {
                    this.getAlignWindowAction().updateTabs(tabClass);
                }
            }
        }
    }
}

