/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.gef.EditPart;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IModelAdapterFactory;

public class CDEUtilities {
    public static boolean isUnset(Notification msg) {
        if (msg.getFeature() instanceof EStructuralFeature) {
            EStructuralFeature sf = (EStructuralFeature)msg.getFeature();
            return !sf.isUnsettable() && msg.isReset();
        }
        return false;
    }

    public static Map.Entry putEMapEntry(EMap map, Map.Entry entry) {
        int oldEntryIndex = map.indexOfKey(entry.getKey());
        if (oldEntryIndex != -1) {
            return map.set(oldEntryIndex, entry);
        }
        map.add(entry);
        return null;
    }

    public static IModelAdapterFactory getModelAdapterFactory(EditDomain domain) {
        return (IModelAdapterFactory)domain.getData("com.ibm.etools.ide.modelfactorykey");
    }

    public static IModelAdapterFactory getModelAdapterFactory(EditPart editpart) {
        return CDEUtilities.getModelAdapterFactory(EditDomain.getEditDomain(editpart));
    }

    public static void setModelAdapterFactory(EditDomain domain, IModelAdapterFactory factory) {
        domain.setData("com.ibm.etools.ide.modelfactorykey", factory);
    }

    public static String lowCaseFirstCharacter(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (!(!Character.isUpperCase(name.charAt(0)) || name.length() >= 3 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(2)))) {
            char[] a = name.toCharArray();
            a[0] = Character.toLowerCase(a[0]);
            return new String(a);
        }
        return name;
    }

    public static class ESettingsEList
    extends EContentsEList {
        protected boolean shared;

        public ESettingsEList(EObject eObject, boolean shared) {
            this(eObject, (EStructuralFeature[])((BasicEList)eObject.eClass().getEAllStructuralFeatures()).data(), shared);
        }

        public ESettingsEList(EObject eObject, EStructuralFeature[] eStructuralFeatures, boolean shared) {
            super(eObject, eStructuralFeatures);
            this.shared = shared;
        }

        protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
            return !this.shared ? eStructuralFeature instanceof EAttribute || ((EReference)eStructuralFeature).isContainment() : true;
        }

        protected ListIterator newListIterator() {
            return this.resolve() ? new ResolvingFeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.shared) : new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.shared);
        }

        public List basicList() {
            return new ESettingsEList(this, this.eObject, this.eStructuralFeatures, this.shared){
                final /* synthetic */ ESettingsEList this$1;
                {
                    this.this$1 = eSettingsEList;
                }

                protected boolean resolve() {
                    return false;
                }
            };
        }

        public ListIterator basicListIterator() {
            if (this.eStructuralFeatures == null) {
                return EContentsEList.FeatureIteratorImpl.EMPTY_ITERATOR;
            }
            return new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.shared);
        }

        public Iterator basicIterator() {
            return this.basicListIterator();
        }

        public ListIterator basicListIterator(int index) {
            if (this.eStructuralFeatures == null) {
                if (index < 0 || index > 1) {
                    throw new IndexOutOfBoundsException("index=" + index + ", size=0");
                }
                return EContentsEList.FeatureIteratorImpl.EMPTY_ITERATOR;
            }
            ListIterator result = this.basicListIterator();
            int i = 0;
            while (i < index) {
                result.next();
                ++i;
            }
            return result;
        }

        public class FeatureIteratorImpl
        extends EContentsEList.FeatureIteratorImpl {
            protected boolean shared;

            public FeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures, boolean shared) {
                super(eObject, eStructuralFeatures);
                this.shared = shared;
            }

            protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
                return ESettingsEList.this.isIncluded(eStructuralFeature);
            }
        }

        public class ResolvingFeatureIteratorImpl
        extends FeatureIteratorImpl {
            public ResolvingFeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures, boolean shared) {
                super(eObject, eStructuralFeatures, shared);
            }

            protected boolean resolve() {
                return true;
            }
        }
    }
}

