/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.internal.ImageDataHelper;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.cde.core.IImageListener;
import org.eclipse.ve.internal.cde.core.IImageNotifier;
import org.eclipse.ve.internal.cde.core.ImageFigure;

public class ImageFigureController {
    protected ImageFigure figure;
    protected IImageNotifier imageNotifier;
    protected Image image;
    private List lightenFigures;
    private ImageData imageData;
    private byte refreshState = 0;
    private static final byte NO_REFRESH_PENDING = 0;
    private static final byte RECREATE_IMAGE = 1;
    private static final byte FIGURE_MOVED = 2;
    private Listeners listener;

    public void finalize() {
        this.deactivate();
        if (this.figure != null) {
            this.figure.setToolTip(null);
        }
    }

    public IFigure getFigure() {
        return this.figure;
    }

    public void setImageFigure(ImageFigure figure) {
        this.figure = figure;
    }

    public void deactivate() {
        if (this.imageNotifier != null) {
            this.imageNotifier.removeImageListener(this.getListener());
            this.imageNotifier = null;
        }
        ImageFigureController imageFigureController = this;
        synchronized (imageFigureController) {
            if (this.lightenFigures != null) {
                Iterator itr = this.lightenFigures.iterator();
                while (itr.hasNext()) {
                    IFigure fig = (IFigure)itr.next();
                    fig.removeFigureListener((FigureListener)this.getListener());
                }
                this.lightenFigures = null;
            }
            this.refreshState = 0;
        }
        this.disposeImage();
    }

    protected void disposeImage() {
        this.figure.setImage(null);
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        this.imageData = null;
    }

    protected Listeners getListener() {
        if (this.listener == null) {
            this.listener = new Listeners();
        }
        return this.listener;
    }

    public void setImageNotifier(IImageNotifier notifier) {
        this.deactivate();
        if (notifier != null) {
            this.imageNotifier = notifier;
            this.imageNotifier.addImageListener(this.getListener());
            this.imageNotifier.invalidateImage();
            this.imageNotifier.refreshImage();
        }
    }

    protected synchronized void scheduleRefresh(byte refreshType) {
        if (refreshType == 2 && this.lightenFigures == null) {
            return;
        }
        this.refreshState = (byte)(this.refreshState | refreshType);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ImageFigureController imageFigureController = ImageFigureController.this;
                synchronized (imageFigureController) {
                    if (ImageFigureController.this.refreshState != 0) {
                        if (ImageFigureController.this.lightenFigures != null) {
                            ImageFigureController.this.refreshState = (byte)0;
                            this.setAndLightenImageData();
                        }
                        if ((ImageFigureController.this.refreshState & 1) != 0) {
                            ImageFigureController.this.refreshState = (byte)0;
                            this.recreateImage();
                        }
                    }
                }
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void setAndLightenImageData() {
                Image newImage;
                block5: {
                    newImage = null;
                    if (ImageFigureController.this.imageData == null) break block5;
                    ImageData lightenImageData = null;
                    org.eclipse.draw2d.geometry.Rectangle myRect = ImageFigureController.this.figure.getBounds();
                    int myOriginX = myRect.x;
                    int myOriginY = myRect.y;
                    Region region = new Region();
                    try {
                        Iterator itr = ImageFigureController.this.lightenFigures.iterator();
                        while (true) {
                            block6: {
                                if (itr.hasNext()) break block6;
                                lightenImageData = ImageDataHelper.mixAlphaWithinRegion((ImageData)ImageFigureController.this.imageData, (Region)region, (double)0.5, (RGB)new RGB(255, 255, 255));
                                break;
                            }
                            IFigure fig = (IFigure)itr.next();
                            org.eclipse.draw2d.geometry.Rectangle figRect = fig.getBounds();
                            region.add(new Rectangle(figRect.x - myOriginX, figRect.y - myOriginY, figRect.width, figRect.height));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        region.dispose();
                        throw throwable;
                    }
                    {
                        Object var10_12 = null;
                    }
                    region.dispose();
                    newImage = new Image((Device)Display.getCurrent(), lightenImageData);
                }
                ImageFigureController.this.figure.setImage(newImage);
                if (ImageFigureController.this.image != null) {
                    ImageFigureController.this.image.dispose();
                }
                ImageFigureController.this.image = newImage;
            }

            private void recreateImage() {
                Image newImage = null;
                if (ImageFigureController.this.imageData != null) {
                    newImage = new Image((Device)Display.getCurrent(), ImageFigureController.this.imageData);
                }
                ImageFigureController.this.figure.setImage(newImage);
                if (ImageFigureController.this.image != null) {
                    ImageFigureController.this.image.dispose();
                }
                ImageFigureController.this.image = newImage;
            }
        });
    }

    public void addLightenFigure(IFigure fig) {
        ImageFigureController imageFigureController = this;
        synchronized (imageFigureController) {
            if (this.lightenFigures == null) {
                this.lightenFigures = new ArrayList(2);
            }
            this.lightenFigures.add(fig);
            if (fig != this.figure) {
                fig.addFigureListener((FigureListener)this.getListener());
            }
        }
        if (this.imageNotifier != null) {
            this.scheduleRefresh((byte)2);
        }
    }

    public synchronized void removeLightenFigure(IFigure fig) {
        if (this.lightenFigures != null && this.lightenFigures.remove(fig)) {
            if (fig != this.figure) {
                fig.removeFigureListener((FigureListener)this.getListener());
            }
            if (this.lightenFigures.isEmpty()) {
                this.lightenFigures = null;
                this.scheduleRefresh((byte)1);
            } else {
                this.scheduleRefresh((byte)2);
            }
        }
    }

    private class Listeners
    implements IImageListener,
    FigureListener {
        Listeners() {
        }

        public void imageChanged(ImageData data) {
            ImageFigureController imageFigureController = ImageFigureController.this;
            synchronized (imageFigureController) {
                ImageFigureController.this.imageData = data;
                ImageFigureController.this.scheduleRefresh((byte)1);
            }
        }

        public void figureMoved(IFigure figure) {
            ImageFigureController.this.scheduleRefresh((byte)2);
        }
    }
}

