/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.GridController;
import org.eclipse.ve.internal.cde.core.ShowGridAction;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class SnapToGridAction
extends SelectionAction
implements IPropertyChangeListener {
    public static final String ACTION_ID = "cde.SNAPTOGRID";

    public SnapToGridAction(IEditorPart part, ShowGridAction showGridAction) {
        super((IWorkbenchPart)part);
        this.setText(CDEMessages.getString("SnapToGridAction.label"));
        this.setToolTipText(CDEMessages.getString("SnapToGridAction.tooltip"));
        this.setId(ACTION_ID);
        this.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)CDEMessages.getString("SnapToGridAction.image")));
        this.setEnabled(false);
        showGridAction.addPropertyChangeListener(this);
    }

    protected Command createMoveCommand(List objects) {
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        request.setEditParts(objects);
        request.setMoveDelta(new Point(0, 0));
        request.setLocation(new Point(0, 0));
        Iterator itr = objects.iterator();
        while (itr.hasNext()) {
            if (itr.next() instanceof EditPart) continue;
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand compoundCmd = new CompoundCommand("");
        int i = 0;
        while (i < objects.size()) {
            EditPart object = (EditPart)objects.get(i);
            Command cmd = object.getCommand((Request)request);
            if (cmd != null) {
                compoundCmd.append(cmd);
            }
            ++i;
        }
        return compoundCmd.isEmpty() ? null : compoundCmd.unwrap();
    }

    protected boolean calculateEnabled() {
        Iterator itr;
        List editParts = this.getSelectedObjects();
        boolean enabled = false;
        if (editParts.size() > 0 && (itr = editParts.iterator()).hasNext()) {
            GridController gridController;
            Object ep = itr.next();
            if (ep instanceof EditPart && (gridController = GridController.getGridController(((EditPart)ep).getParent())) != null && gridController.isGridShowing()) {
                enabled = true;
            }
            enabled = false;
        }
        return enabled;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("Show grid")) {
            this.refresh();
        }
    }

    public void run() {
        this.execute(this.createMoveCommand(this.getSelectedObjects()));
    }
}

