/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.ve.internal.cde.commands.ApplyVisualInfoCommand;
import org.eclipse.ve.internal.cde.commands.CancelKeyedValueCommand;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.Diagram;
import org.eclipse.ve.internal.cdm.KeyedValueHolder;
import org.eclipse.ve.internal.cdm.VisualInfo;

public class VisualInfoPolicy {
    public static VisualInfo getVisualInfo(EditPart ep) {
        return VisualInfoPolicy.getVisualInfo(ep.getModel(), ep.getRoot().getViewer());
    }

    public static VisualInfo getVisualInfo(Object model, EditPartViewer viewer) {
        EditDomain dom = (EditDomain)viewer.getEditDomain();
        AnnotationLinkagePolicy al = dom.getAnnotationLinkagePolicy();
        Annotation annot = al.getAnnotation(model);
        if (annot == null) {
            return null;
        }
        Diagram diagram = dom.getDiagram(viewer);
        VisualInfo vi = annot.getVisualInfo(diagram);
        return vi;
    }

    public static Command applyVisualInfoSetting(Object modelObject, Object newValue, EditDomain domain, Diagram diagram) {
        return new ApplyVisualInfoCommand(modelObject, newValue, domain, diagram);
    }

    public static Command cancelVisualInfoSetting(VisualInfo vi, String key) {
        if (!vi.getKeyedValues().containsKey((Object)key)) {
            return null;
        }
        if (vi.getKeyedValues().size() == 1) {
            return AnnotationPolicy.cancelVisualInfo(vi);
        }
        CancelKeyedValueCommand cmd = new CancelKeyedValueCommand();
        cmd.setTarget((KeyedValueHolder)vi);
        cmd.setKey(key);
        return cmd;
    }

    public static Command cancelVisualInfo(VisualInfo vi) {
        return AnnotationPolicy.cancelVisualInfo(vi);
    }

    public static abstract class VisualInfoListener
    extends AnnotationPolicy.AnnotationListener {
        protected Diagram diagram;
        protected VisualInfo visualInfo;
        protected Adapter visualInfoAdapter;
        static /* synthetic */ Class class$0;

        public VisualInfoListener(Object model, Diagram diagram, EditDomain domain) {
            super(model, domain);
            this.diagram = diagram;
            if (this.annotation != null) {
                this.setupVisualInfoAdapter(this.annotation.getVisualInfo(diagram));
            }
        }

        public abstract void notifyVisualInfo(int var1, VisualInfo var2, VisualInfo var3);

        public abstract void notifyVisualInfoChanges(Notification var1);

        public void removeListening() {
            super.removeListening();
            if (this.diagram != null) {
                this.removeVisualInfoAdapter();
                this.diagram = null;
            }
        }

        public void notifyAnnotation(int eventType, Annotation oldAnnotation, Annotation newAnnotation) {
            if (eventType == 1) {
                if (oldAnnotation != newAnnotation) {
                    this.setupVisualInfoAdapter(newAnnotation != null ? newAnnotation.getVisualInfo(this.diagram) : null);
                }
            } else {
                this.removeVisualInfoAdapter();
            }
        }

        public void notifyAnnotationChanges(Notification msg) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.ve.internal.cdm.Annotation;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (msg.getFeatureID((Class)clazz) == 1) {
                block1 : switch (msg.getEventType()) {
                    case 1: 
                    case 3: {
                        VisualInfo vi = (VisualInfo)msg.getNewValue();
                        if (vi.getDiagram() != this.diagram) break;
                        if (!msg.isTouch()) {
                            this.setupVisualInfoAdapter(vi);
                        }
                        this.notifyVisualInfo(1, (VisualInfo)msg.getOldValue(), vi);
                        break;
                    }
                    case 5: {
                        Iterator itr = ((List)msg.getNewValue()).iterator();
                        while (itr.hasNext()) {
                            VisualInfo vi = (VisualInfo)itr.next();
                            if (vi.getDiagram() != this.diagram) continue;
                            this.setupVisualInfoAdapter(vi);
                            this.notifyVisualInfo(1, null, vi);
                            break block1;
                        }
                        break;
                    }
                    case 4: {
                        VisualInfo vi = (VisualInfo)msg.getOldValue();
                        if (vi.getDiagram() != this.diagram) break;
                        this.removeVisualInfoAdapter();
                        this.notifyVisualInfo(2, vi, null);
                        break;
                    }
                    case 6: {
                        Iterator itr = ((List)msg.getOldValue()).iterator();
                        while (itr.hasNext()) {
                            VisualInfo vi = (VisualInfo)itr.next();
                            if (vi.getDiagram() != this.diagram) continue;
                            this.removeVisualInfoAdapter();
                            this.notifyVisualInfo(2, vi, null);
                            break block1;
                        }
                        break;
                    }
                }
            }
        }

        private void setupVisualInfoAdapter(VisualInfo visualInfo) {
            this.removeVisualInfoAdapter();
            this.visualInfo = visualInfo;
            if (visualInfo != null) {
                this.visualInfoAdapter = new AdapterImpl(this){
                    final /* synthetic */ VisualInfoListener this$1;
                    {
                        this.this$1 = visualInfoListener;
                    }

                    public void notifyChanged(Notification msg) {
                        if (msg.getEventType() == 8) {
                            VisualInfoListener.access$0(this.this$1);
                        } else {
                            this.this$1.notifyVisualInfoChanges(msg);
                        }
                    }
                };
                visualInfo.eAdapters().add(this.visualInfoAdapter);
            }
        }

        private void removeVisualInfoAdapter() {
            if (this.visualInfoAdapter != null) {
                Adapter a = this.visualInfoAdapter;
                this.visualInfoAdapter = null;
                this.visualInfo.eAdapters().remove(a);
                this.visualInfo = null;
            }
        }

        static /* synthetic */ void access$0(VisualInfoListener visualInfoListener) {
            visualInfoListener.removeVisualInfoAdapter();
        }
    }
}

