/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IZoomListener;

public class ZoomController {
    public static final String ZOOM_KEY = "org.eclipse.ve.internal.cde.core.zoomkey";
    protected List listeners = new ArrayList(5);
    protected int zoomValue = 100;
    private int unzoomRounder = 50;
    static /* synthetic */ Class class$0;

    public static ZoomController getZoomController(IEditorPart activeEditor) {
        EditPartViewer viewer;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.gef.GraphicalViewer;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((viewer = (EditPartViewer)activeEditor.getAdapter((Class)clazz)) != null) {
            EditDomain dom = (EditDomain)viewer.getEditDomain();
            return (ZoomController)dom.getViewerData(viewer, ZOOM_KEY);
        }
        return null;
    }

    public static ZoomController getZoomController(EditPart editPart) {
        EditPartViewer viewer = editPart.getRoot().getViewer();
        EditDomain dom = (EditDomain)viewer.getEditDomain();
        return (ZoomController)dom.getViewerData(viewer, ZOOM_KEY);
    }

    public void addZoomListener(IZoomListener listener) {
        this.listeners.add(listener);
    }

    public void removeZoomListener(IZoomListener listener) {
        this.listeners.remove(listener);
    }

    public int getZoomValue() {
        return this.zoomValue;
    }

    public void setZoomValue(int newZoom) {
        if (newZoom < 1) {
            newZoom = 1;
        }
        int oldZoom = this.zoomValue;
        this.zoomValue = newZoom;
        this.unzoomRounder = (this.zoomValue * 10 / 2 + 5) / 10;
        int i = 0;
        while (i < this.listeners.size()) {
            ((IZoomListener)this.listeners.get(i)).zoomChanged(this.zoomValue, oldZoom);
            ++i;
        }
    }

    public int zoomCoordinate(int coordinate) {
        return (coordinate * this.zoomValue + 50) / 100;
    }

    public int unzoomCoordinate(int coordinate) {
        return (coordinate * 100 + this.unzoomRounder) / this.zoomValue;
    }

    public double zoomCoordinateReal(int coordinate) {
        return (double)(coordinate * this.zoomValue) / 100.0;
    }

    public double unzoomCoordinateReal(int coordinate) {
        return (double)coordinate * 100.0 / (double)this.zoomValue;
    }
}

