/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.emf;

import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.IModelAdapterFactory;
import org.eclipse.ve.internal.cde.emf.ClassDescriptorDecoratorPolicy;

public class DefaultModelAdapterFactory
implements IModelAdapterFactory {
    protected ClassDescriptorDecoratorPolicy policy;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DefaultModelAdapterFactory(ClassDescriptorDecoratorPolicy policy) {
        this.policy = policy;
    }

    public Object getAdapter(Object modelObject, Class adapterClass) {
        EditPart ep;
        if (adapterClass.isInstance(modelObject)) {
            return modelObject;
        }
        Object adapter = this.createAdapter(modelObject);
        if (adapterClass.isInstance(adapter)) {
            return adapter;
        }
        if (adapter instanceof IAdaptable) {
            return ((IAdaptable)adapter).getAdapter(adapterClass);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ve.internal.cde.core.IConstraintHandler;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapterClass == clazz && (ep = this.createEditPart(modelObject)) != null) {
            return ((IAdaptable)ep).getAdapter(adapterClass);
        }
        return null;
    }

    protected Object createAdapter(Object modelObject) {
        if (!(modelObject instanceof EObject)) {
            return null;
        }
        String classString = this.policy.getModelAdapterClassname((EClassifier)((EObject)modelObject).eClass());
        if (classString == null) {
            return null;
        }
        try {
            Class adapterClass = CDEPlugin.getClassFromString(classString);
            Object adapter = null;
            try {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("[Ljava.lang.Object;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Constructor ctor = adapterClass.getConstructor(classArray);
                adapter = ctor.newInstance(modelObject);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                adapter = adapterClass.newInstance();
            }
            CDEPlugin.setInitializationData(adapter, classString, null);
            return adapter;
        }
        catch (Exception e) {
            String message = MessageFormat.format(CDEMessages.getString("Object.noinstantiate_EXC_"), classString);
            Status s = new Status(2, CDEPlugin.getPlugin().getPluginID(), 0, message, (Throwable)e);
            CDEPlugin.getPlugin().getLog().log((IStatus)s);
            return null;
        }
    }

    protected EditPart createEditPart(Object modelObject) {
        String epClassString = this.policy.getGraphViewClassname((EClassifier)((EObject)modelObject).eClass());
        if (epClassString == null) {
            return null;
        }
        try {
            Class editpartClass = CDEPlugin.getClassFromString(epClassString);
            EditPart editpart = null;
            try {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("[Ljava.lang.Object;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Constructor ctor = editpartClass.getConstructor(classArray);
                editpart = (EditPart)ctor.newInstance(modelObject);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                editpart = (EditPart)editpartClass.newInstance();
                editpart.setModel(modelObject);
            }
            CDEPlugin.setInitializationData(editpart, epClassString, null);
            return editpart;
        }
        catch (Exception e) {
            String message = MessageFormat.format(CDEMessages.getString("Object.noinstantiate_EXC_"), epClassString);
            Status s = new Status(2, CDEPlugin.getPlugin().getPluginID(), 0, message, (Throwable)e);
            CDEPlugin.getPlugin().getLog().log((IStatus)s);
            return null;
        }
    }
}

