/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.properties;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.properties.AbstractAnnotationPropertyDescriptor;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.propertysheet.DefaultWrapperedValidator;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.ISourced;
import org.eclipse.ve.internal.propertysheet.ISourcedPropertyDescriptor;
import org.eclipse.ve.internal.propertysheet.StringCellEditor;

public class NameInCompositionPropertyDescriptor
extends AbstractAnnotationPropertyDescriptor {
    public static final String NAME_IN_COMPOSITION_KEY = "org.eclipse.ve.internal.cde.core.nameincomposition";

    public NameInCompositionPropertyDescriptor() {
        this(CDEMessages.getString("PropertyDescriptor.NameInComposition.DisplayName"));
    }

    public NameInCompositionPropertyDescriptor(String displayNameToUse) {
        this(displayNameToUse, null);
    }

    public NameInCompositionPropertyDescriptor(String displayNameToUse, ICellEditorValidator additionalValidator) {
        super(NAME_IN_COMPOSITION_KEY, displayNameToUse);
        this.setValidator((ICellEditorValidator)(additionalValidator != null ? (ICellEditorValidator)new DefaultWrapperedValidator(new ICellEditorValidator[]{new NameValidator(), additionalValidator}) : new NameValidator()));
        this.setAlwaysIncompatible(true);
    }

    protected Object getKeyedValue(BasicEMap.Entry kv) {
        return kv.getValue();
    }

    protected boolean isSetKeyedValue(BasicEMap.Entry kv) {
        return kv.getValue() != null;
    }

    protected BasicEMap.Entry getSetKeyedValue(BasicEMap.Entry oldKV, Object setValue) {
        Object oldValue = oldKV.getValue();
        if (oldValue == setValue || oldValue != null && oldValue.equals(setValue)) {
            return oldKV;
        }
        EStringToStringMapEntryImpl ks = (EStringToStringMapEntryImpl)EcoreFactory.eINSTANCE.create(EcorePackage.eINSTANCE.getEStringToStringMapEntry());
        ks.setKey((Object)NAME_IN_COMPOSITION_KEY);
        if (setValue != null && ((String)setValue).length() > 0) {
            ks.setValue(setValue);
        }
        return ks;
    }

    protected BasicEMap.Entry getUnsetKeyedValue() {
        EStringToStringMapEntryImpl ks = (EStringToStringMapEntryImpl)EcoreFactory.eINSTANCE.create(EcorePackage.eINSTANCE.getEStringToStringMapEntry());
        ks.setKey((Object)NAME_IN_COMPOSITION_KEY);
        return ks;
    }

    public static String getUniqueNameInComposition(EditDomain domain, String name) {
        return NameInCompositionPropertyDescriptor.getUniqueNameInComposition(domain, name, null);
    }

    public static String getUniqueNameInComposition(EditDomain domain, String name, Set otherNames) {
        String baseName = null;
        baseName = name != null ? name : CDEMessages.getString("PropertyDescriptor.NameInComposition.Default");
        String componentName = baseName;
        int incr = 0;
        block0: while (true) {
            if (otherNames != null && otherNames.contains(componentName)) {
                componentName = String.valueOf(baseName) + ++incr;
                continue;
            }
            Iterator itr = domain.getDiagramData().getAnnotations().iterator();
            while (itr.hasNext()) {
                Annotation an = (Annotation)itr.next();
                BasicEMap.Entry ks = AbstractAnnotationPropertyDescriptor.getMapEntry(an, NAME_IN_COMPOSITION_KEY);
                if (ks == null || !componentName.equals(ks.getValue())) continue;
                componentName = String.valueOf(baseName) + ++incr;
                continue block0;
            }
            break;
        }
        return componentName;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (!this.isReadOnly()) {
            StringCellEditor editor = new StringCellEditor(parent);
            ICellEditorValidator v = this.getValidator();
            if (v != null) {
                editor.setValidator(v);
            }
            return editor;
        }
        return null;
    }

    private static class NameValidator
    implements ICellEditorValidator,
    INeedData,
    ISourced {
        protected EditDomain domain;
        protected IPropertySource[] pos;
        protected IPropertyDescriptor[] des;

        NameValidator() {
        }

        public void setData(Object data) {
            this.domain = (EditDomain)((Object)data);
        }

        public String isValid(Object value) {
            if (value == null) {
                return null;
            }
            String name = (String)value;
            if (name.equals(this.getCurrentName())) {
                return null;
            }
            String newName = NameInCompositionPropertyDescriptor.getUniqueNameInComposition(this.domain, name);
            if (newName.equals(name)) {
                return null;
            }
            return CDEMessages.getString("PropertyDescriptor.NameInComposition.NonUnique_INFO_");
        }

        private String getCurrentName() {
            if (this.des[0] instanceof ISourcedPropertyDescriptor) {
                return (String)((ISourcedPropertyDescriptor)this.des[0]).getValue(this.pos[0]);
            }
            return (String)this.pos[0].getPropertyValue((Object)this.des[0]);
        }

        public void setSources(Object[] sources, IPropertySource[] pos, IPropertyDescriptor[] des) {
            this.pos = pos;
            this.des = des;
        }
    }
}

