package org.eclipse.ve.internal.java.codegen.util;
/*******************************************************************************
 * Copyright (c) 2001, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 *  $RCSfile: ExpressionTemplate.java,v $
 *  $Revision: 1.1 $  $Date: 2003/10/27 17:48:30 $ 
 */

import org.eclipse.core.runtime.Preferences;

import org.eclipse.ve.internal.java.vce.VCEPreferences;




public class ExpressionTemplate {
	
	
final public static String SEMICOL =   ";" ; //$NON-NLS-1$
public static final String LPAREN =    "(" ; //$NON-NLS-1$
public static final String RPAREN =    ")" ; //$NON-NLS-1$
public static final String COMMA  =    "," ; //$NON-NLS-1$
public static final String SPACE  =    " " ; //$NON-NLS-1$
public static final String COMMENT  =  "  //" ; //$NON-NLS-1$
public static final String COMMENT_GENERATED  =  "  // Generated" ; //$NON-NLS-1$
public static final String DOT      =  "." ; //$NON-NLS-1$
public static final String EQL      =  "=" ; //$NON-NLS-1$
public static final int    DEFAULT_INDENT = 5 ;


	
	
	String fComments [] ;
	String fSelector ;
	String fMethod ;
	String fArguments[] ;
	int    fIndent=DEFAULT_INDENT ;
	String fLineSeperator = System.getProperty("line.separator") ; //$NON-NLS-1$
	boolean fisMethod = true ;
    boolean fGenerateComments = false ;


public ExpressionTemplate (String sel, String method, String[]args, String[] comments,int indent) {
	fComments = comments;
	fSelector = sel ;
	fArguments = args ;
	fIndent = indent ;
	fMethod = method ;
    Preferences store = VCEPreferences.getPlugin().getPluginPreferences();
    if (store.getBoolean(VCEPreferences.GENERATE_COMMENT))
       fGenerateComments=true ;
    else
       fGenerateComments=false ;
}

	
public void setComments(String[] c) {  fComments = c; }	
public void setComment(String c) { fComments = new String[] {c}; }
public void setSelector(String s) { fSelector = s ; }
public void setArguments(String [] args) { fArguments = args ; }
public void setAnArg(String arg) { fArguments = new String[] {arg} ; }
public void setMethod(String m) { fMethod = m ; }
public void setIndent(int i) { fIndent = i; } ;
public void setFieldAccess(boolean flag) { fisMethod = !flag ; } 


public void setLineSeperator(String sep) {
	fLineSeperator = sep ;
}
	
public String toString () {
	
	
	StringBuffer st = new StringBuffer() ;	
	if (fSelector != null)  {	
	  st.append(getExpression()) ;		
        st.append(SEMICOL) ;
	}
	else
	  for (int i=0; i<fIndent; i++)
	     st.append(SPACE) ;	
      if (fComments != null) {
    	  st.append(COMMENT+SPACE) ;
    	  // TODO  Deal with multi line comments
    	  st.append (fComments[0]) ;
      }
      else if (fGenerateComments)
          st.append(COMMENT_GENERATED) ;
      st.append(fLineSeperator) ;
      return st.toString() ;	
}

public String getExpression() {

    if (fSelector == null) return "?????" ; //$NON-NLS-1$
    StringBuffer st = new StringBuffer() ;	
	
    for (int i=0; i<fIndent; i++)
	    st.append(SPACE) ;	
    st.append(fSelector) ;
    st.append(DOT+fMethod) ;
    if (fisMethod) {   // regular setter method
      st.append(LPAREN) ;
      if (fArguments != null)
      for (int i=0; i<fArguments.length; i++) {
	     if (i>0) st.append(COMMA+" ") ; //$NON-NLS-1$
	     st.append(fArguments[i]) ;
      }
      st.append(RPAREN) ;
    }
    else  { // public field access
      st.append(SPACE+EQL+SPACE) ;
      st.append(fArguments[0]) ;        
    }
    return (st.toString()) ;   	
}

/**
 *  This assumes that Statement was generated by this template.
 */
public static String getExpressionWithFiller(String stmt) {
    
      int right = stmt.lastIndexOf(';') ; //$NON-NLS-1$
      // make sure the ';' is not part of a string expression.
      if (right>0 && stmt.substring(right).indexOf('"')<0 && stmt.substring(right).indexOf('\'')<0) {
         while (stmt.charAt(--right) == ' ' && right > 0) ;
         return stmt.substring(0,right+1) ;
      }      
	  return (stmt) ;	 
}

public static String getExpression(String stmt) {
	String s = getExpressionWithFiller(stmt) ;
	
	int i = 0 ;
	for (;i<s.length();i++) {
		if (!Character.isWhitespace(s.charAt(i)))
		  break ;
	}
	return s.substring(i) ;
}



}