package org.eclipse.ve.internal.jfc.core;
/*******************************************************************************
 * Copyright (c) 2001, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 *  $RCSfile: GridBagLayoutPolicyFactory.java,v $
 *  $Revision: 1.1 $  $Date: 2003/10/27 18:29:32 $ 
 */

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

import org.eclipse.jem.internal.java.JavaHelpers;

import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.GridBagConstraintsJavaClassLabelProvider;

public class GridBagLayoutPolicyFactory implements ILayoutPolicyFactory {
	public GridBagLayoutPolicyFactory() {
		super();
	}
	public Class getLayoutInputPolicyClass() {
		return GridBagLayoutEditPolicy.class;
	}
	public ILayoutPolicyHelper getLayoutPolicyHelper(ContainerPolicy ep) {
		return new GridBagLayoutPolicyHelper(ep);
	}
	public ILayoutSwitcher getLayoutSwitcher(ContainerPolicy ep) {
		return new GridBagLayoutSwitcher(ep);
	}

	public IPropertyDescriptor getConstraintPropertyDescriptor(EStructuralFeature sfConstraint) {
		return new AbstractConstraintPropertyDescriptor(sfConstraint) {
			public ILabelProvider getLabelProvider() {
				return new GridBagConstraintsJavaClassLabelProvider();
			}
		};
	}

	/**
	 * @see ILayoutPolicyFactory#getLayoutManagerInstance(EditDomain)
	 */
	public IJavaInstance getLayoutManagerInstance(JavaHelpers javaClass, ResourceSet rset) {
		return BeanUtilities.createJavaObject(javaClass, rset, null);
	}

}