package com.ibm.calendar;

/**************************************************************************
 * File: DayPlugin.java
 * Version 1.0
 *
 *  Date               Author                  Changes
 *  Apr. 15,2000       Khalid Osbeh            Created
 *
 *
 * Copyright (c) 2000 , IBM Corporation
 * All Rights Reserved
 ***************************************************************************/
/**
 *  Divides a day into several pieces of time and allows the selection of 
 *  one or more time intervals.
 *  @see java.util.Vector;
 */
public class DayPlugin extends java.awt.Panel implements Plugin, java.awt.event.ActionListener, java.awt.event.KeyListener, java.awt.event.MouseListener, java.io.Serializable
{
	/**
	 * holds a description of dayPlugin bean.
	 */
	private String fieldAboutThisBean = new String();
	/**
	 * holds the time selected from list whene UpdateButton is pressed.
	 */
	private String fieldResultSelectedIntervalAsString = new String();
	/**
	 * holds the time interval that is selected in Design Time.
	 */
	private String fieldInitialTimeInterval = new String();
	/**
	 * holds an value of the start time that is selected.
	 */
	private String fieldResultSelectedStartTime = new String();
	/**
	 * holds an value of the end time that is selected.
	 */
	private String fieldResultSelectedEndTime = new String();
	/**
	 * it's an temprory storage to store partitioned time on it.
	 */
	private String[] IntervalInArray;
	/**
	 * holds the selected date.
	 */
	private String fieldSelectedDate = (new java.util.Date()).toString();
	private java.awt.Button ivjCancelButton = null;
	private java.awt.Button ivjUpdateButton = null;
	/**
	 * used for date processing.
	 */
	private java.util.Calendar aCalendar = null;
	/**
	 * holds an image.
	 */
	private java.awt.Image inputImage = null;
	private int firstLog = 0;
	/**
	 * holds all partitioned time.
	 */
	private java.util.Vector fieldAllNoteItems = new java.util.Vector();
	/**
	 * holds a value that the initialTimeInterval will be partioned according to this.
	 */
	private long fieldTimeStep = 0;
	/**
	 * represents if you will the 24 system if TimeFormat24h set to true or not.
	 */
	private boolean timeFormat24h = false;
	private java.awt.List ivjList1 = null;
	private boolean selection = false;
	protected transient java.beans.PropertyChangeSupport propertyChange;
	protected transient java.util.Vector aInvalidPropertyValueListener = null;
	protected transient java.util.Vector aActionCanceledEventListener = null;
	protected transient java.util.Vector aActionPerformedEventListener = null;
/**
 * Constructor
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public DayPlugin()
{
	super();
	initialize();
	setInitialTimeInterval("9:00-18:00");
	setTimeStep(1);
	
}
/**
 * NotePlugin constructor comment.
 * @param layout java.awt.LayoutManager
 */
public DayPlugin(java.awt.LayoutManager layout)
{
	super(layout);
}
/**
 * Method to handle events for the ActionListener interface.
 * @param e java.awt.event.ActionEvent
 *
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void actionPerformed(java.awt.event.ActionEvent e)
{
	// user code begin {1}
	// user code end
	if ((e.getSource() == getCancelButton()))
	{
		connEtoC1();
	}
	if ((e.getSource() == getUpdateButton()))
	{
		connEtoC2(e);
	}
	// user code begin {2}
	// user code end
}
/**
 * Adds an ActionCanceledEventListener to the listener list.
 * @param newListener  The ActionCanceledEventListener to be added
 * @see   com.ibm.calendar.events.ActionCanceledEventListener
 * @see   com.ibm.calendar.DayPlugin#removeActionCanceledEventListener
 **/
public void addActionCanceledEventListener(com.ibm.calendar.events.ActionCanceledEventListener newListener)
{
	if (aActionCanceledEventListener == null)
	{
		aActionCanceledEventListener = new java.util.Vector();
	};
	aActionCanceledEventListener.addElement(newListener);
}
/**
 * Adds an ActionPerformedEventListener to the listener list.
 * @param newListener  The ActionPerformedEventListener to be added
 * @see   com.ibm.calendar.events.ActionPerformedEventListener
 * @see   com.ibm.calendar.DayPlugin#removeActionPerformedEventListener
 **/
public void addActionPerformedEventListener(com.ibm.calendar.events.ActionPerformedEventListener newListener)
{
	if (aActionPerformedEventListener == null)
	{
		aActionPerformedEventListener = new java.util.Vector();
	};
	aActionPerformedEventListener.addElement(newListener);
}
/**
 * Adds an InvalidPropertyValueListener to the listener list.
 * @param newListener  The InvalidPropertyValueListener to be added
 * @see   com.ibm.calendar.events.InvalidPropertyValueListener
 * @see   com.ibm.calendar.DayPlugin#removeInvalidPropertyValueListener
 **/
public void addInvalidPropertyValueListener(com.ibm.calendar.events.InvalidPropertyValueListener newListener)
{
	if (aInvalidPropertyValueListener == null)
	{
		aInvalidPropertyValueListener = new java.util.Vector();
	};
	aInvalidPropertyValueListener.addElement(newListener);
}
/**
 * Adds an PropertyChangeListener to the listener list.
 * @param listener  The PropertyChangeListener to be added
 * @see   com.ibm.calendar.events.PropertyChangeListener
 * @see   com.ibm.calendar.DayPlugin#removePropertyChangeListener
 **/
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener)
{
	getPropertyChange().addPropertyChangeListener(listener);
}
/**
 * To Hide the DayPlugin
 */
public void cancelButton_ActionEvents()
{
	setVisible(false);
	fireOnActionCanceledEvent(new com.ibm.calendar.events.ActionCanceledEvent(this));
	return;
}
/**
 * connEtoC1:  (CancelButton.action. --> NotePlugin.cancelButton_ActionEvents()V)
 *
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC1()
{
	try
	{
		// user code begin {1}
		// user code end
		this.cancelButton_ActionEvents();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc)
	{
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC2:  (UpdateButton.action.actionPerformed(java.awt.event.ActionEvent) --> NotePlugin.updateButton_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
 * @param arg1 java.awt.event.ActionEvent
 *
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC2(java.awt.event.ActionEvent arg1)
{
	try
	{
		// user code begin {1}
		// user code end
		this.updateButton_ActionPerformed(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc)
	{
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC5:  (List1.mouse.mouseReleased(java.awt.event.MouseEvent) --> DayPlugin.list1_MouseReleased(Ljava.awt.event.MouseEvent;)V)
 * @param arg1 java.awt.event.MouseEvent
 *
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC5(java.awt.event.MouseEvent arg1)
{
	try
	{
		// user code begin {1}
		// user code end
		this.list1_MouseReleased(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc)
	{
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC6:  (List1.key.keyReleased(java.awt.event.KeyEvent) --> DayPlugin.list1_KeyReleased(Ljava.awt.event.KeyEvent;)V)
 * @param arg1 java.awt.event.KeyEvent
 *
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC6(java.awt.event.KeyEvent arg1)
{
	try
	{
		// user code begin {1}
		// user code end
		this.list1_KeyReleased(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc)
	{
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * The doOperation method determines the interval that the user was selected
 * and store in fieldResultSelectedIntervalAsString property.
 */
private void doOperation()
{
	String firstTmp = "", seconedTmp = "", seconedTmp1 = "";
	int i;
	IntervalInArray = ivjList1.getSelectedItems();
	if (IntervalInArray.length != 0)
	{
		firstTmp = IntervalInArray[0];
		for (i = 0;; i++)
		{
			if (firstTmp.charAt(i) == '-')
			{
				break;
			}
			seconedTmp += firstTmp.charAt(i);
		}
		fieldResultSelectedStartTime = seconedTmp;
		firePropertyChange("resultSelectedStartTime", "", fieldResultSelectedStartTime);
		firstTmp = IntervalInArray[IntervalInArray.length - 1];
		for (i = 0;;)
		{
			if (firstTmp.charAt(i) == '-')
			{
				i++;
				break;
			} else
			{
				i++;
			}
		}
		for (int j = i; j < firstTmp.length(); j++)
		{
			seconedTmp1 += firstTmp.charAt(j);
		}
		fieldResultSelectedEndTime = seconedTmp1;
		firePropertyChange("resultSelectedEndTime", "", fieldResultSelectedEndTime);
		fieldResultSelectedIntervalAsString = fieldResultSelectedStartTime + "-" + fieldResultSelectedEndTime;
		firePropertyChange("resultSelectedIntervalAsString", "", fieldResultSelectedIntervalAsString);
	}else
	{
		fieldResultSelectedStartTime = "";
		firePropertyChange("resultSelectedStartTime", " ", fieldResultSelectedStartTime);
		fieldResultSelectedEndTime = "";
		firePropertyChange("resultSelectedEndTime", " ", fieldResultSelectedEndTime);
		fieldResultSelectedIntervalAsString = "";
		firePropertyChange("resultSelectedIntervalAsString", " ", fieldResultSelectedIntervalAsString);
		}
}
/**
 * Method to support listener events.
 * @param e com.ibm.calendar.events.ActionCanceledEvent
 */
protected void fireOnActionCanceledEvent(com.ibm.calendar.events.ActionCanceledEvent e)
{
	if (aActionCanceledEventListener == null)
	{
		return;
	};
	int currentSize = aActionCanceledEventListener.size();
	com.ibm.calendar.events.ActionCanceledEventListener tempListener = null;
	for (int index = 0; index < currentSize; index++)
	{
		tempListener = (com.ibm.calendar.events.ActionCanceledEventListener) aActionCanceledEventListener.elementAt(index);
		if (tempListener != null)
		{
			tempListener.onActionCanceledEvent(e);
		};
	};
}
/**
 * Method to support listener events.
 * @param e com.ibm.calendar.events.ActionPerformedEvent
 */
protected void fireOnActionPerformedEvent(com.ibm.calendar.events.ActionPerformedEvent e)
{
	if (aActionPerformedEventListener == null)
	{
		return;
	};
	int currentSize = aActionPerformedEventListener.size();
	com.ibm.calendar.events.ActionPerformedEventListener tempListener = null;
	for (int index = 0; index < currentSize; index++)
	{
		tempListener = (com.ibm.calendar.events.ActionPerformedEventListener) aActionPerformedEventListener.elementAt(index);
		if (tempListener != null)
		{
			tempListener.onActionPerformedEvent(e);
		};
	};
}
/**
 * Method to support listener events.
 * @param e com.ibm.calendar.events.InvalidPropertyValue
 */
protected void fireOnInvalidPropertyValue(com.ibm.calendar.events.InvalidPropertyValue e)
{
	if (aInvalidPropertyValueListener == null)
	{
		return;
	};
	int currentSize = aInvalidPropertyValueListener.size();
	com.ibm.calendar.events.InvalidPropertyValueListener tempListener = null;
	for (int index = 0; index < currentSize; index++)
	{
		tempListener = (com.ibm.calendar.events.InvalidPropertyValueListener) aInvalidPropertyValueListener.elementAt(index);
		if (tempListener != null)
		{
			tempListener.onInvalidPropertyValue(e);
		};
	};
}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 * @param propertyName String
 * @param oldValue Object
 * @param newValue Object
 */
public void firePropertyChange(String propertyName, Object oldValue, Object newValue)
{
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}
/**
 * Gets the aboutThisBean property (java.lang.String) value.
 * @return The aboutThisBean property value.
 * @see #setAboutThisBean
 */
public String getAboutThisBean()
{
	return (getClass().getName() + "^DayPlugin^2.0^docs/index.html");
}
/**
 * Return the Button2 property value.
 * @return java.awt.Button
 * 
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Button getCancelButton()
{
	if (ivjCancelButton == null)
	{
		try
		{
			ivjCancelButton = new java.awt.Button();
			ivjCancelButton.setName("CancelButton");
			ivjCancelButton.setBounds(92, 165, 56, 23);
			ivjCancelButton.setLabel("Cancel");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc)
		{
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjCancelButton;
}
/**
 * Gets the initialTimeInterval property (java.lang.String) value.
 * @return The initialTimeInterval property value.
 * @see #setInitialTimeInterval
 */
public String getInitialTimeInterval()
{
	return fieldInitialTimeInterval;
}
/**
 * Return the List1 property value.
 * @return java.awt.List
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.List getList1()
{
	if (ivjList1 == null)
	{
		try
		{
			ivjList1 = new java.awt.List();
			ivjList1.setName("List1");
			ivjList1.setFont(new java.awt.Font("dialog", 0, 14));
			ivjList1.setBounds(20, 31, 140, 131);
			ivjList1.setMultipleMode(true);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc)
		{
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjList1;
}
/**
 * Accessor for the propertyChange field.
 */
protected java.beans.PropertyChangeSupport getPropertyChange()
{
	if (propertyChange == null)
	{
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}
/**
 * Gets the resultSelectedEndTime property (java.lang.String) value.
 * @return The resultSelectedEndTime property value.
 */
public String getResultSelectedEndTime()
{
	return fieldResultSelectedEndTime;
}
/**
 * Gets the resultSelectedIntervalAsString property (java.lang.String) value.
 * @return The resultSelectedIntervalAsString property value.
 */
public String getResultSelectedIntervalAsString()
{
	return fieldResultSelectedIntervalAsString;
}
/**
 * Gets the resultSelectedSatrtTime property (java.lang.String) value.
 * @return The resultSelectedSatrtTime property value.
 */
public String getResultSelectedStartTime()
{
	return fieldResultSelectedStartTime;
}
/**
 * getStartEndTime method gets the start and end time from the initial date string . 
 * @param SH int represent the start hour.
 * @param SM int represent the start minute.
 * @param EH int represent the end hour.
 * @param EM int represent the end minute.
 * @param stage int to define each part of time into four stages like(0:SH,1:SM, 2:EH, EM:3).
 */
private void getStartEndTime(int SH, int SM, int EH, int EM, int stage)
{
	int i = 0;
	String tempStr = "0";
	for (;;)
	{
		switch (stage)
		{
			case 0 :
				if (getInitialTimeInterval().charAt(i) >= '0' && getInitialTimeInterval().charAt(i) <= '9')
				{
					tempStr += getInitialTimeInterval().charAt(i);
				} else
				{
					stage++;
					SH = Integer.parseInt(tempStr);
					tempStr = "0";
				}
				i++;
				continue;
			case 1 :
				if (getInitialTimeInterval().charAt(i) >= '0' && getInitialTimeInterval().charAt(i) <= '9')
				{
					tempStr += getInitialTimeInterval().charAt(i);
				} else
				{
					stage++;
					SM = Integer.parseInt(tempStr);
					tempStr = "0";
				}
				i++;
				continue;
			case 2 :
				if (getInitialTimeInterval().charAt(i) >= '0' && getInitialTimeInterval().charAt(i) <= '9')
				{
					tempStr += getInitialTimeInterval().charAt(i);
				} else
				{
					stage++;
					EH = Integer.parseInt(tempStr);
					tempStr = "0";
				}
				i++;
				continue;
			case 3 :
				if (getInitialTimeInterval().charAt(i) >= '0' && getInitialTimeInterval().charAt(i) <= '9')
				{
					tempStr += getInitialTimeInterval().charAt(i);
				} else
				{
					stage++;
					EM = Integer.parseInt(tempStr);
					tempStr = "0";
				}
				i++;
				continue;
		}
	}
}
/**
 * Gets the timeFormat24h property (boolean) value.
 * @return The timeFormat24h property value.
 * @see #setTimeFormat24h
 */
public boolean getTimeFormat24h()
{
	return timeFormat24h;
}
/**
 * Gets the timeStep property (long) value.
 * @return The timeStep property value.
 * @see #setTimeStep
 */
public long getTimeStep()
{
	return fieldTimeStep;
}
/**
 * Return the Button1 property value.
 * @return java.awt.Button
 *
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Button getUpdateButton()
{
	if (ivjUpdateButton == null)
	{
		try
		{
			ivjUpdateButton = new java.awt.Button();
			ivjUpdateButton.setName("UpdateButton");
			ivjUpdateButton.setBounds(26, 166, 56, 23);
			ivjUpdateButton.setLabel("Ok");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc)
		{
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjUpdateButton;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception)
{

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	// System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	// exception.printStackTrace(System.out);
}
/**
 * Initializes connections
 * 
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections()
{
	// user code begin {1}
	// user code end
	getCancelButton().addActionListener(this);
	getUpdateButton().addActionListener(this);
	getList1().addMouseListener(this);
	getList1().addKeyListener(this);
}
/**
 * Initialize the class.
 *	
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize()
{
	// user code begin {1}
	// user code end
	setName("NotePlugin");
	setLayout(null);
	setSize(182, 198);
	add(getUpdateButton(), getUpdateButton().getName());
	add(getCancelButton(), getCancelButton().getName());
	add(getList1(), getList1().getName());
	initConnections();
	// user code begin {2}
	// user code end
}
/**
 * This method was created to divide intialTimeInterval into time intervals
 * according to timeStep and the Format that uses is 24 hours system.
 */
private void initList()
{
	ivjList1.removeAll();
	if (fieldTimeStep > 60)
	{
		fieldTimeStep = 60;
		setTimeStep(60);
	}
	int i = 0;
	long startHour = 0, totalMin = 0, currentTotalMin = 0, startMin = 0, endHour = 0, endMin = 0;
	long calcHour = 0, calcMin = 0;
	int stage = 0;
	String startTime;
	String endTime;
	String tempStr, initTime = getInitialTimeInterval();
	tempStr = "0";
	stage = 0;
	/**
	 * This for loop was created to convert and catagorize the initialTimeInterval 
	 * into four variables. How, startHour,startMinute, endHour, and endMinute. And 
	 * finally concatenate this to tempStr
	 * as String Type in four Stages steps .
	 */
	for (;;)
	{
		switch (stage)
		{
			case 0 :
				if (getInitialTimeInterval().charAt(i) >= '0' && getInitialTimeInterval().charAt(i) <= '9')
				{
					tempStr += getInitialTimeInterval().charAt(i);
				} else
				{
					stage++;
					startHour = Integer.parseInt(tempStr);
					tempStr = "0";
				}
				i++;
				break;
			case 1 :
				if (getInitialTimeInterval().charAt(i) >= '0' && getInitialTimeInterval().charAt(i) <= '9')
				{
					tempStr += getInitialTimeInterval().charAt(i);
				} else
				{
					stage++;
					startMin = Integer.parseInt(tempStr);
					tempStr = "0";
				}
				i++;
				break;
			case 2 :
				if (getInitialTimeInterval().charAt(i) >= '0' && getInitialTimeInterval().charAt(i) <= '9')
				{
					tempStr += getInitialTimeInterval().charAt(i);
				} else
				{
					stage++;
					endHour = Integer.parseInt(tempStr);
					tempStr = "0";
				}
				i++;
				break;
			case 3 :
				if (getInitialTimeInterval().charAt(i) >= '0' && getInitialTimeInterval().charAt(i) <= '9')
				{
					tempStr += getInitialTimeInterval().charAt(i);
				} else
				{
					stage++;
					tempStr = "0";
					endMin = Integer.parseInt(tempStr);
				}
				i++;
				break;
			default :
				break;
		}
		if (stage >= 4 || i >= getInitialTimeInterval().length())
		{
			endMin = Integer.parseInt(tempStr);
			break;
		}
	}
	if (startMin >= 0 && startMin <= 9)
	{
		tempStr = "" + startHour + ":0" + startMin + "-";
	} else
	{
		tempStr = "" + startHour + ":" + startMin + "-";
	}
	if ((startHour < 0 || startHour > 24) || (endHour < 0 || endHour > 24))
	{
		ivjList1.add("error time ");
	} else
	{

		/**
		 *  Calculate The Diff. between the startInterval and endInterval
		 */

		if (endHour < startHour)
		{
			calcHour = (24 - (startHour + 1)) + endHour;
			calcHour = calcHour * 60; // Convert to Min.

			calcMin = calcHour + (60 - startMin) + endMin;
			totalMin = calcMin;
		} else
		{
			calcHour = endHour - (startHour + 1);
			if (calcHour < 0)
			{
				totalMin = endMin - startMin;
			} else
			{
				calcHour = calcHour * 60; // Convert to Min.

				calcMin = calcHour + (60 - startMin) + endMin;
				totalMin = calcMin;
			}
		}

		/**
		 * This for loop was created to fill list by interval that be divided
		 */
		for (;;)
		{
			startMin = startMin + fieldTimeStep;
			if (startMin <= 59)
			{
				if (endHour == startHour && startMin > endMin)
				{
					if (endMin >= 0 && endMin <= 9)
					{
						tempStr += "" + startHour + ":0" + endMin;
					} else
					{
						tempStr += "" + startHour + ":" + endMin;
					}
					ivjList1.add(tempStr);
					break;
				}
				if (startMin >= 0 && startMin <= 9)
				{
					tempStr += "" + startHour + ":0" + startMin;
				} else
				{
					tempStr += "" + startHour + ":" + startMin;
				}
				ivjList1.add(tempStr);
				if (startMin >= 0 && startMin <= 9)
				{
					tempStr = "" + startHour + ":0" + startMin + "-";
				} else
				{
					tempStr = "" + startHour + ":" + startMin + "-";
				}
				currentTotalMin = currentTotalMin + fieldTimeStep;
			} else
			{
				if (endHour == startHour && startMin > endMin)
				{
					if (endMin >= 0 && endMin <= 9)
					{
						tempStr += "" + startHour + ":0" + endMin;
					} else
					{
						tempStr += "" + startHour + ":" + endMin;
					}
					ivjList1.add(tempStr);
					break;
				}
				startMin -= 60;
				startHour += 1L;
				if (startHour >= 24)
				{
					startHour = 0;
				}
				if (endHour == startHour && startMin > endMin)
				{
					if (endMin >= 0 && endMin <= 9)
					{
						tempStr += "" + startHour + ":" + endMin;
					} else
					{
						tempStr += "" + startHour + ":" + endMin;
					}
					ivjList1.add(tempStr);
					break;
				} else
				{
					if (startMin >= 0 && startMin <= 9)
					{
						tempStr += "" + startHour + ":0" + startMin;
					} else
					{
						tempStr += "" + startHour + ":" + startMin;
					}
					ivjList1.add(tempStr);
					if (startMin >= 0 && startMin <= 9)
					{
						tempStr = "" + startHour + ":0" + startMin + "-";
					} else
					{
						tempStr = "" + startHour + ":" + startMin + "-";
					}
					currentTotalMin = currentTotalMin + fieldTimeStep;
				}
			}
			if (currentTotalMin >= totalMin)
				break;
		}
	}
}
/**
 * This method was created to divide intialTimeInterval into time intervals
 * according to timeStep and the Format that uses is 12 hours system.
 */
private void initList1()
{
	ivjList1.removeAll();
	if (fieldTimeStep <= 60)
	{
		int i = 0;
		long startHour = 0, totalMin = 0, currentTotalMin = 0, startMin = 0, endHour = 0, endMin = 0;
		long calcHour = 0, calcMin = 0;
		int stage = 0;
		String startTime;
		String endTime;
		String tempStr, initTime = getInitialTimeInterval();
		tempStr = "0";
		stage = 0;
		/**
		 * This for loop was created to convert and catagorize the initialTimeInterval 
		 * into four variables. How, startHour,startMinute, endHour, and endMinute. And 
		 * finally concatenate this to tempStr
		 * as String Type in four Stages steps .
		 */
		for (;;)
		{
			switch (stage)
			{
				case 0 :
					if (getInitialTimeInterval().charAt(i) >= '0' && getInitialTimeInterval().charAt(i) <= '9')
					{
						tempStr += getInitialTimeInterval().charAt(i);
					} else
					{
						stage++;
						startHour = Integer.parseInt(tempStr);
						if (startHour > 12)
							startHour = startHour - 12;
						else
							if (startHour == 0)
								startHour = 12;
						tempStr = "0";
					}
					i++;
					break;
				case 1 :
					if (getInitialTimeInterval().charAt(i) >= '0' && getInitialTimeInterval().charAt(i) <= '9')
					{
						tempStr += getInitialTimeInterval().charAt(i);
					} else
					{
						stage++;
						startMin = Integer.parseInt(tempStr);
						tempStr = "0";
					}
					i++;
					break;
				case 2 :
					if (getInitialTimeInterval().charAt(i) >= '0' && getInitialTimeInterval().charAt(i) <= '9')
					{
						tempStr += getInitialTimeInterval().charAt(i);
					} else
					{
						stage++;
						endHour = Integer.parseInt(tempStr);
						if (endHour > 12)
							endHour = endHour - 12;
						else
							if (endHour == 0)
								endHour = 12;
						tempStr = "0";
					}
					i++;
					break;
				case 3 :
					if (getInitialTimeInterval().charAt(i) >= '0' && getInitialTimeInterval().charAt(i) <= '9')
					{
						tempStr += getInitialTimeInterval().charAt(i);
					} else
					{
						stage++;
						tempStr = "0";
						endMin = Integer.parseInt(tempStr);
					}
					i++;
					break;
				default :
					break;
			}
			if (stage >= 4 || i >= getInitialTimeInterval().length())
			{
				endMin = Integer.parseInt(tempStr);
				break;
			}
		}
		if (startMin >= 0 && startMin <= 9)
		{
			tempStr = "" + startHour + ":0" + startMin + "-";
		} else
		{
			tempStr = "" + startHour + ":" + startMin + "-";
		}
		if ((startHour < 0 || startHour > 12) || (endHour < 0 || endHour > 12))
		{
			ivjList1.add("error time ");
		} else
		{

			/**
			 *  Calculate The Diff. between the startInterval and endInterval
			 */

			if (endHour < startHour)
			{
				calcHour = (12 - (startHour + 1)) + endHour;
				calcHour = calcHour * 60; // Convert to Min.

				calcMin = calcHour + (60 - startMin) + endMin;
				totalMin = calcMin;
			} else
			{
				calcHour = endHour - (startHour + 1);
				if (calcHour < 0)
				{
					totalMin = endMin - startMin;
				} else
				{
					calcHour = calcHour * 60; // Convert to Min.

					calcMin = calcHour + (60 - startMin) + endMin;
					totalMin = calcMin;
				}
			}
			/**
			 * This for loop was created to fill list by interval that be divided
			 */

			for (;;)
			{
				startMin = startMin + fieldTimeStep;
				if (startMin <= 59)
				{
					if (endHour == startHour && startMin > endMin)
					{
						if (startMin >= 0 && startMin <= 9)
						{
							tempStr += "" + startHour + ":0" + endMin;
						} else
						{
							tempStr += "" + startHour + ":" + endMin;
						}
						ivjList1.add(tempStr);
						break;
					}
					if (startMin >= 0 && startMin <= 9)
					{
						tempStr += "" + startHour + ":0" + startMin;
					} else
					{
						tempStr += "" + startHour + ":" + startMin;
					}
					ivjList1.add(tempStr);
					if (startMin >= 0 && startMin <= 9)
					{
						tempStr = "" + startHour + ":0" + startMin + "-";
					} else
					{
						tempStr = "" + startHour + ":" + startMin + "-";
					}
					currentTotalMin = currentTotalMin + fieldTimeStep;
				} else
				{
					if (endHour == startHour && startMin > endMin)
					{
						if (startMin >= 0 && startMin <= 9)
						{
							tempStr += "" + startHour + "0:" + endMin;
						} else
						{
							tempStr += "" + startHour + ":" + endMin;
						}
						ivjList1.add(tempStr);
						break;
					}
					startMin -= 60;
					startHour += 1L;
					if (startHour > 12)
					{
						startHour = 1;
					}
					if (endHour == startHour && startMin > endMin)
					{
						if (startMin >= 0 && startMin <= 9)
						{
							tempStr += "" + startHour + ":0" + endMin;
						} else
						{
							tempStr += "" + startHour + ":" + endMin;
						}
						ivjList1.add(tempStr);
						break;
					} else
					{
						if (startMin >= 0 && startMin <= 9)
						{
							tempStr += "" + startHour + ":0" + startMin;
						} else
						{
							tempStr += "" + startHour + ":" + startMin;
						}
						ivjList1.add(tempStr);
						if (startMin >= 0 && startMin <= 9)
						{
							tempStr = "" + startHour + ":0" + startMin + "-";
						} else
						{
							tempStr = "" + startHour + ":" + startMin + "-";
						}
						currentTotalMin = currentTotalMin + fieldTimeStep;
					}
				}
				if (currentTotalMin >= totalMin)
					break;
			}
		}
	} else
	{
		ivjList1.add("TimeStep should be");
		ivjList1.add(" less than 60 minutes ");
	}
}
/**
 * used to initialize the init List in the DayPlugin
 */
public void initPlugin()
{
	if (!fieldInitialTimeInterval.equalsIgnoreCase(""))
	{
		selection = false;
		this.setVisible(true);
		if (timeFormat24h)
			initList();
		else
			initList1();
	} else
	{
		fireOnInvalidPropertyValue(new com.ibm.calendar.events.InvalidPropertyValue(this));
	}
}
/**
 * Method to handle events for the KeyListener interface.
 * @param e java.awt.event.KeyEvent
 *
 *
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void keyPressed(java.awt.event.KeyEvent e)
{
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the KeyListener interface.
 * @param e java.awt.event.KeyEvent
 *
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void keyReleased(java.awt.event.KeyEvent e)
{
	// user code begin {1}
	// user code end
	if ((e.getSource() == getList1()))
	{
		connEtoC6(e);
	}
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the KeyListener interface.
 * @param e java.awt.event.KeyEvent
 *
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void keyTyped(java.awt.event.KeyEvent e)
{
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * used to Select specific interval time in the list.
 */
private void list1_KeyReleased(java.awt.event.KeyEvent keyEvent)
{
	int startSelected = -1;
	int endSelected = 0;
	int i = 0;
	if (!selection)
	{
		for (i = 0; i < ivjList1.getItemCount(); i++)
		{
			if (ivjList1.isIndexSelected(i))
			{
				if (startSelected == -1)
				{
					startSelected = i;
				} else
				{
					endSelected = i;
					selection = true;
				}
			}
		}
		if (startSelected != -1)
		{
			for (i = startSelected; i <= endSelected; i++)
			{
				ivjList1.select(i);
			}
		}
	} else
	{
		for (i = 0; i < ivjList1.getItemCount(); i++)
			ivjList1.deselect(i);
		selection = false;
	}
	return;
}
private void list1_MouseClicked(java.awt.event.MouseEvent mouseEvent)
{
}
private void list1_MouseDragged(java.awt.event.MouseEvent mouseEvent) {
}
private void list1_MouseEvents() {
}
/**
 * used to Select specific interval time in the list.
 */
private void list1_MouseReleased(java.awt.event.MouseEvent mouseEvent)
{
	int startSelected = -1;
	int endSelected = 0;
	int i = 0;
	if (!selection)
	{
		for (i = 0; i < ivjList1.getItemCount(); i++)
		{
			if (ivjList1.isIndexSelected(i))
			{
				if (startSelected == -1)
				{
					startSelected = i;
				} else
				{
					endSelected = i;
					selection = true;
				}
			}
		}
		if (startSelected != -1)
		{
			for (i = startSelected; i <= endSelected; i++)
			{
				ivjList1.select(i);
			}
		}
	} else
	{
		for (i = 0; i < ivjList1.getItemCount(); i++)
			ivjList1.deselect(i);
		selection = false;
	}
	return;
}
/**
 * Method to handle events for the MouseListener interface.
 * @param e java.awt.event.MouseEvent
 *
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void mouseClicked(java.awt.event.MouseEvent e)
{
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the MouseListener interface.
 * @param e java.awt.event.MouseEvent
 *
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void mouseEntered(java.awt.event.MouseEvent e)
{
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the MouseListener interface.
 * @param e java.awt.event.MouseEvent
 *
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void mouseExited(java.awt.event.MouseEvent e)
{
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the MouseListener interface.
 * @param e java.awt.event.MouseEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void mousePressed(java.awt.event.MouseEvent e)
{
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the MouseListener interface.
 * @param e java.awt.event.MouseEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void mouseReleased(java.awt.event.MouseEvent e)
{
	// user code begin {1}
	// user code end
	if ((e.getSource() == getList1()))
	{
		connEtoC5(e);
	}
	// user code begin {2}
	// user code end
}
/**
 * paint method is used to draw the dayPlugin.
 * @param g java.awt.Graphics
 */
public void paint(java.awt.Graphics g)
{
	if (inputImage == null)
	{
		g.drawRect(0, 0, 181, 197);
		g.setColor(java.awt.Color.black);
		g.drawString("Please Select Time Interval:", 15, 24);
	} else
	{
		g.drawImage(inputImage, 0, 0, 182, 198, this);
		g.setColor(java.awt.Color.black);
		g.drawString("Please Select Time Interval:", 15, 24);
		g.setColor(java.awt.Color.white);
		g.drawString("Please Select Time Interval:", 15, 24);
		g.setColor(java.awt.Color.black);
	}
}
/**
 * Removes an ActionCanceledEventListener to the listener list.
 * @param newListener  The ActionCanceledEventListener to be removed
 * @see   com.ibm.calendar.events.ActionCanceledEventListener
 * @see   com.ibm.calendar.DayPlugin#addActionCanceledEventListener
 **/
public void removeActionCanceledEventListener(com.ibm.calendar.events.ActionCanceledEventListener newListener)
{
	if (aActionCanceledEventListener != null)
	{
		aActionCanceledEventListener.removeElement(newListener);
	};
}
/**
 * Removes an ActionPerformedEventListener to the listener list.
 * @param newListener  The ActionPerformedEventListener to be removed
 * @see   com.ibm.calendar.events.ActionPerformedEventListener
 * @see   com.ibm.calendar.DayPlugin#addActionPerformedEventListener
 **/
public void removeActionPerformedEventListener(com.ibm.calendar.events.ActionPerformedEventListener newListener)
{
	if (aActionPerformedEventListener != null)
	{
		aActionPerformedEventListener.removeElement(newListener);
	};
}
/**
 * Removes an InvalidPropertyValueListener to the listener list.
 * @param newListener  The InvalidPropertyValueListener to be removed
 * @see   com.ibm.calendar.events.InvalidPropertyValueListener
 * @see   com.ibm.calendar.DayPlugin#addInvalidPropertyValueListener
 **/
public void removeInvalidPropertyValueListener(com.ibm.calendar.events.InvalidPropertyValueListener newListener)
{
	if (aInvalidPropertyValueListener != null)
	{
		aInvalidPropertyValueListener.removeElement(newListener);
	};
}
/**
 * Removes an PropertyChangeListener to the listener list.
 * @param listener  The PropertyChangeListener to be removed
 * @see   com.ibm.calendar.events.PropertyChangeListener
 * @see   com.ibm.calendar.DayPlugin#addPropertyChangeListener
 **/
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener)
{
	getPropertyChange().removePropertyChangeListener(listener);
}
/**
 * Sets the aboutThisBean property (java.lang.String) value.
 * @param aboutThisBean The new value for the property.
 * @see #getAboutThisBean
 */
public void setAboutThisBean(String aboutThisBean)
{
	fieldAboutThisBean = aboutThisBean;
}
/**
 * initialize the plugin data.
 * @param C java.util.Calendar
 * @param i java.awt.Image
 * @param x int
 * @param y int
 */
public void setInfo(java.util.Calendar c, java.awt.Image i, int x, int y)
{
	if (firstLog != 0)
	{
		aCalendar = c;
		inputImage = i;
		this.setLocation(x, y);
	} else
	{
		this.setVisible(false);
		firstLog = 1;
	}
}
/**
 * Sets the initialTimeInterval property (java.lang.String) value.
 * @param initialTimeInterval The new value for the property.
 * @see #getInitialTimeInterval
 */
public void setInitialTimeInterval(String initialTimeInterval)
{
	fieldInitialTimeInterval = initialTimeInterval;
}
/**
 * Sets the timeFormat24h property (boolean) value.
 * @param timeFormat24h The new value for the property.
 * @see #getTimeFormat24h
 */
public void setTimeFormat24h(boolean timeFormat24h)
{
	this.timeFormat24h = timeFormat24h;
}
/**
 * Sets the timeStep property (long) value.
 * @param timeStep The new value for the property.
 * @see #getTimeStep
 */
public void setTimeStep(int timeStep)
{
	if (timeStep > 0 && timeStep < 61)
	{
		fieldTimeStep = timeStep;
	} else
	{
		if (timeStep <= 0)
			fieldTimeStep = 1;
		else
			fieldTimeStep = 60;
}
}
/**
 * Sets the timeStep property (long) value.
 * @param timeStep The new value for the property.
 * @see #getTimeStep
 */
public void setTimeStep(long timeStep)
{
	if (timeStep > 0 && timeStep < 61)
	{
		fieldTimeStep = timeStep;
	} else
	{
		if (timeStep <= 0)
			fieldTimeStep = 1;
		else
			fieldTimeStep = 60;
}
}
/**
 * This method calls doOperation function to set the dayPlugin 
 * resultSelectedIntervalAsString property
 */
public void updateButton_ActionPerformed(java.awt.event.ActionEvent actionEvent)
{
	try
	{
		doOperation();
	} catch (Exception e)
	{
	}
	this.setVisible(false);
	fireOnActionPerformedEvent(new com.ibm.calendar.events.ActionPerformedEvent(this));
	return;
}
}