package com.ibm.calendar;

/**************************************************************************
 * File: GrayTheme.java
 * Version 1.0
 *
 *  Date               Author                  Changes
 *  Apr. 14,2000       Daher Thabit            Created
 *
 * 
 * Copyright (c) 2000 , IBM Corporation
 * All Rights Reserved
 ***************************************************************************/

/**
 * GrayTheme is the class responsible for passing the Image's and
 * coordinates for the calendar, this class holdes all the images for the
 * plugin's too.
 * @see java.awt.Point
 */

import java.awt.Point;
public class GrayTheme implements Theme, java.io.Serializable
{
	/* resources variable holds the images for the theme according to key string */
	private java.util.Hashtable resources;
	private String fieldAboutThisBean = new String();
/**
 * GrayTheme constructor initialize the resources of the theme by loading the images
 *    and determins the startup point of the year and month names controls in the calendar bean.
 */
public GrayTheme()
{
	super();
	resources = new java.util.Hashtable(); // resources variable holdes the images for the theme according to key string
	/* aPanel is used to find the path and loads the images to be stored in the
	 *     HashTable resources
	 */
	java.awt.Panel aPanel = new java.awt.Panel();
	Point aPoint = new Point(); //aPoint is used to hold the x and y coordinates that will be used in the calendar
	aPoint.x = 7;
	aPoint.y = 2;

	Class cl = this.getClass();

	// see PTR 6128 - fixed by Werner Zsolt 18/01/2001
	// The VAJ 3.0 Entry edition, unlike the other editions/plain JDK/all web browsers, doesn't allow objects of any class to access their 
	// ClassLoader - that is, (ClassLoader)this.getClass().getClassLoader() returns null. 
	// This means no app that depends on the ClassLoader (e.g. for uniform loading of pics) will be able to run under the Entry ed.
	// in such a case, we just use the old way of accessing the gif files.

	if (cl==null) // entry ed.
	{
	resources.put("CalendarImage", aPanel.getToolkit().getImage("com/ibm/calendar/theme/GrayTheme.jpg"));
	resources.put("NotePluginImage", aPanel.getToolkit().getImage("com/ibm/calendar/theme/GrayNotePluginTheme.jpg"));
	resources.put("ToDoPluginImage", aPanel.getToolkit().getImage("com/ibm/calendar/theme/GrayToDoPluginTheme.jpg"));
	resources.put("DayPluginImage", aPanel.getToolkit().getImage("com/ibm/calendar/theme/GrayDayPluginTheme.jpg"));
	resources.put("CalendarProp", aPoint);
	return;
	}



	//resources.put("CalendarImage", aPanel.getToolkit().getImage("com/ibm/calendar/theme/GrayTheme.jpg"));
	resources.put("CalendarImage", java.awt.Toolkit.getDefaultToolkit().getImage(cl.getResource("com/ibm/calendar/theme/GrayTheme.jpg")));

	//resources.put("NotePluginImage", aPanel.getToolkit().getImage("com/ibm/calendar/theme/GrayNotePluginTheme.jpg"));
	resources.put("NotePluginImage", java.awt.Toolkit.getDefaultToolkit().getImage(cl.getResource("com/ibm/calendar/theme/GrayNotePluginTheme.jpg")));

	//resources.put("ToDoPluginImage", aPanel.getToolkit().getImage("com/ibm/calendar/theme/GrayToDoPluginTheme.jpg"));
	resources.put("ToDoPluginImage", java.awt.Toolkit.getDefaultToolkit().getImage(cl.getResource("com/ibm/calendar/theme/GrayToDoPluginTheme.jpg")));

	//resources.put("DayPluginImage", aPanel.getToolkit().getImage("com/ibm/calendar/theme/GrayDayPluginTheme.jpg"));
	resources.put("DayPluginImage", java.awt.Toolkit.getDefaultToolkit().getImage(cl.getResource("com/ibm/calendar/theme/GrayDayPluginTheme.jpg")));

	resources.put("CalendarProp", aPoint);


}
/**
 * Gets the aboutThisBean property (java.lang.String) value.
 * @return The aboutThisBean property value.
 * @see #setAboutThisBean
 */
public String getAboutThisBean()
{
	return ("com.ibm.calendar.Theme^GrayTheme^2.0^ThemeWiring.gif^docs/index.html");
}
/**
 * getImage method returns the corresponding image determined by the key string .
 */
public java.awt.Image getImage(String key)
{
	return (java.awt.Image) resources.get(key + "Image");
}
/**
 * getProperty method returns the coordinates of that is usefull for the calendar.
 */
public Object getProperty(String key)
{
	return (Object) resources.get(key + "Prop");
}
/**
 * Sets the aboutThisBean property (java.lang.String) value.
 * @param aboutThisBean The new value for the property.
 * @see #getAboutThisBean
 */
public void setAboutThisBean(String aboutThisBean)
{
	fieldAboutThisBean = aboutThisBean;
}

public boolean equals( Object o ) {
	return o instanceof GrayTheme;
}
}