package com.ibm.calendar;

/**************************************************************************
 * File: NotePlugin.java
 * Version 1.0
 *
 *  Date               Author                  Changes
 *  Apr. 17,2000       khadejeh Baker	       created
 *
 *
 * Copyright (c) 2000 , IBM Corporation
 * All Rights Reserved
 ***************************************************************************/
/**
 * NotePlugin bean that provides the user to add any note that you want with specified date
 * from the calendar with a possibility to retrieve these data from Note.
 *
 * @see java.util.Vector 
 */

public class NotePlugin extends java.awt.Panel implements Plugin, java.awt.event.ActionListener, java.io.Serializable
{
	private String fieldText = new String();
	private String fieldSelectedDate = (new java.util.Date()).toString();

	/**
	 * it holdes the constructed record to be add to allNoteItems
	 */

	private String NoteRecord = null;
	private String fieldAboutThisBean = new String();
	private java.awt.Button ivjCancelButton = null;
	private java.awt.Button ivjUpdateButton = null;
	private java.util.Calendar aCalendar = null;
	private java.awt.Image inputImage = null;
	private boolean fieldEditable = true;
	/**
	 * this variable is used to determine if this is the first call for the plugin
	 */
	private int firstLog = 0;

	/**
	 * used as index of the current note.
	 */
	private int noteIndex = -1;
	private java.util.Vector fieldAllNoteItems = new java.util.Vector();
	private java.awt.TextArea ivjNoteText = null;
	protected transient java.util.Vector aActionCanceledEventListener = null;
	protected transient java.util.Vector aActionPerformedEventListener = null;
	protected transient java.beans.PropertyChangeSupport propertyChange;
/**
 * Constructor to the NotePlugin.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public NotePlugin()
{
	super();
	initialize();
}
/**
 * NotePlugin constructor.
 * @param layout java.awt.LayoutManager
 */
public NotePlugin(java.awt.LayoutManager layout)
{
	super(layout);
}
/**
 * Method to handle events for the ActionListener interface.
 * @param e java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void actionPerformed(java.awt.event.ActionEvent e)
{
	// user code begin {1}
	// user code end
	if ((e.getSource() == getCancelButton()))
	{
		connEtoC1();
	}
	if ((e.getSource() == getUpdateButton()))
	{
		connEtoC2(e);
	}
	// user code begin {2}
	// user code end
}
/**
 * Adds an ActionCanceledEventListener to the listener list.
 * @param newListener  The ActionCanceledEventListener to be added
 * @see   com.ibm.calendar.events.ActionCanceledEventListener
 * @see   com.ibm.calendar.NotePlugin#removeActionCanceledEventListener
 **/
public void addActionCanceledEventListener(com.ibm.calendar.events.ActionCanceledEventListener newListener)
{
	if (aActionCanceledEventListener == null)
	{
		aActionCanceledEventListener = new java.util.Vector();
	};
	aActionCanceledEventListener.addElement(newListener);
}
/**
 * Adds an ActionPerformedEventListener to the listener list.
 * @param newListener  The ActionPerformedEventListener to be added
 * @see   com.ibm.calendar.events.ActionPerformedEventListener
 * @see   com.ibm.calendar.NotePlugin#removeActionPerformedEventListener
 **/
public void addActionPerformedEventListener(com.ibm.calendar.events.ActionPerformedEventListener newListener)
{
	if (aActionPerformedEventListener == null)
	{
		aActionPerformedEventListener = new java.util.Vector();
	};
	aActionPerformedEventListener.addElement(newListener);
}
/**
 * Adds an PropertyChangeListener to the listener list.
 * @param listener  The PropertyChangeListener to be added
 * @see   com.ibm.calendar.events.PropertyChangeListener
 * @see   com.ibm.calendar.NotePlugin#removePropertyChangeListener
 **/
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener)
{
	getPropertyChange().addPropertyChangeListener(listener);
}
/**
 * cancelButton cancelButton_ActionEvents clear the plugin temprory data and move control to the parent calendar.
 */
public void cancelButton_ActionEvents()
{
	setVisible(false);
	ivjNoteText.setText("");
	fireOnActionCanceledEvent(new com.ibm.calendar.events.ActionCanceledEvent(this));
	return;
}
/**
 * connEtoC1:  (CancelButton.action. --> NotePlugin.cancelButton_ActionEvents()V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC1()
{
	try
	{
		// user code begin {1}
		// user code end
		this.cancelButton_ActionEvents();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc)
	{
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC2:  (UpdateButton.action.actionPerformed(java.awt.event.ActionEvent) --> NotePlugin.updateButton_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC2(java.awt.event.ActionEvent arg1)
{
	try
	{
		// user code begin {1}
		// user code end
		this.updateButton_ActionPerformed(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc)
	{
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * This method handels the update of the allNoteItems and add to it the new noteRecord
 */
private void doOperation() {
	boolean found = false;
	int NoteSize = fieldAllNoteItems.size();
	int i;
	setText(ivjNoteText.getText());
	NoteRecord = fieldSelectedDate + ivjNoteText.getText();
	for (i = 0; i < NoteSize; i++) {
		if (fieldSelectedDate.compareTo(((String) fieldAllNoteItems.elementAt(i)).substring(0, 10)) == 0) {
			found = true;
			break;
		}
	}
	if (found)
		fieldAllNoteItems.removeElementAt(i);
	fieldAllNoteItems.addElement(NoteRecord);
	setAllNoteItems(fieldAllNoteItems);
}
/**
 * Method to support listener events.
 * @param e com.ibm.calendar.events.ActionCanceledEvent
 */
protected void fireOnActionCanceledEvent(com.ibm.calendar.events.ActionCanceledEvent e)
{
	if (aActionCanceledEventListener == null)
	{
		return;
	};
	int currentSize = aActionCanceledEventListener.size();
	com.ibm.calendar.events.ActionCanceledEventListener tempListener = null;
	for (int index = 0; index < currentSize; index++)
	{
		tempListener = (com.ibm.calendar.events.ActionCanceledEventListener) aActionCanceledEventListener.elementAt(index);
		if (tempListener != null)
		{
			tempListener.onActionCanceledEvent(e);
		};
	};
}
/**
 * Method to support listener events.
 * @param e com.ibm.calendar.events.ActionPerformedEvent
 */
protected void fireOnActionPerformedEvent(com.ibm.calendar.events.ActionPerformedEvent e)
{
	if (aActionPerformedEventListener == null)
	{
		return;
	};
	int currentSize = aActionPerformedEventListener.size();
	com.ibm.calendar.events.ActionPerformedEventListener tempListener = null;
	for (int index = 0; index < currentSize; index++)
	{
		tempListener = (com.ibm.calendar.events.ActionPerformedEventListener) aActionPerformedEventListener.elementAt(index);
		if (tempListener != null)
		{
			tempListener.onActionPerformedEvent(e);
		};
	};
}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 * @param propertyName String
 * @param oldValue Object
 * @param newValue Object
 */
public void firePropertyChange(String propertyName, Object oldValue, Object newValue)
{
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}
/**
 * Gets the aboutThisBean property (java.lang.String) value.
 * @return The aboutThisBean property value.
 * @see #setAboutThisBean
 */
public String getAboutThisBean()
{
	return (getClass().getName() + "^NotePlugin^2.0^docs/index.html");
}
/**
 * Gets the allNoteItems property (java.util.Vector) value.
 * @return The allNoteItems property value.
 * @see #setAllNoteItems
 */
public java.util.Vector getAllNoteItems()
{
	return fieldAllNoteItems;
}
/**
 * Return the Button2 property value.
 * @return java.awt.Button
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Button getCancelButton()
{
	if (ivjCancelButton == null)
	{
		try
		{
			ivjCancelButton = new java.awt.Button();
			ivjCancelButton.setName("CancelButton");
			ivjCancelButton.setBounds(92, 165, 56, 23);
			ivjCancelButton.setLabel("Cancel");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc)
		{
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjCancelButton;
}
/**
 * Gets the editable property (boolean) value.
 * @return The editable property value.
 * @see #setEditable
 */
public boolean getEditable()
{
	return fieldEditable;
}
/**
 * Return the TextArea1 property value.
 * @return java.awt.TextArea
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.TextArea getNoteText()
{
	if (ivjNoteText == null)
	{
		try
		{
			ivjNoteText = new java.awt.TextArea();
			ivjNoteText.setName("NoteText");
			ivjNoteText.setBounds(14, 37, 152, 117);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc)
		{
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjNoteText;
}
/**
 * Accessor for the propertyChange field.
 */
protected java.beans.PropertyChangeSupport getPropertyChange()
{
	if (propertyChange == null)
	{
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}
/**
 * Gets the selectedDate property (java.lang.String) value.
 * @return The selectedDate property value.
 * @see #setSelectedDate
 */
public String getSelectedDate()
{
	return fieldSelectedDate;
}
/**
 * Gets the text property (java.lang.String) value.
 * @return The text property value.
 * @see #setText
 */
public String getText()
{
	return fieldText;
}
/**
 * Return the Button1 property value.
 * @return java.awt.Button
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Button getUpdateButton()
{
	if (ivjUpdateButton == null)
	{
		try
		{
			ivjUpdateButton = new java.awt.Button();
			ivjUpdateButton.setName("UpdateButton");
			ivjUpdateButton.setBounds(27, 165, 56, 23);
			ivjUpdateButton.setLabel("Update");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc)
		{
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjUpdateButton;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception)
{

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	// System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	// exception.printStackTrace(System.out);
}
/**
 * Initializes connections
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections()
{
	// user code begin {1}
	// user code end
	getCancelButton().addActionListener(this);
	getUpdateButton().addActionListener(this);
}
/**
 * Initialize the class.
 *	ivjNoteText.setEditable(fieldEditable);
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize()
{
	// user code begin {1}
	// user code end
	setName("NotePlugin");
	setLayout(null);
	setSize(182, 198);
	add(getNoteText(), getNoteText().getName());
	add(getUpdateButton(), getUpdateButton().getName());
	add(getCancelButton(), getCancelButton().getName());
	initConnections();
	// user code begin {2}
	// user code end
}
/**
 * used to initialize the init List in the DayPlugin
 */
public void initPlugin()
{
	boolean found = false;
	int NoteSize = fieldAllNoteItems.size();
	int i;
	if (aCalendar.get(java.util.Calendar.DAY_OF_MONTH) < 10)
	{
		fieldSelectedDate = "0" + aCalendar.get(java.util.Calendar.DAY_OF_MONTH) + "/";
	} else
	{
		fieldSelectedDate = "" + aCalendar.get(java.util.Calendar.DAY_OF_MONTH) + "/";
	}
	if (aCalendar.get(java.util.Calendar.MONTH) < 10)
	{
		fieldSelectedDate = fieldSelectedDate + "0" + "" + (aCalendar.get(java.util.Calendar.MONTH) + 1) + "/";
	} else
	{
		fieldSelectedDate = fieldSelectedDate + "" + (aCalendar.get(java.util.Calendar.MONTH) + 1) + "/";
	}
	fieldSelectedDate = fieldSelectedDate + "" + aCalendar.get(java.util.Calendar.YEAR);
	setSelectedDate(fieldSelectedDate);
	for (i = 0; i < NoteSize; i++)
	{
		if (fieldSelectedDate.compareTo(((String) fieldAllNoteItems.elementAt(i)).substring(0, 10)) == 0)
		{
			found = true;
			break;
		}
	}
	if (found)
	{
		ivjNoteText.setText(((String) fieldAllNoteItems.elementAt(i)).substring(10));
		setAllNoteItems(fieldAllNoteItems);
		setText(((String) fieldAllNoteItems.elementAt(i)).substring(10));
	}
	this.setVisible(true);
}
/**
 * This method is used to draw the NotePlugin.
 * @param g java.awt.Graphics
 */
public void paint(java.awt.Graphics g)
{
	if (inputImage == null)
	{
		g.drawRect(0, 0, 181, 197);
		g.setColor(java.awt.Color.black);
		g.drawString(fieldSelectedDate, 50, 24);
	} else
	{
		g.drawImage(inputImage, 0, 0, 182, 198, this);
		g.setColor(java.awt.Color.black);
		g.drawString(fieldSelectedDate, 50, 24);
		g.setColor(java.awt.Color.white);
		g.drawString(fieldSelectedDate, 49, 23);
		g.setColor(java.awt.Color.black);
	}
}
/**
 * Removes an ActionCanceledEventListener to the listener list.
 * @param newListener  The ActionCanceledEventListener to be removed
 * @see   com.ibm.calendar.events.ActionCanceledEventListener
 * @see   com.ibm.calendar.NotePlugin#addActionCanceledEventListener
 **/
public void removeActionCanceledEventListener(com.ibm.calendar.events.ActionCanceledEventListener newListener)
{
	if (aActionCanceledEventListener != null)
	{
		aActionCanceledEventListener.removeElement(newListener);
	};
}
/**
 * Removes an ActionPerformedEventListener to the listener list.
 * @param newListener  The ActionPerformedEventListener to be removed
 * @see   com.ibm.calendar.events.ActionPerformedEventListener
 * @see   com.ibm.calendar.NotePlugin#addActionPerformedEventListener
 **/
public void removeActionPerformedEventListener(com.ibm.calendar.events.ActionPerformedEventListener newListener)
{
	if (aActionPerformedEventListener != null)
	{
		aActionPerformedEventListener.removeElement(newListener);
	};
}
/**
 * Removes an PropertyChangeListener to the listener list.
 * @param newListener  The PropertyChangeListener to be removed
 * @see   com.ibm.calendar.events.PropertyChangeListener
 * @see   com.ibm.calendar.NotePlugin#addPropertyChangeListener
 **/
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener)
{
	getPropertyChange().removePropertyChangeListener(listener);
}
/**
 * Sets the aboutThisBean property (java.lang.String) value.
 * @param aboutThisBean The new value for the property.
 * @see #getAboutThisBean
 */
public void setAboutThisBean(String aboutThisBean)
{
	fieldAboutThisBean = aboutThisBean;
}
/**
 * Sets the allNoteItems property (java.util.Vector) value.
 * @param allNoteItems The new value for the property.
 * @see #getAllNoteItems
 */
public void setAllNoteItems(java.util.Vector allNoteItems)
{
	java.util.Vector oldValue = fieldAllNoteItems;
	fieldAllNoteItems = allNoteItems;
	firePropertyChange("allNoteItems", oldValue, allNoteItems);
}
/**
 * Sets the editable property (boolean) value.
 * @param editable The new value for the property.
 * @see #getEditable
 */
public void setEditable(boolean editable)
{
	fieldEditable = editable;
}
/**
 * initialize the plugin data.
 * @param C java.util.Calendar
 * @param i java.awt.Image
 * @param x int
 * @param y int
 */

public void setInfo(java.util.Calendar c, java.awt.Image i, int x, int y)
{
	if (firstLog != 0)
	{
		aCalendar = c;
		inputImage = i;
		this.setLocation(x, y);
	} else
	{
		this.setVisible(false);
		firstLog = 1;
	}
}
/**
 * Sets the selectedDate property (java.lang.String) value.
 * @param selectedDate The new value for the property.
 * @see #getSelectedDate
 */
public void setSelectedDate(String selectedDate)
{
	fieldSelectedDate = selectedDate;
}
/**
 * Sets the text property (java.lang.String) value.
 * @param text The new value for the property.
 * @see #getText
 */
public void setText(String text)
{
	String oldValue = fieldText;
	fieldText = text;
	firePropertyChange("text", oldValue, text);
}
/**
 * This method calls doOperation function to set the dayPlugin 
 * resultSelectedIntervalAsString property
 */
public void updateButton_ActionPerformed(java.awt.event.ActionEvent actionEvent)
{
	try
	{
		doOperation();
	} catch (Exception e)
	{
		System.out.println(e);
	}
	this.setVisible(false);
	ivjNoteText.setText("");
	fireOnActionPerformedEvent(new com.ibm.calendar.events.ActionPerformedEvent(this));
	return;
}
}