/* @(#) IClockBeanInfo.java        Ver 1.0    01,April,1998
 *
 * Copyright (c) 1998 International Business Machines.
 * All Rights Reserved.
 *
 * Author : Sunanda Bera & P.Sushma
 * Last Modified : 01,April,1998
 *
 * Purpose : Defines class IClockBeanInfo.
 *
 *
 * Revision History 
 * ======== ======= 
 *
 * Date        By            Description
 * ----        --            -----------
 *
 *
 */
package com.ibm.clock;

import java.awt.Image;

import java.beans.BeanInfo;   
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

import com.ibm.clock.editors.*;

/**
 * BeanInfo for the IClock class.
 */  
public class IClockBeanInfo extends SimpleBeanInfo 
{   
    private static final String [][] PROPERTIES = {
            { "timeZone", "getTimeZone", "setTimeZone" },
            { "displayMode", "getDisplayMode", "setDisplayMode" },
            { "analogBorderColor", "getAnalogBorderColor", "setAnalogBorderColor" },
            { "analogBorderWidth", "getAnalogBorderWidth", "setAnalogBorderWidth" },
            { "analogDialColor", "getAnalogDialColor", "setAnalogDialColor" },
            { "analogTickColor", "getAnalogTickColor", "setAnalogTickColor" },
            { "analogTickStyle", "getAnalogTickStyle", "setAnalogTickStyle" },
            { "analogNumeralStyle", "getAnalogNumeralStyle", "setAnalogNumeralStyle" },
            { "analogNumeralColor", "getAnalogNumeralColor", "setAnalogNumeralColor" },
            { "analogNumeralFont", "getAnalogNumeralFont", "setAnalogNumeralFont" },
            { "analogHourHandColor", "getAnalogHourHandColor", "setAnalogHourHandColor" },
            { "analogHourHandVisible", "getAnalogHourHandVisible", "setAnalogHourHandVisible" },
            { "analogMinuteHandColor", "getAnalogMinuteHandColor", "setAnalogMinuteHandColor" },
            { "analogMinuteHandVisible", "getAnalogMinuteHandVisible", "setAnalogMinuteHandVisible" },
            { "analogSecondHandColor", "getAnalogSecondHandColor", "setAnalogSecondHandColor" },
            { "analogSecondHandVisible", "getAnalogSecondHandVisible", "setAnalogSecondHandVisible" },
            { "digitalNumeralFont", "getDigitalNumeralFont", "setDigitalNumeralFont" },
            { "digitalForeGroundColor", "getDigitalForeGroundColor", "setDigitalForeGroundColor" },
            { "digitalBackGroundColor", "getDigitalBackGroundColor", "setDigitalBackGroundColor" },
            { "digitalDisplayStyle", "getDigitalDisplayStyle", "setDigitalDisplayStyle" },
            { "digitalDisplayAMPM", "getDigitalDisplayAMPM", "setDigitalDisplayAMPM" },
            { "digitalTwelveHourMode", "getDigitalTwelveHourMode", "setDigitalTwelveHourMode" }
            };
            
    private static final Class [] EDITORS = {
            TimeZoneEditor.class,
            DisplayModeEditor.class,
            null,   // Border color
            null,   // Border width
            null,   // Dial color
            null,   // tick color
            TickStyleEditor.class,
            NumeralStyleEditor.class,
            null,   // numeral color
            null,   // numeral font
            null,   // hour hand color
            null,   // hour hand visible
            null,   // minute hand color
            null,   // minute hand visible
            null,   //second hand color
            null,    // second hand visible
            null,    // numeral font
            null,    // foreground color
            null,    // background color
            DisplayStyleEditor.class,   // Display style
            null,   // Display AMPM
            null,   // Twelve Hour mode
            };

/**
 * Get the properties of the IClock class.
 * @return The array of property descriptors.
 */    
    public PropertyDescriptor [] getPropertyDescriptors()
    {
        PropertyDescriptor [] pds = new PropertyDescriptor[ PROPERTIES.length ];
        for( int i = 0; i < PROPERTIES.length; i++ )
        {
            String [] prop = PROPERTIES[i];
            Class editorClass = EDITORS[i];
            try
            {
                pds[i] = new PropertyDescriptor( prop[0], IClock.class, prop[1], prop[2] );
            }
            catch( IntrospectionException e )
            {
                debug( e.toString() );
            }//end of try catch
            
            if( EDITORS[i] != null )
                pds[i].setPropertyEditorClass( EDITORS[i] );
        }//end for
        
        return pds;
    }//end of getPropertyDescriptors
       
    /**
     * Returns an icon of the type requested if it is available, else
     * returns null.
     *
     */
    public Image getIcon(int iconKind) 
    {
        Image img = null;
        if (iconKind == BeanInfo.ICON_COLOR_16x16) 
        {
            img = loadImage("IClockIconColor16.gif");
        }   // End if.
        else if (iconKind == BeanInfo.ICON_COLOR_32x32) 
        {
            img = loadImage("IClockIconColor32.gif");
        }   // End if.
        else if (iconKind == BeanInfo.ICON_MONO_16x16) 
        {
            img = loadImage("IClockIconMono16.gif");
        }   // End if.
        else if (iconKind == BeanInfo.ICON_MONO_32x32) 
        {
            img = loadImage("IClockIconMono32.gif");
        }   // End if.

        return img;
    }   // End method getIcon.
    
    private static final boolean DEBUG = true;
    private final void debug( String s )
    {
        if( DEBUG )
            System.out.println( getClass().getName() + "::" + s );
    }//end of debug
}    //End class IClockBeanInfo
  
