/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ve.examples.cdm.dept.Company;
import org.eclipse.ve.examples.cdm.dept.Employee;

public class Department
implements Serializable {
    protected Company company;
    protected String deptName;
    protected Employee manager;
    protected List employees = new ArrayList(1);
    protected transient PropertyChangeSupport propChange;
    public static final String DEPARTMENT_NAME = "deptname";
    public static final String MANAGER = "manager";
    public static final String EMPLOYEES = "employees";

    public String getDepartmentName() {
        return this.deptName;
    }

    public void setDepartmentName(String name) {
        String old = this.deptName;
        this.deptName = name;
        this.firePropertyChangeEvent(DEPARTMENT_NAME, old, this.deptName);
    }

    public Employee getManager() {
        return this.manager;
    }

    public void setManager(Employee manager) {
        Employee old = this.manager;
        this.manager = manager;
        if (manager != null) {
            manager.setManages(this);
        }
        if (old != null) {
            old.setManages(null);
        }
        this.firePropertyChangeEvent(MANAGER, old, manager);
    }

    public List getEmployees() {
        return Collections.unmodifiableList(this.employees);
    }

    public void addEmployee(Employee employee) {
        Department oldDept = employee.getDepartment();
        if (oldDept != null) {
            oldDept.removeEmployee(employee);
        }
        this.employees.add(employee);
        employee.dept = this;
        this.firePropertyChangeEvent(EMPLOYEES, null, employee);
    }

    public void addEmployee(Employee employee, int pos) {
        Department oldDept = employee.getDepartment();
        if (oldDept != null) {
            oldDept.removeEmployee(employee);
        }
        this.employees.add(pos, employee);
        employee.dept = this;
        this.firePropertyChangeEvent(EMPLOYEES, null, employee);
    }

    public void removeEmployee(Employee employee) {
        if (this.employees.remove(employee)) {
            employee.dept = null;
            this.firePropertyChangeEvent(EMPLOYEES, employee, null);
        }
    }

    public Company getCompany() {
        return this.company;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propChange == null) {
            this.propChange = new PropertyChangeSupport(this);
        }
        this.propChange.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propChange == null) {
            this.propChange = new PropertyChangeSupport(this);
        }
        this.propChange.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.propChange == null) {
            this.propChange = new PropertyChangeSupport(this);
        }
        this.propChange.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.propChange == null) {
            this.propChange = new PropertyChangeSupport(this);
        }
        this.propChange.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propChange != null) {
            this.propChange.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

