/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.java.beaninfo;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.ve.examples.java.vm.Area;

public class AreaCustomizer
extends Panel
implements Customizer {
    protected PropertyChangeSupport pcSupport = new PropertyChangeSupport(this);
    protected Area fArea;
    private List fColorList;
    private TextField fTxtFldBorderWidth;
    private Checkbox fOvalCheckbox;
    private Checkbox fNoneCheckbox;
    private Checkbox fDiamondCheckbox;
    private static Hashtable fColors = new Hashtable(5);

    static {
        fColors.put("red", Color.red);
        fColors.put("blue", Color.blue);
        fColors.put("green", Color.green);
        fColors.put("yellow", Color.yellow);
        fColors.put("black", Color.black);
        fColors.put("cyan", Color.cyan);
        fColors.put("orange", Color.orange);
        fColors.put("darkGray", Color.darkGray);
        fColors.put("gray", Color.gray);
        fColors.put("lightGray", Color.lightGray);
        fColors.put("magenta", Color.magenta);
        fColors.put("pink", Color.pink);
        fColors.put("white", Color.white);
    }

    public AreaCustomizer() {
        this.initialize();
    }

    protected void addCheckboxListeners() {
        ItemListener checkBoxListener = new ItemListener(){

            public void itemStateChanged(ItemEvent anEvent) {
                AreaCustomizer.this.updateShape();
            }
        };
        this.fNoneCheckbox.addItemListener(checkBoxListener);
        this.fOvalCheckbox.addItemListener(checkBoxListener);
        this.fDiamondCheckbox.addItemListener(checkBoxListener);
    }

    protected void addListListener() {
        this.fColorList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent anEvent) {
                Color selectedColor = (Color)fColors.get(AreaCustomizer.this.fColorList.getSelectedItem());
                AreaCustomizer.this.changeFillColor(selectedColor);
                AreaCustomizer.this.pcSupport.firePropertyChange("fillColor", null, selectedColor);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener aPCL) {
        this.pcSupport.addPropertyChangeListener(aPCL);
    }

    protected void addTextBoxListener() {
        this.fTxtFldBorderWidth.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent anEvent) {
                Integer newValue = new Integer(AreaCustomizer.this.fTxtFldBorderWidth.getText());
                AreaCustomizer.this.changeBorderWidth(newValue);
                AreaCustomizer.this.pcSupport.firePropertyChange("border", null, newValue);
            }
        });
    }

    protected void changeBorderWidth(int borderValue) {
        this.fArea.setBorderWidth(borderValue);
        this.pcSupport.firePropertyChange("borderValue", null, new Integer(borderValue));
    }

    protected void changeFillColor(Color aColor) {
        this.fArea.setFillColor(aColor);
        this.pcSupport.firePropertyChange("fillColor", null, aColor);
    }

    protected void changeShape(int shapeValue) {
        this.fArea.setShape(shapeValue);
        this.pcSupport.firePropertyChange("shape", null, new Integer(shapeValue));
    }

    protected void initialize() {
        this.setLayout(new GridBagLayout());
        Insets inset = new Insets(4, 4, 4, 4);
        Label label = new Label("Border Width:", 1);
        GridBagConstraints labelConstraint = new GridBagConstraints();
        labelConstraint.anchor = 17;
        labelConstraint.insets = inset;
        this.add((Component)label, labelConstraint);
        this.fTxtFldBorderWidth = new TextField();
        GridBagConstraints textConstraint = new GridBagConstraints();
        textConstraint.gridx = 1;
        textConstraint.insets = inset;
        textConstraint.fill = 2;
        this.add((Component)this.fTxtFldBorderWidth, textConstraint);
        this.addTextBoxListener();
        this.fColorList = new List(fColors.size(), false);
        Enumeration enumeration = fColors.keys();
        while (enumeration.hasMoreElements()) {
            this.fColorList.add((String)enumeration.nextElement());
        }
        GridBagConstraints listConstraint = new GridBagConstraints();
        listConstraint.gridy = 1;
        listConstraint.gridx = 0;
        listConstraint.gridwidth = 3;
        listConstraint.fill = 1;
        listConstraint.insets = inset;
        this.add((Component)this.fColorList, listConstraint);
        this.addListListener();
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.fNoneCheckbox = new Checkbox("No Shape");
        this.fNoneCheckbox.setCheckboxGroup(checkboxGroup);
        GridBagConstraints noneCheckboxConstraint = new GridBagConstraints();
        noneCheckboxConstraint.gridy = 2;
        noneCheckboxConstraint.gridx = 0;
        noneCheckboxConstraint.anchor = 17;
        noneCheckboxConstraint.insets = inset;
        this.add((Component)this.fNoneCheckbox, noneCheckboxConstraint);
        this.fOvalCheckbox = new Checkbox("Oval");
        this.fOvalCheckbox.setCheckboxGroup(checkboxGroup);
        GridBagConstraints ovalCheckboxConstraint = new GridBagConstraints();
        ovalCheckboxConstraint.gridy = 2;
        ovalCheckboxConstraint.gridx = 1;
        ovalCheckboxConstraint.anchor = 17;
        ovalCheckboxConstraint.insets = inset;
        this.add((Component)this.fOvalCheckbox, ovalCheckboxConstraint);
        this.fDiamondCheckbox = new Checkbox("Diamond");
        this.fDiamondCheckbox.setCheckboxGroup(checkboxGroup);
        GridBagConstraints diamondCheckboxConstraint = new GridBagConstraints();
        diamondCheckboxConstraint.gridy = 2;
        diamondCheckboxConstraint.gridx = 2;
        diamondCheckboxConstraint.anchor = 17;
        diamondCheckboxConstraint.insets = inset;
        this.add((Component)this.fDiamondCheckbox, diamondCheckboxConstraint);
        this.addCheckboxListeners();
    }

    public void removePropertyChangeListener(PropertyChangeListener aPCL) {
        this.pcSupport.removePropertyChangeListener(aPCL);
    }

    public void setObject(Object anObject) {
        this.fArea = (Area)anObject;
        this.fTxtFldBorderWidth.setText("" + this.fArea.getBorderWidth());
        if (this.fArea.getFillColor() != null) {
            Enumeration enumeration = fColors.keys();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                String colorName = (String)enumeration.nextElement();
                Color color = (Color)fColors.get(colorName);
                if (color.equals(this.fArea.getFillColor())) {
                    this.fColorList.select(i);
                    break;
                }
                ++i;
            }
        }
        switch (this.fArea.getShape()) {
            case 0: {
                this.fNoneCheckbox.setState(true);
                break;
            }
            case 1: {
                this.fOvalCheckbox.setState(true);
                break;
            }
            case 2: {
                this.fDiamondCheckbox.setState(true);
            }
        }
    }

    protected void updateShape() {
        if (this.fNoneCheckbox.getState()) {
            this.changeShape(0);
        } else if (this.fOvalCheckbox.getState()) {
            this.changeShape(1);
        } else if (this.fDiamondCheckbox.getState()) {
            this.changeShape(2);
        }
    }
}

