/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.java.beaninfo;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.ve.examples.java.beaninfo.ColorCellRenderer;
import org.eclipse.ve.examples.java.vm.Area;

public class AreaSwingCustomizer
extends JPanel
implements Customizer {
    protected PropertyChangeSupport pcSupport = new PropertyChangeSupport(this);
    protected Area fArea;
    private JList fColorList;
    private JTextField fTxtFldBorderWidth;
    private JRadioButton fOvalCheckbox;
    private JRadioButton fNoneCheckbox;
    private JRadioButton fDiamondCheckbox;
    private static Color[] fColors = new Color[]{Color.red, Color.blue, Color.green, Color.yellow, Color.black, Color.cyan, Color.orange, Color.darkGray, Color.gray, Color.lightGray, Color.magenta, Color.pink, Color.white};
    private static String[] fColorNames = new String[]{"red", "blue", "green", "yellow", "black", "cyan", "orange", "darkGray", "gray", "lightGray", "magenta", "pink", "white"};

    public AreaSwingCustomizer() {
        this.initialize();
    }

    protected void addCheckboxListeners() {
        ItemListener checkBoxListener = new ItemListener(){

            public void itemStateChanged(ItemEvent anEvent) {
                AreaSwingCustomizer.this.updateShape();
            }
        };
        this.fNoneCheckbox.addItemListener(checkBoxListener);
        this.fOvalCheckbox.addItemListener(checkBoxListener);
        this.fDiamondCheckbox.addItemListener(checkBoxListener);
    }

    protected void addListListener() {
        this.fColorList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                Color newColor = (Color)AreaSwingCustomizer.this.fColorList.getSelectedValue();
                AreaSwingCustomizer.this.changeFillColor(newColor);
                AreaSwingCustomizer.this.pcSupport.firePropertyChange("fillColor", null, newColor);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener aPCL) {
        this.pcSupport.addPropertyChangeListener(aPCL);
    }

    protected void addTextBoxListener() {
        this.fTxtFldBorderWidth.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent anEvent) {
                Integer newValue = new Integer(0);
                if (!AreaSwingCustomizer.this.fTxtFldBorderWidth.getText().equals("")) {
                    newValue = new Integer(AreaSwingCustomizer.this.fTxtFldBorderWidth.getText());
                }
                AreaSwingCustomizer.this.changeBorderWidth(newValue);
                AreaSwingCustomizer.this.pcSupport.firePropertyChange("border", null, newValue);
            }
        });
    }

    protected void changeBorderWidth(int borderValue) {
        this.fArea.setBorderWidth(borderValue);
        this.pcSupport.firePropertyChange("borderValue", null, new Integer(borderValue));
    }

    protected void changeFillColor(Color aColor) {
        this.fArea.setFillColor(aColor);
        this.pcSupport.firePropertyChange("fillColor", null, aColor);
    }

    protected void changeShape(int shapeValue) {
        this.fArea.setShape(shapeValue);
        this.pcSupport.firePropertyChange("shape", null, new Integer(shapeValue));
    }

    protected void initialize() {
        this.setLayout(new GridBagLayout());
        Insets inset = new Insets(4, 4, 4, 4);
        JLabel label = new JLabel("Border Width:", 0);
        GridBagConstraints labelConstraint = new GridBagConstraints();
        labelConstraint.anchor = 17;
        labelConstraint.insets = inset;
        this.add((Component)label, labelConstraint);
        this.fTxtFldBorderWidth = new JTextField();
        GridBagConstraints textConstraint = new GridBagConstraints();
        textConstraint.gridx = 1;
        textConstraint.insets = inset;
        textConstraint.fill = 2;
        this.add((Component)this.fTxtFldBorderWidth, textConstraint);
        this.addTextBoxListener();
        DefaultListModel<Color> model = new DefaultListModel<Color>();
        int i = 0;
        while (i < fColors.length) {
            model.addElement(fColors[i]);
            ++i;
        }
        this.fColorList = new JList(model);
        this.fColorList.setCellRenderer(new ColorCellRenderer(fColorNames, fColors));
        GridBagConstraints listConstraint = new GridBagConstraints();
        listConstraint.gridy = 1;
        listConstraint.gridx = 0;
        listConstraint.gridwidth = 3;
        listConstraint.fill = 1;
        listConstraint.insets = inset;
        this.add((Component)this.fColorList, listConstraint);
        this.addListListener();
        ButtonGroup checkboxGroup = new ButtonGroup();
        this.fNoneCheckbox = new JRadioButton("No Shape");
        checkboxGroup.add(this.fNoneCheckbox);
        GridBagConstraints noneCheckboxConstraint = new GridBagConstraints();
        noneCheckboxConstraint.gridy = 2;
        noneCheckboxConstraint.gridx = 0;
        noneCheckboxConstraint.anchor = 17;
        noneCheckboxConstraint.insets = inset;
        this.add((Component)this.fNoneCheckbox, noneCheckboxConstraint);
        this.fOvalCheckbox = new JRadioButton("Oval");
        checkboxGroup.add(this.fOvalCheckbox);
        GridBagConstraints ovalCheckboxConstraint = new GridBagConstraints();
        ovalCheckboxConstraint.gridy = 2;
        ovalCheckboxConstraint.gridx = 1;
        ovalCheckboxConstraint.anchor = 17;
        ovalCheckboxConstraint.insets = inset;
        this.add((Component)this.fOvalCheckbox, ovalCheckboxConstraint);
        this.fDiamondCheckbox = new JRadioButton("Diamond");
        checkboxGroup.add(this.fDiamondCheckbox);
        GridBagConstraints diamondCheckboxConstraint = new GridBagConstraints();
        diamondCheckboxConstraint.gridy = 2;
        diamondCheckboxConstraint.gridx = 2;
        diamondCheckboxConstraint.anchor = 17;
        diamondCheckboxConstraint.insets = inset;
        this.add((Component)this.fDiamondCheckbox, diamondCheckboxConstraint);
        this.addCheckboxListeners();
    }

    public void removePropertyChangeListener(PropertyChangeListener aPCL) {
        this.pcSupport.removePropertyChangeListener(aPCL);
    }

    public void setObject(Object anObject) {
        this.fArea = (Area)anObject;
        this.fTxtFldBorderWidth.setText("" + this.fArea.getBorderWidth());
        if (this.fArea.getFillColor() != null) {
            this.fColorList.setSelectedValue(this.fArea.getFillColor(), true);
        }
        switch (this.fArea.getShape()) {
            case 0: {
                this.fNoneCheckbox.setSelected(true);
                break;
            }
            case 1: {
                this.fOvalCheckbox.setSelected(true);
                break;
            }
            case 2: {
                this.fDiamondCheckbox.setSelected(true);
            }
        }
    }

    protected void updateShape() {
        if (this.fNoneCheckbox.isSelected()) {
            this.changeShape(0);
        } else if (this.fOvalCheckbox.isSelected()) {
            this.changeShape(1);
        } else if (this.fDiamondCheckbox.isSelected()) {
            this.changeShape(2);
        }
    }
}

