/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.java.beaninfo;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.ve.examples.java.vm.ButtonBar;
import sun.awt.OrientableFlowLayout;

public class ButtonBarCustomizer
extends Panel
implements Customizer {
    protected PropertyChangeSupport fPCSupport = new PropertyChangeSupport(this);
    protected ButtonBar fButtonBar;
    protected List fComponentList;
    protected Panel fButtonRow;
    protected Button fAddButton;
    protected Button fRemoveButton;

    public ButtonBarCustomizer() {
        this.initialize();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.fPCSupport.addPropertyChangeListener(listener);
    }

    protected void buildListContents() {
        this.fComponentList.removeAll();
        int i = 0;
        while (i < this.fButtonBar.getComponentCount()) {
            if (this.fButtonBar.getComponent(i) instanceof Button) {
                this.fComponentList.add("Button (" + ((Button)this.fButtonBar.getComponent(i)).getLabel() + ")");
            } else {
                this.fComponentList.add(this.fButtonBar.getComponent(i).toString());
            }
            ++i;
        }
        this.fRemoveButton.setEnabled(this.fComponentList.getSelectedItem() != null);
    }

    protected void createButton() {
        this.fButtonBar.add(new Button("  " + (this.getButtonBarComponentCount() + 1) + " "));
        this.buildListContents();
        this.fPCSupport.firePropertyChange("components", null, null);
    }

    protected int getButtonBarComponentCount() {
        return this.fButtonRow.getComponentCount();
    }

    protected Component getSelectedComponent() {
        return this.fButtonBar.getComponent(this.fComponentList.getSelectedIndex());
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.fComponentList = new List();
        this.add((Component)this.fComponentList, "Center");
        this.fComponentList.setSize(110, 700);
        this.fComponentList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent anEvent) {
                ButtonBarCustomizer.this.fRemoveButton.setEnabled(ButtonBarCustomizer.this.fComponentList.getSelectedItem() != null);
            }
        });
        this.fButtonRow = new Panel();
        this.fButtonRow.setLayout((LayoutManager)new OrientableFlowLayout(1));
        this.add((Component)this.fButtonRow, "East");
        this.fAddButton = new Button("Add");
        this.fButtonRow.add(this.fAddButton);
        this.fAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anEvent) {
                ButtonBarCustomizer.this.createButton();
            }
        });
        this.fRemoveButton = new Button("Remove");
        this.fButtonRow.add(this.fRemoveButton);
        this.fRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anEvent) {
                ButtonBarCustomizer.this.removeComponent();
            }
        });
    }

    protected void removeComponent() {
        this.fButtonBar.remove(this.getSelectedComponent());
        this.buildListContents();
        this.fPCSupport.firePropertyChange("components", null, null);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.fPCSupport.removePropertyChangeListener(listener);
    }

    public void setObject(Object bean) {
        this.fButtonBar = (ButtonBar)bean;
        this.buildListContents();
    }
}

