/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.launcher.remotevm;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.AppletFrame;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.JAppletFrame;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.VCELauncherMessages;

public class JavaBeansLauncher {
    public static Point OFF_SCREEN = new Point(-10000, -10000);
    public static Point ON_SCREEN = new Point(0, 0);
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String localeArg;
        String nameOfClassToLaunch = System.getProperty("vce.launcher.class");
        String lookAndFeelArg = System.getProperty("vce.launcher.lookandfeel");
        if (lookAndFeelArg != null && !lookAndFeelArg.equals("")) {
            try {
                UIManager.setLookAndFeel(lookAndFeelArg);
            }
            catch (Exception exc) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.SettingLookAndFeel_ERROR_"), lookAndFeelArg));
                exc.printStackTrace();
            }
        }
        if ((localeArg = System.getProperty("locale")) != null && !localeArg.equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(localeArg, "_");
            String language = "";
            String country = "";
            String variant = "";
            if (tokenizer.hasMoreElements()) {
                language = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                country = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                country = tokenizer.nextToken();
            }
            Locale locale = new Locale(language, country, variant);
            Locale.setDefault(locale);
        }
        try {
            Class<?> aClass = Class.forName(nameOfClassToLaunch);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ljava.applet.Applet;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(aClass)) {
                String projectURL = System.getProperty("vce.launcher.projecturl");
                JavaBeansLauncher.launchApplet(aClass, projectURL);
                return;
            }
            Constructor<?> ctor = aClass.getDeclaredConstructor(null);
            ((AccessibleObject)ctor).setAccessible(true);
            Object javaBean = ctor.newInstance(null);
            if (javaBean instanceof Window) {
                JavaBeansLauncher.launchWindow((Window)javaBean, (Component)javaBean, ((Component)javaBean).getSize());
            } else if (javaBean instanceof JComponent) {
                JavaBeansLauncher.launchJComponent((JComponent)javaBean);
            } else if (javaBean instanceof Component) {
                JavaBeansLauncher.launchComponent((Component)javaBean);
            }
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Msg.BeanWithNullConstructor_INFO_"), nameOfClassToLaunch));
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.UnableToLoad_ERROR_"), nameOfClassToLaunch));
            System.exit(0);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.NoDefaultConstructor_ERROR_"), nameOfClassToLaunch));
            System.exit(0);
        }
        catch (InstantiationException exc) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InstantiationException_ERROR_"), nameOfClassToLaunch));
            exc.printStackTrace();
            System.exit(0);
        }
        catch (InvocationTargetException exc) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), nameOfClassToLaunch));
            exc.printStackTrace();
            System.exit(0);
        }
        catch (IllegalAccessException exc) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.IllegalAccessException_ERROR_"), nameOfClassToLaunch));
            exc.printStackTrace();
            System.exit(0);
        }
    }

    protected static void launchJComponent(JComponent aJComponent) {
        JFrame frame = new JFrame(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.FrameTitle.LaunchJComponent"), aJComponent.getClass().getName()));
        Dimension aComponentSize = aJComponent.getSize();
        frame.getContentPane().add(aJComponent);
        JavaBeansLauncher.launchWindow(frame, aJComponent, aComponentSize);
    }

    protected static void launchWindow(Window aWindow, Component aComponent, Dimension aComponentSize) {
        if (aWindow instanceof JFrame) {
            ((JFrame)aWindow).setDefaultCloseOperation(3);
        } else if (aWindow instanceof JDialog) {
            ((JDialog)aWindow).setDefaultCloseOperation(3);
        }
        aWindow.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent anEvent) {
                System.exit(0);
            }
        });
        ((Component)aWindow).setLocation(OFF_SCREEN);
        ((Component)aWindow).setVisible(true);
        JavaBeansLauncher.sizeWindow(aWindow, aComponent, aComponentSize);
        ((Component)aWindow).setLocation(ON_SCREEN);
        aWindow.validate();
    }

    protected static void launchComponent(Component aComponent) {
        Frame frame = new Frame(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.FrameTitle.LaunchComponent"), aComponent.getClass().getName()));
        Dimension aComponentSize = aComponent.getSize();
        frame.add(aComponent);
        JavaBeansLauncher.launchWindow(frame, aComponent, aComponentSize);
    }

    protected static void sizeWindow(Window aWindow, Component aComponent, Dimension componentSize) {
        String pack = System.getProperty("pack");
        if (pack != null && pack.equals("true")) {
            aWindow.pack();
        } else if (aComponent != aWindow) {
            Insets insets = aWindow.getInsets();
            componentSize.width += insets.left + insets.right;
            componentSize.height += insets.top + insets.bottom;
            ((Component)aWindow).setSize(componentSize);
        }
    }

    protected static void launchApplet(Class anAppletClass, String projectLocation) {
        String numberOfParmsString = System.getProperty("appletparmsnumber");
        HashMap<String, String> appletParms = new HashMap<String, String>();
        if (numberOfParmsString != null) {
            int numberOfParms = Integer.parseInt(numberOfParmsString);
            int i = 1;
            while (i <= numberOfParms) {
                String name = System.getProperty("appletparmname" + i);
                String value = System.getProperty("appletparmvalue" + i);
                appletParms.put(name, value);
                ++i;
            }
        }
        Object object = null;
        try {
            Constructor ctor = anAppletClass.getDeclaredConstructor(null);
            ((AccessibleObject)ctor).setAccessible(true);
            object = ctor.newInstance(null);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        final Applet applet = object;
        Frame frame = null;
        if (applet instanceof JApplet) {
            frame = new JAppletFrame(VCELauncherMessages.getString("BeansLauncher.FrameTitle.LaunchApplet"), (JApplet)applet, appletParms);
            ((JFrame)frame).setDefaultCloseOperation(3);
        } else {
            frame = new AppletFrame(VCELauncherMessages.getString("BeansLauncher.FrameTitle.LaunchApplet"), applet, appletParms);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent event) {
                    applet.stop();
                    applet.destroy();
                    System.exit(0);
                }
            });
        }
        applet.init();
        Dimension aComponentSize = applet.getSize();
        ((Component)frame).setLocation(OFF_SCREEN);
        ((Component)frame).setVisible(true);
        if (aComponentSize.width == 0 && aComponentSize.height == 0) {
            aComponentSize = new Dimension(250, 250);
        }
        JavaBeansLauncher.sizeWindow(frame, applet, aComponentSize);
        ((Component)frame).setLocation(ON_SCREEN);
        applet.start();
        System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Msg.AppletStarted_INFO_"), anAppletClass.getName()));
        frame.validate();
    }
}

