/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.vm;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jem.internal.beaninfo.vm.FeatureDescriptorEquality;
import org.eclipse.jem.internal.beaninfo.vm.ModelingBeanInfo14;
import org.eclipse.jem.internal.beaninfo.vm.ModelingBeanInfoPre14;

public abstract class ModelingBeanInfo {
    private static boolean PRE14;
    protected boolean fMergeInheritedEvents = false;
    protected boolean fMergeInheritedMethods = false;
    protected boolean fMergeInheritedProperties = false;
    protected final BeanInfo fTargetBeanInfo;
    protected EventSetDescriptor[] fEventSets;
    protected MethodDescriptor[] fMethods;
    protected PropertyDescriptor[] fProperties;
    protected String[] fInheritedEventSets;
    protected String[] fInheritedMethods;
    protected String[] fInheritedProperties;
    static /* synthetic */ Class class$0;

    static {
        String version = System.getProperty("java.version", "");
        PRE14 = version.startsWith("1.");
        if (PRE14) {
            int revision = 0;
            if (version.length() > 2) {
                int revEnd = version.indexOf(46, 2);
                revision = version.length() > 2 ? Integer.parseInt(revEnd != -1 ? version.substring(2, revEnd) : version.substring(2)) : 0;
                PRE14 = revision < 4;
            }
        }
    }

    public static ModelingBeanInfo introspect(Class introspectClass) throws IntrospectionException {
        return ModelingBeanInfo.introspect(introspectClass, true);
    }

    public static ModelingBeanInfo introspect(Class introspectClass, boolean introspectIfNoBeanInfo) throws IntrospectionException {
        if (!introspectIfNoBeanInfo) {
            boolean found = false;
            if (!ModelingBeanInfo.classExists(String.valueOf(introspectClass.getName()) + "BeanInfo", introspectClass)) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("[Ljava.beans.BeanInfo;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isAssignableFrom(introspectClass)) {
                    String[] searchPath = Introspector.getBeanInfoSearchPath();
                    int startClassname = introspectClass.getName().lastIndexOf(".") + 1;
                    String biName = "." + introspectClass.getName().substring(startClassname) + "BeanInfo";
                    int i = 0;
                    while (i < searchPath.length) {
                        if (ModelingBeanInfo.classExists(String.valueOf(searchPath[i]) + biName, introspectClass)) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                } else {
                    found = true;
                }
            } else {
                found = true;
            }
            if (!found) {
                return null;
            }
        }
        BeanInfo bInfo = Introspector.getBeanInfo(introspectClass);
        Class superClass = introspectClass.getSuperclass();
        if (superClass == null) {
            return PRE14 ? new ModelingBeanInfoPre14(bInfo) : new ModelingBeanInfo14(bInfo);
        }
        return PRE14 ? new ModelingBeanInfoPre14(bInfo, Introspector.getBeanInfo(superClass)) : new ModelingBeanInfo14(bInfo, Introspector.getBeanInfo(superClass));
    }

    protected static boolean classExists(String className, Class fromClass) {
        if (fromClass.getClassLoader() != null) {
            try {
                fromClass.getClassLoader().loadClass(className);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (ClassLoader.getSystemClassLoader() != null) {
            try {
                ClassLoader.getSystemClassLoader().loadClass(className);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                cl.loadClass(className);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return false;
            }
        }
    }

    protected ModelingBeanInfo(BeanInfo beanInfo) {
        this.fTargetBeanInfo = beanInfo;
    }

    protected ModelingBeanInfo(BeanInfo beanInfo, BeanInfo superBeanInfo) {
        this(beanInfo);
        List full = this.addAll(beanInfo.getEventSetDescriptors());
        List inherited = this.addAll(superBeanInfo.getEventSetDescriptors());
        this.fMergeInheritedEvents = this.stripList(full, inherited);
        if (this.fMergeInheritedEvents) {
            if (!full.isEmpty()) {
                this.fEventSets = full.toArray(new EventSetDescriptor[full.size()]);
            }
            if (!inherited.isEmpty()) {
                this.createEventArray(inherited);
            }
        }
        full = this.addAll(beanInfo.getMethodDescriptors());
        inherited = this.addAll(superBeanInfo.getMethodDescriptors());
        this.fMergeInheritedMethods = this.stripList(full, inherited);
        if (this.fMergeInheritedMethods) {
            if (!full.isEmpty()) {
                this.fMethods = full.toArray(new MethodDescriptor[full.size()]);
            }
            if (!inherited.isEmpty()) {
                this.createMethodEntries(inherited);
            }
        }
        full = this.addAll(beanInfo.getPropertyDescriptors());
        inherited = this.addAll(superBeanInfo.getPropertyDescriptors());
        this.fMergeInheritedProperties = this.stripList(full, inherited);
        if (this.fMergeInheritedProperties) {
            if (!full.isEmpty()) {
                this.fProperties = full.toArray(new PropertyDescriptor[full.size()]);
            }
            if (!inherited.isEmpty()) {
                this.createPropertyArray(inherited);
            }
        }
    }

    protected void createEventArray(List features) {
        this.fInheritedEventSets = this.createDescriptorNames(features);
    }

    protected void createMethodEntries(List features) {
        int s = features.size();
        this.fInheritedMethods = new String[s];
        int i = 0;
        while (i < s) {
            this.fInheritedMethods[i] = this.longName((MethodDescriptor)features.get(i));
            ++i;
        }
    }

    protected String longName(MethodDescriptor md) {
        String n = md.getName();
        StringBuffer sb = new StringBuffer(n.length() + 20);
        sb.append(n);
        sb.append(':');
        Method m = md.getMethod();
        sb.append(m.getName());
        sb.append('(');
        Class<?>[] parms = m.getParameterTypes();
        int j = 0;
        while (j < parms.length) {
            if (j > 0) {
                sb.append(',');
            }
            if (!parms[j].isArray()) {
                sb.append(parms[j].getName().replace('$', '.'));
            } else {
                Class<?> finalType = parms[j].getComponentType();
                int insrt = sb.length();
                while (finalType.isArray()) {
                    sb.append("[]");
                    finalType = finalType.getComponentType();
                }
                sb.insert(insrt, finalType.getName().replace('$', '.'));
            }
            ++j;
        }
        return sb.toString();
    }

    protected void createPropertyArray(List features) {
        this.fInheritedProperties = this.createDescriptorNames(features);
    }

    protected String[] createDescriptorNames(List features) {
        String[] result = new String[features.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = ((FeatureDescriptor)features.get(i)).getName();
            ++i;
        }
        return result;
    }

    protected List addAll(Object[] set) {
        if (set != null) {
            ArrayList<Object> l = new ArrayList<Object>(set.length);
            int i = 0;
            while (i < set.length) {
                l.add(set[i]);
                ++i;
            }
            return l;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isMergeInheritedEvents() {
        return this.fMergeInheritedEvents;
    }

    public boolean isMergeInheritedMethods() {
        return this.fMergeInheritedMethods;
    }

    public boolean isMergeInheritedProperties() {
        return this.fMergeInheritedProperties;
    }

    public BeanInfo[] getAdditionalBeanInfo() {
        return this.fTargetBeanInfo.getAdditionalBeanInfo();
    }

    public BeanDescriptor getBeanDescriptor() {
        return this.fTargetBeanInfo.getBeanDescriptor();
    }

    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.fMergeInheritedEvents ? this.fEventSets : this.fTargetBeanInfo.getEventSetDescriptors();
    }

    public Image getIcon(int iconKind) {
        return this.fTargetBeanInfo.getIcon(iconKind);
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return this.fMergeInheritedMethods ? this.fMethods : this.fTargetBeanInfo.getMethodDescriptors();
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.fMergeInheritedProperties ? this.fProperties : this.fTargetBeanInfo.getPropertyDescriptors();
    }

    public String[] getInheritedEventSetDescriptors() {
        return this.fInheritedEventSets;
    }

    public String[] getInheritedMethodDescriptors() {
        return this.fInheritedMethods;
    }

    public String[] getInheritedPropertyDescriptors() {
        return this.fInheritedProperties;
    }

    protected String computeKey(FeatureDescriptor feature) {
        return feature instanceof MethodDescriptor ? this.longName((MethodDescriptor)feature) : feature.getName();
    }

    protected boolean stripList(List fullList, List inheritedList) {
        if (fullList.isEmpty()) {
            return false;
        }
        if (inheritedList.isEmpty()) {
            return false;
        }
        FeatureDescriptorEquality workingStrip = FeatureDescriptorEquality.createEquality((FeatureDescriptor)inheritedList.get(0));
        FeatureDescriptorEquality workingFull = FeatureDescriptorEquality.createEquality((FeatureDescriptor)fullList.get(0));
        int inheritedSize = inheritedList.size();
        boolean[] copy = new boolean[inheritedSize];
        HashMap<String, Integer> inheritedMap = new HashMap<String, Integer>(inheritedSize);
        int i = 0;
        while (i < inheritedSize) {
            FeatureDescriptor f = (FeatureDescriptor)inheritedList.get(i);
            String key = this.computeKey(f);
            Object value = inheritedMap.get(key);
            if (value == null) {
                inheritedMap.put(key, new Integer(i));
            }
            ++i;
        }
        int inheritedRetained = 0;
        Iterator fullItr = fullList.iterator();
        while (inheritedRetained < inheritedSize && fullItr.hasNext()) {
            FeatureDescriptor f = (FeatureDescriptor)fullItr.next();
            boolean foundFull = false;
            Object index = inheritedMap.get(this.computeKey(f));
            if (index != null) {
                workingFull.setFeature(f);
                int ndx = (Integer)index;
                workingStrip.setFeature((FeatureDescriptor)inheritedList.get(ndx));
                if (workingFull.equals(workingStrip)) {
                    copy[ndx] = true;
                    foundFull = true;
                    ++inheritedRetained;
                }
            }
            if (!foundFull) continue;
            fullItr.remove();
        }
        if (inheritedRetained == inheritedSize) {
            inheritedList.clear();
            return true;
        }
        if (inheritedRetained != 0) {
            int i2 = copy.length - 1;
            while (i2 >= 0) {
                if (!copy[i2]) {
                    inheritedList.remove(i2);
                }
                --i2;
            }
        } else {
            inheritedList.clear();
        }
        return !inheritedList.isEmpty();
    }

    static class FeatureEqualitySet
    extends HashSet {
        private FeatureDescriptorEquality workingKey;

        public FeatureEqualitySet(List features) {
            super(features.size());
            this.workingKey = FeatureDescriptorEquality.createEquality((FeatureDescriptor)features.get(0));
            this.addAll(features);
        }

        public boolean add(Object o) {
            return super.add(FeatureDescriptorEquality.createEquality((FeatureDescriptor)o));
        }

        public boolean contains(Object o) {
            this.workingKey.setFeature((FeatureDescriptor)o);
            return super.contains(this.workingKey);
        }
    }
}

