/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.VariablePathDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jem.internal.beaninfo.ui.BeanInfoUIMessages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class VariableSelectionBlock {
    private List fExistingPaths;
    private StringButtonDialogField fVariableField;
    private StringButtonDialogField fExtensionField;
    private CLabel fFullPath;
    private IStatus fVariableStatus;
    private IStatus fExistsStatus;
    private IStatus fExtensionStatus;
    private String fVariable;
    private IStatusChangeListener fContext;
    private boolean fIsEmptyAllowed;
    private String fLastVariableSelection;

    public VariableSelectionBlock(IStatusChangeListener context, List existingPaths, IPath varPath, String lastVarSelection, boolean emptyAllowed) {
        this.fContext = context;
        this.fExistingPaths = existingPaths;
        this.fIsEmptyAllowed = emptyAllowed;
        this.fLastVariableSelection = lastVarSelection;
        this.fVariableStatus = new StatusInfo();
        this.fExistsStatus = new StatusInfo();
        VariableSelectionAdapter adapter = new VariableSelectionAdapter();
        this.fVariableField = new StringButtonDialogField((IStringButtonAdapter)adapter);
        this.fVariableField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fVariableField.setLabelText(BeanInfoUIMessages.getString("VariableSelectionBlock.variable.label"));
        this.fVariableField.setButtonLabel(BeanInfoUIMessages.getString("VariableSelectionBlock.variable.button"));
        this.fExtensionField = new StringButtonDialogField((IStringButtonAdapter)adapter);
        this.fExtensionField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fExtensionField.setLabelText(BeanInfoUIMessages.getString("VariableSelectionBlock.extension.label"));
        this.fExtensionField.setButtonLabel(BeanInfoUIMessages.getString("VariableSelectionBlock.extension.button"));
        if (varPath != null) {
            this.fVariableField.setText(varPath.segment(0));
            this.fExtensionField.setText(varPath.removeFirstSegments(1).toString());
        } else {
            this.fVariableField.setText("");
            this.fExtensionField.setText("");
        }
        this.updateFullTextField();
    }

    public IPath getVariablePath() {
        if (this.fVariable != null) {
            return new Path(this.fVariable).append(this.fExtensionField.getText());
        }
        return null;
    }

    public IPath getResolvedPath() {
        IPath entryPath;
        if (this.fVariable != null && (entryPath = JavaCore.getClasspathVariable((String)this.fVariable)) != null) {
            return entryPath.append(this.fExtensionField.getText());
        }
        return null;
    }

    public void setFocus(Display display) {
        this.fVariableField.postSetFocusOnDialogField(display);
    }

    public Control createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        int nColumns = 3;
        Composite inner = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = nColumns;
        inner.setLayout((Layout)layout);
        int fieldWidthHint = converter.convertWidthInCharsToPixels(50);
        this.fVariableField.doFillIntoGrid(inner, nColumns);
        LayoutUtil.setWidthHint((Control)this.fVariableField.getTextControl(null), (int)fieldWidthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fVariableField.getTextControl(null));
        this.fExtensionField.doFillIntoGrid(inner, nColumns);
        LayoutUtil.setWidthHint((Control)this.fExtensionField.getTextControl(null), (int)fieldWidthHint);
        Label label = new Label(inner, 16384);
        label.setLayoutData((Object)new GridData());
        label.setText(BeanInfoUIMessages.getString("VariableSelectionBlock.fullpath.label"));
        this.fFullPath = new CLabel(inner, 0);
        this.fFullPath.setLayoutData((Object)new GridData(256));
        DialogField.createEmptySpace((Composite)inner, (int)(nColumns - 2));
        this.updateFullTextField();
        this.setFocus(parent.getDisplay());
        return inner;
    }

    private void doChangeControlPressed(DialogField field) {
        IPath filePath;
        if (field == this.fVariableField) {
            String variable = this.chooseVariable();
            if (variable != null) {
                this.fVariableField.setText(variable);
            }
        } else if (field == this.fExtensionField && (filePath = this.chooseExtJar()) != null) {
            this.fExtensionField.setText(filePath.toString());
        }
    }

    private void doFieldUpdated(DialogField field) {
        if (field == this.fVariableField) {
            this.fVariableStatus = this.variableUpdated();
        } else if (field == this.fExtensionField) {
            this.fExtensionStatus = this.extensionUpdated();
        }
        this.fExistsStatus = this.getExistsStatus();
        this.updateFullTextField();
        this.fContext.statusChanged(StatusUtil.getMostSevere((IStatus[])new IStatus[]{this.fVariableStatus, this.fExtensionStatus, this.fExistsStatus}));
    }

    private IStatus variableUpdated() {
        this.fVariable = null;
        StatusInfo status = new StatusInfo();
        String name = this.fVariableField.getText();
        if (name.length() == 0) {
            if (!this.fIsEmptyAllowed) {
                status.setError(BeanInfoUIMessages.getString("VariableSelectionBlock.error.entername_ERROR_"));
            } else {
                this.fVariable = "";
            }
        } else if (JavaCore.getClasspathVariable((String)name) == null) {
            status.setError(BeanInfoUIMessages.getString("VariableSelectionBlock.error.namenotexists_ERROR_"));
        } else {
            this.fVariable = name;
        }
        this.fExtensionField.enableButton(this.fVariable != null);
        return status;
    }

    private IStatus extensionUpdated() {
        StatusInfo status = new StatusInfo();
        String extension = this.fExtensionField.getText();
        if (extension.length() > 0 && !Path.ROOT.isValidPath(extension)) {
            status.setError(BeanInfoUIMessages.getString("VariableSelectionBlock.error.invalidextension_ERROR_"));
        }
        return status;
    }

    private IStatus getExistsStatus() {
        StatusInfo status = new StatusInfo();
        IPath path = this.getResolvedPath();
        if (path != null) {
            if (this.findPath(path)) {
                status.setError(BeanInfoUIMessages.getString("VariableSelectionBlock.error.pathexists_ERROR_"));
            } else if (!path.toFile().isFile()) {
                status.setWarning(BeanInfoUIMessages.getString("VariableSelectionBlock.warning.pathnotexists_WARN_"));
            }
        } else {
            status.setWarning(BeanInfoUIMessages.getString("VariableSelectionBlock.warning.pathnotexists_WARN_"));
        }
        return status;
    }

    private boolean findPath(IPath path) {
        int i = this.fExistingPaths.size() - 1;
        while (i >= 0) {
            IPath curr = (IPath)this.fExistingPaths.get(i);
            if (curr.equals((Object)path)) {
                return true;
            }
            --i;
        }
        return false;
    }

    private void updateFullTextField() {
        if (this.fFullPath != null && !this.fFullPath.isDisposed()) {
            IPath resolvedPath = this.getResolvedPath();
            if (resolvedPath != null) {
                this.fFullPath.setText(resolvedPath.toOSString());
            } else {
                this.fFullPath.setText("");
            }
        }
    }

    private Shell getShell() {
        if (this.fFullPath != null) {
            return this.fFullPath.getShell();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private IPath chooseExtJar() {
        String lastUsedPath = "";
        IPath entryPath = this.getResolvedPath();
        if (entryPath != null) {
            lastUsedPath = ArchiveFileFilter.isArchivePath((IPath)entryPath) ? entryPath.removeLastSegments(1).toOSString() : entryPath.toOSString();
        }
        FileDialog dialog = new FileDialog(this.getShell(), 4);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(lastUsedPath);
        dialog.setText(BeanInfoUIMessages.getString("VariableSelectionBlock.ExtJarDialog.title"));
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        IPath resPath = new Path(res).makeAbsolute();
        IPath varPath = JavaCore.getClasspathVariable((String)this.fVariable);
        if (!varPath.isPrefixOf(resPath)) {
            return new Path(resPath.lastSegment());
        }
        return resPath.removeFirstSegments(varPath.segmentCount()).setDevice(null);
    }

    private String chooseVariable() {
        VariablePathDialogField.ChooseVariableDialog dialog = new VariablePathDialogField.ChooseVariableDialog(this.getShell(), this.fVariable);
        if (dialog.open() == 0) {
            return dialog.getSelectedVariable();
        }
        return null;
    }

    private class VariableSelectionAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        VariableSelectionAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            VariableSelectionBlock.this.doFieldUpdated(field);
        }

        public void changeControlPressed(DialogField field) {
            VariableSelectionBlock.this.doChangeControlPressed(field);
        }
    }
}

