/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.cde.properties.NameInCompositionPropertyDescriptor;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.propertysheet.common.commands.CommandWrapper;

public class ApplyCardLayoutConstraintCommand
extends CommandWrapper {
    protected EObject fConstraintComponent;
    protected EObject fComponent;
    protected ResourceSet fResourceSet;
    protected EditDomain fDomain;

    public ApplyCardLayoutConstraintCommand(EObject constraintComponent, EObject component, EditDomain domain) {
        this.fConstraintComponent = constraintComponent;
        this.fComponent = component;
        this.fDomain = domain;
        this.fResourceSet = EMFEditDomainHelper.getResourceSet((EditDomain)domain);
    }

    protected boolean prepare() {
        return this.fConstraintComponent != null && this.fComponent != null && this.fDomain != null && this.fResourceSet != null;
    }

    public void execute() {
        RuledCommandBuilder cb = new RuledCommandBuilder(this.fDomain);
        EStructuralFeature sfName = JavaInstantiation.getSFeature((IJavaObjectInstance)((IJavaObjectInstance)this.fComponent), (URI)JFCConstants.SF_COMPONENT_NAME);
        EStructuralFeature sfConstraintConstraint = JavaInstantiation.getSFeature((ResourceSet)this.fResourceSet, (URI)JFCConstants.SF_CONSTRAINT_CONSTRAINT);
        String cardname = null;
        if (!this.fComponent.eIsSet(sfName)) {
            IJavaObjectInstance stringObject = null;
            AnnotationLinkagePolicy policy = this.fDomain.getAnnotationLinkagePolicy();
            Annotation ann = policy.getAnnotation((Object)this.fComponent);
            if (ann != null) {
                cardname = (String)ann.getKeyedValues().get((Object)"org.eclipse.ve.internal.cde.core.nameincomposition");
            }
            if (cardname != null) {
                stringObject = BeanUtilities.createString((ResourceSet)this.fResourceSet, (String)cardname);
            } else {
                String classname = ((IJavaObjectInstance)this.fComponent).getJavaType().getJavaName();
                int index = classname.lastIndexOf(".");
                if (index != -1) {
                    classname = classname.substring(index + 1);
                }
                classname = classname.length() > 1 ? String.valueOf(Character.toLowerCase(classname.charAt(0))) + classname.substring(1) : classname.toLowerCase();
                cardname = NameInCompositionPropertyDescriptor.getUniqueNameInComposition((EditDomain)this.fDomain, (String)classname);
            }
            cb.applyAttributeSetting(this.fComponent, sfName, (Object)stringObject);
        }
        cb.cancelAttributeSetting(this.fConstraintComponent, sfConstraintConstraint);
        this.command = cb.getCommand();
        this.command.execute();
    }
}

