/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.cde.core.IVisualComponent;
import org.eclipse.ve.internal.cde.core.IVisualComponentListener;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.CardLayoutPolicyHelper;
import org.eclipse.ve.internal.jfc.core.ComponentGraphicalEditPart;
import org.eclipse.ve.internal.jfc.core.ContainerPolicy;
import org.eclipse.ve.internal.jfc.core.ContainerProxyAdapter;
import org.eclipse.ve.internal.jfc.core.JFCConstants;

public class CardLayoutEditPolicy
extends ConstrainedLayoutEditPolicy {
    private EditPartListener cardListener;
    protected CardLayoutPolicyHelper helper = new CardLayoutPolicyHelper();
    protected ContainerPolicy containerPolicy;
    protected EditPart fSelectedCard;
    protected EReference sfConstraintConstraint;
    protected EReference sfConstraintComponent;
    protected EReference sfName;
    protected CardLayoutComponentListener fComponentListener;
    static /* synthetic */ Class class$0;

    public CardLayoutEditPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        this.helper.setContainerPolicy(containerPolicy);
    }

    public void activate() {
        this.containerPolicy.setContainer(this.getHost().getModel());
        this.sfConstraintConstraint = JavaInstantiation.getReference((IJavaObjectInstance)((IJavaObjectInstance)this.getHost().getModel()), (URI)JFCConstants.SF_CONSTRAINT_CONSTRAINT);
        this.sfConstraintComponent = JavaInstantiation.getReference((IJavaObjectInstance)((IJavaObjectInstance)this.getHost().getModel()), (URI)JFCConstants.SF_CONSTRAINT_COMPONENT);
        this.sfName = JavaInstantiation.getReference((IJavaObjectInstance)((IJavaObjectInstance)this.getHost().getModel()), (URI)JFCConstants.SF_COMPONENT_NAME);
        super.activate();
        if (!this.getHost().getChildren().isEmpty()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    List children = CardLayoutEditPolicy.this.getHost().getChildren();
                    int i = 0;
                    while (i < children.size()) {
                        EditPart child = (EditPart)children.get(i);
                        CardLayoutEditPolicy.this.addCardListenerToChildren(child);
                        CardLayoutEditPolicy.this.addComponentListener(child);
                        if (i > 0) {
                            CardLayoutEditPolicy.this.setCardVisible(child, false);
                        }
                        ++i;
                    }
                    GraphicalEditPart ep = (GraphicalEditPart)CardLayoutEditPolicy.this.getHost().getChildren().get(0);
                    CardLayoutEditPolicy.this.setCardVisible((EditPart)ep, true);
                    CardLayoutEditPolicy.this.selectCard((EditPart)ep);
                }
            });
        }
    }

    protected void addCardListenerToChildren(EditPart ep) {
        ep.addEditPartListener(this.cardListener);
        Iterator childen = ep.getChildren().iterator();
        while (childen.hasNext()) {
            this.addCardListenerToChildren((EditPart)childen.next());
        }
    }

    protected void addComponentListener(EditPart child) {
        if (child.getParent() == this.getHost() && child instanceof ComponentGraphicalEditPart) {
            IVisualComponent visualComponent;
            ComponentGraphicalEditPart componentGraphicalEditPart = (ComponentGraphicalEditPart)child;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.ve.internal.cde.core.IVisualComponent;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((visualComponent = (IVisualComponent)componentGraphicalEditPart.getAdapter(clazz)) != null) {
                visualComponent.addComponentListener((IVisualComponentListener)this.getCardLayoutComponentListener());
            }
        }
    }

    protected Command getAddCommand(Request generic) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List editParts = request.getEditParts();
        ArrayList<Object> childrenComponents = new ArrayList<Object>(editParts.size());
        Iterator iter = editParts.iterator();
        while (iter.hasNext()) {
            childrenComponents.add(((EditPart)iter.next()).getModel());
        }
        List constraints = this.helper.getDefaultConstraint(childrenComponents);
        return this.helper.getAddChildrenCommand(childrenComponents, constraints, null);
    }

    protected EditPartListener createListener() {
        this.cardListener = new EditPartListener.Stub(){

            public void childAdded(EditPart child, int index) {
                CardLayoutEditPolicy.this.decorateChild(child);
                CardLayoutEditPolicy.this.addCardListenerToChildren(child);
                CardLayoutEditPolicy.this.addComponentListener(child);
            }

            public void removingChild(EditPart child, int index) {
                CardLayoutEditPolicy.this.removeCardListenerFromChildren(child);
                CardLayoutEditPolicy.this.removeComponentListener(child);
                if (!CardLayoutEditPolicy.this.getHost().getChildren().isEmpty()) {
                    EditPart card = (EditPart)CardLayoutEditPolicy.this.getHost().getChildren().get(0);
                    CardLayoutEditPolicy.this.setCardVisible(card, true);
                    CardLayoutEditPolicy.this.selectCard(card);
                }
            }

            public void selectedStateChanged(EditPart editpart) {
                EditPart card;
                if (editpart == null || editpart == CardLayoutEditPolicy.this.getHost()) {
                    return;
                }
                if (editpart != null && (editpart.getSelected() == 1 || editpart.getSelected() == 2) && (card = CardLayoutEditPolicy.this.getCardOfSelectedEditpart(editpart)) != null && card != CardLayoutEditPolicy.this.fSelectedCard) {
                    CardLayoutEditPolicy.this.setCardVisible(CardLayoutEditPolicy.this.fSelectedCard, false);
                    BeanAwtUtilities.hideGrids(CardLayoutEditPolicy.this.fSelectedCard);
                    CardLayoutEditPolicy.this.setCardVisible(card, true);
                    CardLayoutEditPolicy.this.selectCard(card);
                }
            }
        };
        return this.cardListener;
    }

    protected CardLayoutComponentListener getCardLayoutComponentListener() {
        if (this.fComponentListener == null) {
            this.fComponentListener = new CardLayoutComponentListener();
        }
        return this.fComponentListener;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return null;
    }

    public void deactivate() {
        Iterator children = this.getHost().getChildren().iterator();
        while (children.hasNext()) {
            EditPart child = (EditPart)children.next();
            this.removeCardListenerFromChildren(child);
            this.removeComponentListener(child);
        }
        super.deactivate();
    }

    protected void removeCardListenerFromChildren(EditPart ep) {
        ep.removeEditPartListener(this.cardListener);
        Iterator childen = ep.getChildren().iterator();
        while (childen.hasNext()) {
            this.removeCardListenerFromChildren((EditPart)childen.next());
        }
    }

    protected EditPart getCardOfSelectedEditpart(EditPart ep) {
        EditPart container = this.getHost();
        if (ep == null || ep.getParent() == container) {
            return ep;
        }
        return this.getCardOfSelectedEditpart(ep.getParent());
    }

    protected Object getConstraintFor(Point point) {
        return null;
    }

    protected Object getConstraintFor(Rectangle rect) {
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object child = request.getNewObject();
        List constraints = this.helper.getDefaultConstraint(Collections.singletonList(child));
        return this.helper.getCreateChildCommand(child, constraints.get(0), null);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new NonResizableEditPolicy();
    }

    protected Command getDeleteDependantCommand(Request aRequest) {
        Command deleteContributionCmd = this.containerPolicy.getCommand(aRequest);
        if (deleteContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return deleteContributionCmd;
    }

    protected Command getOrphanChildrenCommand(Request aRequest) {
        return this.helper.getOrphanChildrenCommand(org.eclipse.ve.internal.cde.core.ContainerPolicy.getChildren((GroupRequest)((GroupRequest)aRequest)));
    }

    protected void removeComponentListener(EditPart child) {
        if (child.getParent() == this.getHost() && child instanceof ComponentGraphicalEditPart) {
            IVisualComponent visualComponent;
            ComponentGraphicalEditPart componentGraphicalEditPart = (ComponentGraphicalEditPart)child;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.ve.internal.cde.core.IVisualComponent;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((visualComponent = (IVisualComponent)componentGraphicalEditPart.getAdapter(clazz)) != null) {
                visualComponent.removeComponentListener((IVisualComponentListener)this.getCardLayoutComponentListener());
            }
        }
    }

    protected void selectCard(EditPart card) {
        this.fSelectedCard = card;
        if (this.fSelectedCard == null) {
            return;
        }
        IJavaObjectInstance component = (IJavaObjectInstance)card.getModel();
        IBeanProxyHost componentProxy = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)component);
        if (!componentProxy.isBeanProxyInstantiated() || componentProxy.getErrorStatus() == 3) {
            return;
        }
        IBeanProxyHost containerProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)this.getHost().getModel()));
        IBeanProxy containerProxy = containerProxyHost.getBeanProxy();
        EObject constraintComponent = InverseMaintenanceAdapter.getFirstReferencedBy((Notifier)component, (EReference)this.sfConstraintComponent);
        IJavaInstance javaStringConstraint = null;
        if (constraintComponent.eIsSet((EStructuralFeature)this.sfConstraintConstraint)) {
            javaStringConstraint = (IJavaInstance)constraintComponent.eGet((EStructuralFeature)this.sfConstraintConstraint);
        } else {
            IBeanProxyHost componentProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)component);
            javaStringConstraint = componentProxyHost.getBeanPropertyValue((EStructuralFeature)this.sfName);
        }
        IBeanProxy layoutProxy = BeanAwtUtilities.invoke_getLayout(containerProxy);
        IMethodProxy showMethodProxy = layoutProxy.getTypeProxy().getMethodProxy("show", new String[]{"java.awt.Container", "java.lang.String"});
        if (showMethodProxy != null && javaStringConstraint != null) {
            showMethodProxy.invokeCatchThrowableExceptions(layoutProxy, new IBeanProxy[]{containerProxy, BeanProxyUtilities.getBeanProxy((IJavaInstance)javaStringConstraint)});
        }
        ((ContainerProxyAdapter)containerProxyHost).revalidateBeanProxy();
    }

    protected void setCardVisible(EditPart card, boolean bool) {
        if (card != null) {
            ((GraphicalEditPart)card).getFigure().setVisible(bool);
            IFigure fig = ((GraphicalEditPart)card).getFigure();
            Iterator children = card.getChildren().iterator();
            while (children.hasNext()) {
                ((GraphicalEditPart)children.next()).getFigure().setVisible(bool);
            }
            fig.revalidate();
        }
    }

    protected Command createAddCommand(EditPart child, Object constraint) {
        return null;
    }

    protected class CardLayoutComponentListener
    implements IVisualComponentListener {
        protected CardLayoutComponentListener() {
        }

        public void componentHidden() {
        }

        public void componentMoved(int x, int y) {
        }

        public void componentRefreshed() {
            CardLayoutEditPolicy.this.selectCard(CardLayoutEditPolicy.this.fSelectedCard);
        }

        public void componentResized(int width, int height) {
        }

        public void componentShown() {
        }
    }
}

