/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.core.ContentsGraphicalEditPart;
import org.eclipse.ve.internal.cde.core.DefaultComponentEditPolicy;
import org.eclipse.ve.internal.cde.core.IConstraintHandler;
import org.eclipse.ve.internal.cde.core.IImageNotifier;
import org.eclipse.ve.internal.cde.core.IVisualComponent;
import org.eclipse.ve.internal.cde.core.IVisualComponentListener;
import org.eclipse.ve.internal.cde.core.ImageFigure;
import org.eclipse.ve.internal.cde.core.ImageFigureController;
import org.eclipse.ve.internal.cde.core.OutlineBorder;
import org.eclipse.ve.internal.cde.utility.ToolTipContentHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.ErrorFigure;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.IErrorNotifier;
import org.eclipse.ve.internal.java.core.IJavaBeanGraphicalContextMenuContributor;
import org.eclipse.ve.internal.java.core.JavaBeanActionFilter;
import org.eclipse.ve.internal.java.core.ToolTipAssistFactory;
import org.eclipse.ve.internal.jfc.core.ComponentCellEditorLocator;
import org.eclipse.ve.internal.jfc.core.ComponentDirectEditManager;
import org.eclipse.ve.internal.jfc.core.ComponentDirectEditPolicy;
import org.eclipse.ve.internal.jfc.core.ComponentModelAdapter;
import org.eclipse.ve.internal.jfc.core.ComponentProxyAdapter;
import org.eclipse.ve.internal.jfc.core.CompositionFreeFormComponentsEditPolicy;

public class ComponentGraphicalEditPart
extends AbstractGraphicalEditPart
implements IExecutableExtension,
IJavaBeanGraphicalContextMenuContributor {
    protected boolean transparent = false;
    protected ImageFigureController imageFigureController;
    protected IPropertySource propertySource;
    protected ComponentModelAdapter constraintHandler;
    protected IErrorNotifier.ErrorListener fBeanProxyErrorListener;
    protected boolean border = false;
    protected DirectEditManager manager = null;
    protected EStructuralFeature sfDirectEditProperty = null;
    protected ErrorFigure fErrorIndicator;
    private static final String FREEFORM_EDITPOLICY = "free_form editpolicy";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public ComponentGraphicalEditPart(Object model) {
        this.setModel(model);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.border = Boolean.valueOf((String)data);
        }
    }

    protected IFigure createFigure() {
        ImageFigure fig = new ImageFigure();
        if (this.border) {
            fig.setBorder((Border)new OutlineBorder());
        }
        fig.setOpaque(!this.transparent);
        if (!this.transparent) {
            this.imageFigureController = new ImageFigureController();
            this.imageFigureController.setImageFigure(fig);
        }
        this.fErrorIndicator = new ErrorFigure(0);
        fig.add((IFigure)this.fErrorIndicator);
        IFigure ToolTipFig = ToolTipContentHelper.createToolTip(null, (IContentAssistProcessor[])ToolTipAssistFactory.createToolTipProcessors((EditPart)this));
        fig.setToolTip(ToolTipFig);
        return fig;
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ve.internal.cde.core.IVisualComponent;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return this.getVisualComponent();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.ui.views.properties.IPropertySource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2) {
            if (this.propertySource != null) {
                return this.propertySource;
            }
            IJavaObjectInstance iJavaObjectInstance = (IJavaObjectInstance)this.getModel();
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("[Lorg.eclipse.ui.views.properties.IPropertySource;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return EcoreUtil.getRegisteredAdapter((EObject)iJavaObjectInstance, (Object)clazz3);
        }
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("[Lorg.eclipse.ve.internal.cde.core.IConstraintHandler;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz4) {
            if (this.constraintHandler == null) {
                this.constraintHandler = new ComponentVisualModelAdapter(this.getModel());
            }
            return this.constraintHandler;
        }
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("[Lorg.eclipse.ui.IActionFilter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz5) {
            return this.getComponentActionFilter();
        }
        Object result = super.getAdapter(type);
        if (result != null) {
            return result;
        }
        Iterator mofAdapters = ((IJavaInstance)this.getModel()).eAdapters().iterator();
        while (mofAdapters.hasNext()) {
            Object mofAdapterAdapter;
            Object mofAdapter = mofAdapters.next();
            if (!(mofAdapter instanceof IAdaptable) || (mofAdapterAdapter = ((IAdaptable)mofAdapter).getAdapter(type)) == null) continue;
            return mofAdapterAdapter;
        }
        return null;
    }

    public void setPropertySource(IPropertySource source) {
        this.propertySource = source;
    }

    public void activate() {
        super.activate();
        if (!this.transparent) {
            this.imageFigureController.setImageNotifier((IImageNotifier)this.getVisualComponent());
        }
        this.fBeanProxyErrorListener = new IErrorNotifier.ErrorListenerAdapter(){

            public void errorStatus(int severity) {
                ComponentGraphicalEditPart.this.setSeverity(severity);
            }
        };
        this.setSeverity(this.getComponentProxy().getErrorStatus());
        BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)this.getModel())).addErrorListener(this.fBeanProxyErrorListener);
    }

    protected void setSeverity(int severity) {
        this.fErrorIndicator.sevSeverity(severity);
        this.getFigure().setVisible(severity != 3);
    }

    public void deactivate() {
        if (this.imageFigureController != null) {
            this.imageFigureController.deactivate();
        }
        if (this.fBeanProxyErrorListener != null) {
            IBeanProxyHost beanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)this.getModel()));
            beanProxyHost.removeErrorListener(this.fBeanProxyErrorListener);
        }
        super.deactivate();
    }

    protected void createEditPolicies() {
        EditPart parent;
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DefaultComponentEditPolicy());
        this.sfDirectEditProperty = this.getDirectEditTargetProperty();
        if (this.sfDirectEditProperty != null) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ComponentDirectEditPolicy());
        }
        if (this.getParent() instanceof ContentsGraphicalEditPart && (parent = this.getParent()).getEditPolicy((Object)FREEFORM_EDITPOLICY) == null) {
            parent.installEditPolicy((Object)FREEFORM_EDITPOLICY, (EditPolicy)new CompositionFreeFormComponentsEditPolicy());
        }
    }

    private EStructuralFeature getDirectEditTargetProperty() {
        EStructuralFeature target = null;
        IJavaObjectInstance component = (IJavaObjectInstance)this.getModel();
        JavaClass modelType = (JavaClass)component.eClass();
        target = modelType.getEStructuralFeature("text");
        if (target != null) {
            return target;
        }
        target = modelType.getEStructuralFeature("label");
        if (target != null) {
            return target;
        }
        target = modelType.getEStructuralFeature("title");
        return target;
    }

    private void performDirectEdit() {
        if (this.manager == null) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("[Lorg.eclipse.jface.viewers.TextCellEditor;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.manager = new ComponentDirectEditManager(this, clazz, new ComponentCellEditorLocator(this.getFigure()), this.sfDirectEditProperty);
        }
        this.manager.show();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" && this.sfDirectEditProperty != null) {
            this.performDirectEdit();
        }
    }

    public IJavaInstance getBean() {
        return (IJavaInstance)this.getModel();
    }

    protected IActionFilter getComponentActionFilter() {
        return JavaBeanActionFilter.INSTANCE;
    }

    protected ComponentProxyAdapter getComponentProxy() {
        IBeanProxyHost beanProxy = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.getBean());
        return (ComponentProxyAdapter)beanProxy;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    protected IVisualComponent getVisualComponent() {
        return this.getComponentProxy();
    }

    public List getEditPolicies() {
        ArrayList<EditPolicy> result = new ArrayList<EditPolicy>();
        AbstractEditPart.EditPolicyIterator i = super.getEditPolicyIterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result.isEmpty() ? Collections.EMPTY_LIST : result;
    }

    public EStructuralFeature getSfDirectEditProperty() {
        return this.sfDirectEditProperty;
    }

    private class ComponentVisualModelAdapter
    extends ComponentModelAdapter {
        private ListenerList listeners;
        private VisualComponentListener vListener;

        public ComponentVisualModelAdapter(Object component) {
            super(component);
        }

        public void contributeModelSize(org.eclipse.ve.internal.cdm.model.Rectangle modelConstraint) {
            Rectangle bounds = ComponentGraphicalEditPart.this.getVisualComponent().getBounds();
            modelConstraint.width = bounds.width;
            modelConstraint.height = bounds.height;
        }

        public void addConstraintHandlerListener(IConstraintHandler.IConstraintHandlerListener listener) {
            if (this.listeners == null) {
                this.listeners = new ListenerList(1);
            }
            if (this.vListener == null) {
                IVisualComponent visualComponent = (IVisualComponent)BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.component);
                this.vListener = new VisualComponentListener();
                visualComponent.addComponentListener((IVisualComponentListener)this.vListener);
            }
            this.listeners.add((Object)listener);
        }

        public void removeConstraintHandlerListener(IConstraintHandler.IConstraintHandlerListener listener) {
            if (this.listeners != null) {
                this.listeners.remove((Object)listener);
                if (this.listeners.isEmpty() && this.vListener != null) {
                    ((IVisualComponent)BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.component)).removeComponentListener((IVisualComponentListener)this.vListener);
                    this.vListener = null;
                }
            }
        }

        private class VisualComponentListener
        implements IVisualComponentListener {
            VisualComponentListener() {
            }

            public void componentHidden() {
            }

            public void componentMoved(int x, int y) {
            }

            public void componentRefreshed() {
            }

            public void componentResized(int width, int height) {
                Object[] listens = ComponentVisualModelAdapter.this.listeners.getListeners();
                int i = 0;
                while (i < listens.length) {
                    ((IConstraintHandler.IConstraintHandlerListener)listens[i]).sizeChanged(width, height);
                    ++i;
                }
            }

            public void componentShown() {
            }
        }
    }
}

