/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.awt.IDimensionBeanProxy;
import org.eclipse.jem.internal.proxy.awt.IPointBeanProxy;
import org.eclipse.jem.internal.proxy.awt.IRectangleBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.cde.core.IImageListener;
import org.eclipse.ve.internal.cde.core.IModelChangeController;
import org.eclipse.ve.internal.cde.core.IVisualComponent;
import org.eclipse.ve.internal.cde.core.IVisualComponentListener;
import org.eclipse.ve.internal.cde.core.ImageNotifierSupport;
import org.eclipse.ve.internal.java.core.BeanProxyAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.DimensionJavaClassCellEditor;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.IErrorHolder;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.core.PointJavaClassCellEditor;
import org.eclipse.ve.internal.java.core.RectangleJavaClassCellEditor;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.ComponentManager;
import org.eclipse.ve.internal.jfc.core.IComponentProxyHost;
import org.eclipse.ve.internal.jfc.core.ImageDataCollector;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.NullLayoutEditPolicy;
import org.eclipse.ve.internal.jfc.core.VisualMessages;

public class ComponentProxyAdapter
extends BeanProxyAdapter
implements IVisualComponent,
IComponentProxyHost {
    private IJavaInstance fDefaultVisibility = null;
    private IJavaInstance fDefaultLocation = null;
    private IJavaInstance fVisibilityToUse = null;
    private IJavaInstance fLocationToUse = null;
    protected ImageDataCollector fImageDataCollector = null;
    protected List fComponentListeners = null;
    protected ComponentManager fComponentManager;
    protected ImageNotifierSupport imSupport;
    protected IComponentProxyHost fParentComponent = null;
    protected int fImageValid = 1;
    protected static final int INVALID = 1;
    protected static final int INVALID_COLLECTING = 2;
    protected static final int VALID = 3;
    protected EStructuralFeature sfComponentVisible;
    protected EStructuralFeature sfComponentLocation;
    protected EStructuralFeature sfComponentSize;
    protected EStructuralFeature sfComponentBounds;
    private static final Object IMAGE_DATA_COLLECTION_ERROR_KEY = new Object();

    public ComponentProxyAdapter(IBeanProxyDomain domain) {
        super(domain);
    }

    public void setTarget(Notifier newTarget) {
        super.setTarget(newTarget);
        if (newTarget != null) {
            this.sfComponentVisible = JavaInstantiation.getSFeature((IJavaObjectInstance)((IJavaObjectInstance)newTarget), (URI)JFCConstants.SF_COMPONENT_VISIBLE);
            this.sfComponentLocation = JavaInstantiation.getSFeature((IJavaObjectInstance)((IJavaObjectInstance)newTarget), (URI)JFCConstants.SF_COMPONENT_LOCATION);
            this.sfComponentSize = JavaInstantiation.getSFeature((IJavaObjectInstance)((IJavaObjectInstance)newTarget), (URI)JFCConstants.SF_COMPONENT_SIZE);
            this.sfComponentBounds = JavaInstantiation.getSFeature((IJavaObjectInstance)((IJavaObjectInstance)newTarget), (URI)JFCConstants.SF_COMPONENT_BOUNDS);
        }
    }

    public synchronized void addComponentListener(IVisualComponentListener aListener) {
        if (this.fComponentListeners == null) {
            this.fComponentListeners = new ArrayList(1);
        }
        this.fComponentListeners.add(aListener);
        if (this.fComponentManager != null) {
            this.fComponentManager.addComponentListener(aListener);
        } else if (this.getVisualComponentBeanProxy() != null && this.getVisualComponentBeanProxy().isValid()) {
            this.createComponentManager();
        }
    }

    public synchronized void addImageListener(IImageListener aListener) {
        if (this.imSupport == null) {
            this.imSupport = new ImageNotifierSupport();
        }
        this.imSupport.addImageListener(aListener);
        if (this.getVisualComponentBeanProxy() != null && this.getVisualComponentBeanProxy().isValid()) {
            this.createImageCollector();
        }
    }

    public void applyNullLayoutConstraints() {
        EObject ref = (EObject)((AdapterImpl)this).target;
        if (ref.eIsSet(this.sfComponentBounds) && this.isValidFeature(this.sfComponentBounds)) {
            this.appliedBounds(this.sfComponentBounds, ref.eGet(this.sfComponentBounds), -1);
        } else {
            if (ref.eIsSet(this.sfComponentSize) && this.isValidFeature(this.sfComponentSize)) {
                this.appliedSize(this.sfComponentSize, ref.eGet(this.sfComponentSize), -1);
            }
            if (ref.eIsSet(this.sfComponentLocation) && this.isValidFeature(this.sfComponentLocation)) {
                this.appliedLocation(this.sfComponentLocation, ref.eGet(this.sfComponentLocation), -1);
            }
        }
    }

    protected void applied(EStructuralFeature as, Object newValue, int position) {
        if (!this.isBeanProxyInstantiated()) {
            return;
        }
        if (as == this.sfComponentBounds) {
            this.appliedBounds(as, newValue, position);
        } else if (as == this.sfComponentSize) {
            this.appliedSize(as, newValue, position);
        } else if (as == this.sfComponentLocation) {
            this.appliedLocation(as, newValue, position);
        } else if (as != this.sfComponentVisible || this.fVisibilityToUse == null) {
            super.applied(as, newValue, position);
        }
    }

    protected void appliedSize(final EStructuralFeature as, Object newValue, int position) {
        IDimensionBeanProxy dim = (IDimensionBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaInstance)newValue));
        if (dim != null && (dim.getWidth() == -1 || dim.getHeight() == -1)) {
            IBeanProxy containerBeanProxy = BeanAwtUtilities.invoke_getParent(this.getBeanProxy());
            if (containerBeanProxy == null) {
                return;
            }
            Dimension size = new Dimension(dim.getWidth(), dim.getHeight());
            if (NullLayoutEditPolicy.adjustForPreferredSize(this.getBeanProxy(), size)) {
                String initString = DimensionJavaClassCellEditor.getJavaInitializationString((int)size.width, (int)size.height);
                final IJavaInstance dimensionBean = BeanUtilities.createJavaObject((String)"java.awt.Dimension", (ResourceSet)((EObject)((AdapterImpl)this).target).eResource().getResourceSet(), (String)initString);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        IModelChangeController controller = (IModelChangeController)ComponentProxyAdapter.this.getBeanProxyDomain().getEditDomain().getData((Object)"org.eclipse.ve.internal.cde.core.IModelChangeController");
                        controller.run(new Runnable(this, as, dimensionBean){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ EStructuralFeature val$as;
                            private final /* synthetic */ IJavaInstance val$dimensionBean;
                            {
                                this.this$1 = var1_1;
                                this.val$as = eStructuralFeature;
                                this.val$dimensionBean = iJavaInstance;
                            }

                            public void run() {
                                RuledCommandBuilder cbld = new RuledCommandBuilder(1.access$0(this.this$1).getBeanProxyDomain().getEditDomain());
                                cbld.applyAttributeSetting((EObject)ComponentProxyAdapter.access$0(1.access$0(this.this$1)), this.val$as, (Object)this.val$dimensionBean);
                                cbld.getCommand().execute();
                            }
                        }, true);
                    }

                    static /* synthetic */ ComponentProxyAdapter access$0(1 var0) {
                        return var0.ComponentProxyAdapter.this;
                    }
                });
                return;
            }
        }
        super.applied(as, newValue, position);
    }

    protected void appliedLocation(final EStructuralFeature as, Object newValue, int position) {
        IPointBeanProxy pnt = (IPointBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaInstance)newValue));
        if (pnt != null && (pnt.getX() == -1 || pnt.getY() == -1)) {
            IBeanProxy containerBeanProxy = BeanAwtUtilities.invoke_getParent(this.getBeanProxy());
            if (containerBeanProxy == null) {
                return;
            }
            Point location = new Point(pnt.getX(), pnt.getY());
            if (NullLayoutEditPolicy.adjustForPreferredLocation(this.getBeanProxy(), location, 5, 5)) {
                String initString = PointJavaClassCellEditor.getJavaInitializationString((int)location.x, (int)location.y);
                final IJavaInstance pointBean = BeanUtilities.createJavaObject((String)"java.awt.Point", (ResourceSet)((EObject)((AdapterImpl)this).target).eResource().getResourceSet(), (String)initString);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        IModelChangeController controller = (IModelChangeController)ComponentProxyAdapter.this.getBeanProxyDomain().getEditDomain().getData((Object)"org.eclipse.ve.internal.cde.core.IModelChangeController");
                        controller.run(new Runnable(this, as, pointBean){
                            final /* synthetic */ 3 this$1;
                            private final /* synthetic */ EStructuralFeature val$as;
                            private final /* synthetic */ IJavaInstance val$pointBean;
                            {
                                this.this$1 = var1_1;
                                this.val$as = eStructuralFeature;
                                this.val$pointBean = iJavaInstance;
                            }

                            public void run() {
                                RuledCommandBuilder cbld = new RuledCommandBuilder(3.access$0(this.this$1).getBeanProxyDomain().getEditDomain());
                                cbld.applyAttributeSetting((EObject)ComponentProxyAdapter.access$0(3.access$0(this.this$1)), this.val$as, (Object)this.val$pointBean);
                                cbld.getCommand().execute();
                            }
                        }, true);
                    }

                    static /* synthetic */ ComponentProxyAdapter access$0(3 var0) {
                        return var0.ComponentProxyAdapter.this;
                    }
                });
                return;
            }
        }
        if (this.fLocationToUse == null) {
            super.applied(as, newValue, position);
        }
    }

    protected void appliedBounds(final EStructuralFeature as, Object newValue, int position) {
        IRectangleBeanProxy rect = (IRectangleBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaInstance)newValue));
        if (rect != null && (rect.getWidth() == -1 || rect.getHeight() == -1 || rect.getX() == Integer.MIN_VALUE && rect.getY() == Integer.MIN_VALUE)) {
            IBeanProxy containerBeanProxy = BeanAwtUtilities.invoke_getParent(this.getBeanProxy());
            if (containerBeanProxy == null) {
                return;
            }
            Rectangle bounds = new Rectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
            if (NullLayoutEditPolicy.adjustForPreferredSizeAndPosition(this.getBeanProxy(), bounds, 5, 5)) {
                String initString = RectangleJavaClassCellEditor.getJavaInitializationString((Rectangle)bounds);
                final IJavaInstance rectBean = BeanUtilities.createJavaObject((String)"java.awt.Rectangle", (ResourceSet)((EObject)((AdapterImpl)this).target).eResource().getResourceSet(), (String)initString);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        IModelChangeController controller = (IModelChangeController)ComponentProxyAdapter.this.getBeanProxyDomain().getEditDomain().getData((Object)"org.eclipse.ve.internal.cde.core.IModelChangeController");
                        controller.run(new Runnable(this, as, rectBean){
                            final /* synthetic */ 5 this$1;
                            private final /* synthetic */ EStructuralFeature val$as;
                            private final /* synthetic */ IJavaInstance val$rectBean;
                            {
                                this.this$1 = var1_1;
                                this.val$as = eStructuralFeature;
                                this.val$rectBean = iJavaInstance;
                            }

                            public void run() {
                                RuledCommandBuilder cbld = new RuledCommandBuilder(5.access$0(this.this$1).getBeanProxyDomain().getEditDomain());
                                cbld.applyAttributeSetting((EObject)ComponentProxyAdapter.access$0(5.access$0(this.this$1)), this.val$as, (Object)this.val$rectBean);
                                cbld.getCommand().execute();
                            }
                        }, true);
                    }

                    static /* synthetic */ ComponentProxyAdapter access$0(5 var0) {
                        return var0.ComponentProxyAdapter.this;
                    }
                });
                return;
            }
        }
        if (this.fLocationToUse == null) {
            super.applied(as, newValue, position);
        } else {
            IBeanProxyHost d = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.fDefaultLocation);
            if (d != null) {
                d.releaseBeanProxy();
            }
            String initString = PointJavaClassCellEditor.getJavaInitializationString((int)rect.getX(), (int)rect.getY());
            this.fDefaultLocation = BeanUtilities.createJavaObject((String)"java.awt.Point", (ResourceSet)((EObject)((AdapterImpl)this).target).eResource().getResourceSet(), (String)initString);
            IPointBeanProxy pointProxy = (IPointBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)this.fLocationToUse);
            initString = RectangleJavaClassCellEditor.getJavaInitializationString((int)pointProxy.getX(), (int)pointProxy.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            super.applied(this.sfComponentBounds, (Object)BeanUtilities.createJavaObject((String)"java.awt.Rectangle", (ResourceSet)((EObject)((AdapterImpl)this).target).eResource().getResourceSet(), (String)initString), position);
        }
    }

    public void applyVisibility(boolean apply, Boolean setToVisibility) {
        if (apply || setToVisibility == null) {
            if (((EObject)((AdapterImpl)this).target).eIsSet(this.sfComponentVisible)) {
                super.applied(this.sfComponentVisible, ((EObject)((AdapterImpl)this).target).eGet(this.sfComponentVisible), 0);
            }
        } else {
            this.fVisibilityToUse = BeanProxyUtilities.wrapperBeanProxy((IBeanProxy)this.domain.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(setToVisibility), (ResourceSet)((EObject)((AdapterImpl)this).target).eResource().getResourceSet(), (boolean)true);
            super.applied(this.sfComponentVisible, (Object)this.fVisibilityToUse, -1);
        }
    }

    public void applyLocation(boolean apply, Point setToLocation) {
        if (apply || setToLocation == null) {
            if (((EObject)((AdapterImpl)this).target).eIsSet(this.sfComponentLocation)) {
                super.applied(this.sfComponentLocation, ((EObject)((AdapterImpl)this).target).eGet(this.sfComponentLocation), 0);
            }
        } else {
            this.fLocationToUse = BeanUtilities.createJavaObject((String)"java.awt.Point", (ResourceSet)((EObject)((AdapterImpl)this).target).eResource().getResourceSet(), (String)PointJavaClassCellEditor.getJavaInitializationString((int)setToLocation.x, (int)setToLocation.y));
            super.applied(this.sfComponentLocation, (Object)this.fLocationToUse, 0);
        }
    }

    protected void canceled(EStructuralFeature as, Object oldValue, int position) {
        if (!(as == this.sfComponentVisible && this.fVisibilityToUse != null || as == this.sfComponentLocation && this.fLocationToUse != null)) {
            super.canceled(as, oldValue, position);
        }
        if (as == this.sfComponentBounds && this.fLocationToUse != null) {
            IBeanProxy loc = (IBeanProxy)this.getOriginalSettingsTable().get(this.sfComponentLocation);
            this.fDefaultLocation = BeanProxyUtilities.wrapperBeanProxy((IBeanProxy)loc, (ResourceSet)((EObject)((AdapterImpl)this).target).eResource().getResourceSet(), (boolean)false);
        }
    }

    protected void createComponentManager() {
        if (this.fComponentManager == null) {
            this.fComponentManager = new ComponentManager();
            Iterator listeners = this.fComponentListeners.iterator();
            while (listeners.hasNext()) {
                this.fComponentManager.addComponentListener((IVisualComponentListener)listeners.next());
            }
        }
        this.fComponentManager.setComponentBeanProxy(this.getVisualComponentBeanProxy());
        if (this.fParentComponent != null) {
            this.fComponentManager.setRelativeParentComponentBeanProxy(this.fParentComponent.getVisualComponentBeanProxy());
        }
    }

    protected void createImageCollector() {
        if (this.fImageDataCollector == null) {
            ProxyFactoryRegistry registry = this.getVisualComponentBeanProxy().getProxyFactoryRegistry();
            this.fImageDataCollector = new ImageDataCollector(registry);
        }
    }

    public void releaseBeanProxy() {
        IBeanProxyHost d;
        if (this.fImageDataCollector != null) {
            this.fImageDataCollector.release();
            this.fImageDataCollector = null;
            this.clearError(IMAGE_DATA_COLLECTION_ERROR_KEY);
        }
        if (this.fComponentManager != null) {
            this.fComponentManager.dispose();
            this.fComponentManager = null;
        }
        if (this.fDefaultLocation != null) {
            d = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.fDefaultLocation);
            if (d != null) {
                d.releaseBeanProxy();
            }
            this.fDefaultLocation = null;
        }
        if (this.fDefaultVisibility != null) {
            d = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.fDefaultVisibility);
            if (d != null) {
                d.releaseBeanProxy();
            }
            this.fDefaultVisibility = null;
        }
        if (this.fVisibilityToUse != null) {
            d = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.fVisibilityToUse);
            if (d != null) {
                d.releaseBeanProxy();
            }
            this.fVisibilityToUse = null;
        }
        if (this.fLocationToUse != null) {
            d = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.fLocationToUse);
            if (d != null) {
                d.releaseBeanProxy();
            }
            this.fLocationToUse = null;
        }
        super.releaseBeanProxy();
    }

    public void disposeOnFreeForm(IBeanProxy aFreeFormDialogHost) {
        if (this.isBeanProxyInstantiated() && this.getErrorStatus() != 3) {
            IMethodProxy removeFreeFormComponentMethodProxy = this.domain.getProxyFactoryRegistry().getMethodProxyFactory().getMethodProxy(aFreeFormDialogHost.getTypeProxy().getTypeName(), "remove", new String[]{"java.awt.Component"});
            removeFreeFormComponentMethodProxy.invokeCatchThrowableExceptions(aFreeFormDialogHost, this.getBeanProxy());
        }
    }

    public IJavaInstance getBeanPropertyValue(EStructuralFeature aBeanPropertyAttribute) {
        if (!this.isBeanProxyInstantiated()) {
            return null;
        }
        if (aBeanPropertyAttribute == this.sfComponentVisible && this.fVisibilityToUse != null) {
            return this.fDefaultVisibility;
        }
        if (aBeanPropertyAttribute == this.sfComponentLocation && this.fLocationToUse != null) {
            return this.fDefaultLocation;
        }
        if (aBeanPropertyAttribute == this.sfComponentBounds && this.fLocationToUse != null) {
            IJavaInstance currentBounds = super.getBeanPropertyValue(aBeanPropertyAttribute);
            EObject eObject = (EObject)((AdapterImpl)this).target;
            IJavaInstance currentLoc = null;
            currentLoc = eObject.eIsSet(this.sfComponentLocation) ? (IJavaInstance)eObject.eGet(this.sfComponentLocation) : this.fDefaultLocation;
            IPointBeanProxy currentLocProxy = (IPointBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)currentLoc);
            IRectangleBeanProxy currentBoundsProxy = (IRectangleBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)currentBounds);
            currentBoundsProxy.setLocation(currentLocProxy);
            return currentBounds;
        }
        return super.getBeanPropertyValue(aBeanPropertyAttribute);
    }

    public Rectangle getBounds() {
        if (this.fComponentManager != null) {
            return this.fComponentManager.getBounds();
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public Point getLocation() {
        if (this.fComponentManager != null) {
            return this.fComponentManager.getLocation();
        }
        return new Point(0, 0);
    }

    public IComponentProxyHost getParentComponentProxyHost() {
        return this.fParentComponent;
    }

    public Dimension getSize() {
        if (this.fComponentManager != null) {
            return this.fComponentManager.getSize();
        }
        return new Dimension(20, 20);
    }

    public IBeanProxy getVisualComponentBeanProxy() {
        return this.getBeanProxy();
    }

    public boolean hasImageListeners() {
        return this.imSupport != null && this.imSupport.hasImageListeners();
    }

    protected void setupBeanProxy(IBeanProxy beanProxy) {
        ProxyFactoryRegistry registry = beanProxy.getProxyFactoryRegistry();
        if (this.fOwnsProxy && beanProxy != null && !beanProxy.getTypeProxy().isKindOf(registry.getBeanTypeProxyFactory().getBeanTypeProxy("java.awt.Component"))) {
            IBeanProxy newProxy = null;
            try {
                newProxy = registry.getBeanTypeProxyFactory().getBeanTypeProxy("java.awt.Canvas").newInstance();
                try {
                    IBeanProxy grayProxy = registry.getBeanTypeProxyFactory().getBeanTypeProxy("java.awt.Color").newInstance("java.awt.Color.lightGray");
                    newProxy.getTypeProxy().getMethodProxy("setBackground", new IBeanTypeProxy[]{grayProxy.getTypeProxy()}).invokeCatchThrowableExceptions(newProxy, grayProxy);
                    IBeanProxy sizeProxy = registry.getBeanTypeProxyFactory().getBeanTypeProxy("java.awt.Dimension").newInstance("new java.awt.Dimension(10,10)");
                    newProxy.getTypeProxy().getMethodProxy("setSize", new IBeanTypeProxy[]{sizeProxy.getTypeProxy()}).invokeCatchThrowableExceptions(newProxy, sizeProxy);
                }
                catch (InstantiationException instantiationException) {}
            }
            catch (ThrowableProxy e) {
                JavaVEPlugin.log((Throwable)e, (int)2);
            }
            beanProxy.getProxyFactoryRegistry().releaseProxy(beanProxy);
            beanProxy = newProxy;
            this.notInstantiatedClasses.remove(this.notInstantiatedClasses.size() - 1);
        }
        super.setupBeanProxy(beanProxy);
        if (this.isBeanProxyInstantiated()) {
            if (this.fComponentListeners != null && !this.fComponentListeners.isEmpty()) {
                this.createComponentManager();
            }
            if (this.hasImageListeners()) {
                this.createImageCollector();
            }
        }
    }

    protected void applyAllSettings() {
        if (this.isBeanProxyInstantiated()) {
            this.fDefaultLocation = BeanProxyUtilities.wrapperBeanProxy((IBeanProxy)super.getBeanPropertyProxyValue(this.sfComponentLocation), (ResourceSet)((EObject)((AdapterImpl)this).target).eResource().getResourceSet(), (boolean)false);
            if (this.fLocationToUse != null) {
                super.applied(this.sfComponentLocation, (Object)this.fLocationToUse, -1);
            }
            this.fDefaultVisibility = BeanProxyUtilities.wrapperBeanProxy((IBeanProxy)super.getBeanPropertyProxyValue(this.sfComponentVisible), (ResourceSet)((EObject)((AdapterImpl)this).target).eResource().getResourceSet(), (boolean)false);
        }
        super.applyAllSettings();
        if (this.isBeanProxyInstantiated() && this.getErrorStatus() != 3 && this.fVisibilityToUse != null) {
            super.applied(this.sfComponentVisible, (Object)this.fVisibilityToUse, -1);
        }
    }

    protected void reapplyVisibility() {
        if (this.fVisibilityToUse != null) {
            super.applied(this.sfComponentVisible, (Object)this.fVisibilityToUse, -1);
        } else {
            Object initial = ((IJavaObjectInstance)this.getTarget()).eGet(this.sfComponentVisible);
            if (initial == null) {
                initial = BeanProxyUtilities.wrapperBeanProxy((IBeanProxy)this.getBeanProxyDomain().getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(true), (ResourceSet)((EObject)((AdapterImpl)this).target).eResource().getResourceSet(), (boolean)true);
            }
            super.applied(this.sfComponentVisible, initial, -1);
        }
    }

    public IBeanProxy instantiateOnFreeForm(IBeanProxy aFreeFormDialogHost) {
        if (!this.isBeanProxyInstantiated() && this.getErrorStatus() != 3) {
            this.instantiateBeanProxy();
        }
        if (this.isBeanProxyInstantiated() && this.getErrorStatus() != 3) {
            IMethodProxy addFreeFormComponentMethodProxy = this.domain.getProxyFactoryRegistry().getMethodProxyFactory().getMethodProxy(aFreeFormDialogHost.getTypeProxy().getTypeName(), "add", new String[]{"java.awt.Component"});
            addFreeFormComponentMethodProxy.invokeCatchThrowableExceptions(aFreeFormDialogHost, this.instantiateBeanProxy());
            this.applyVisibility(false, Boolean.TRUE);
            this.revalidateBeanProxy();
        }
        return this.getBeanProxy();
    }

    public synchronized void invalidateImage() {
        if (this.fImageDataCollector != null) {
            if (this.fImageValid == 2 && this.fImageDataCollector.isCollectingData()) {
                this.fImageDataCollector.abort();
            }
            this.fImageValid = 1;
        }
    }

    public void refreshImage() {
        boolean doRefresh = false;
        ComponentProxyAdapter componentProxyAdapter = this;
        synchronized (componentProxyAdapter) {
            boolean bl = doRefresh = this.fImageValid == 1 && this.fImageDataCollector != null && this.hasImageListeners();
            if (doRefresh) {
                this.fImageValid = 2;
            }
        }
        if (doRefresh) {
            try {
                this.fImageDataCollector.waitForCompletion();
                componentProxyAdapter = this;
                synchronized (componentProxyAdapter) {
                    this.clearError(IMAGE_DATA_COLLECTION_ERROR_KEY);
                    this.fImageDataCollector.startComponent(this.getVisualComponentBeanProxy(), new ImageDataCollector.DataCollectedRunnable(){
                        private int startedStatus = -1;

                        public void imageStarted(int startStatus) {
                            this.startedStatus = startStatus;
                        }

                        public void imageData(ImageData data) {
                            ComponentProxyAdapter componentProxyAdapter = ComponentProxyAdapter.this;
                            synchronized (componentProxyAdapter) {
                                ComponentProxyAdapter.this.fImageValid = 3;
                            }
                            ComponentProxyAdapter.this.imSupport.fireImageChanged(data);
                            if (this.startedStatus == 1) {
                                Display.getDefault().asyncExec(new Runnable(this){
                                    final /* synthetic */ 7 this$1;
                                    {
                                        this.this$1 = var1_1;
                                    }

                                    public void run() {
                                        IErrorHolder.ErrorType err = new IErrorHolder.ErrorType(VisualMessages.getString("ComponentProxyAdapter.Picture_too_large"), 1);
                                        ComponentProxyAdapter.access$2(7.access$0(this.this$1), ComponentProxyAdapter.access$1(), err);
                                    }
                                });
                            }
                        }

                        public void imageNotCollected(int status) {
                            ComponentProxyAdapter componentProxyAdapter = ComponentProxyAdapter.this;
                            synchronized (componentProxyAdapter) {
                                ComponentProxyAdapter.this.fImageValid = 1;
                            }
                        }

                        public void imageException(ThrowableProxy exception) {
                            Display.getDefault().asyncExec(new Runnable(this, exception){
                                final /* synthetic */ 7 this$1;
                                private final /* synthetic */ ThrowableProxy val$exception;
                                {
                                    this.this$1 = var1_1;
                                    this.val$exception = throwableProxy;
                                }

                                public void run() {
                                    String eMsg = this.val$exception.getProxyLocalizedMessage();
                                    if (eMsg == null) {
                                        IBeanTypeProxy eType = this.val$exception.getTypeProxy();
                                        eMsg = MessageFormat.format(VisualMessages.getString("ComponentProxyAdapter.Image_collection_exception"), eType.getTypeName());
                                    }
                                    IErrorHolder.ErrorType err = new IErrorHolder.ErrorType(MessageFormat.format(VisualMessages.getString("ComponentProxyAdapter.Image_collection_failed"), eMsg), 1);
                                    ComponentProxyAdapter.access$2(7.access$0(this.this$1), ComponentProxyAdapter.access$1(), err);
                                }
                            });
                        }

                        static /* synthetic */ ComponentProxyAdapter access$0(7 var0) {
                            return var0.ComponentProxyAdapter.this;
                        }
                    });
                }
            }
            catch (ThrowableProxy e) {
                JavaVEPlugin.log((Throwable)e, (int)5);
                String eMsg = e.getProxyLocalizedMessage();
                if (eMsg == null) {
                    IBeanTypeProxy eType = e.getTypeProxy();
                    eMsg = "java.lang.OutOfMemoryError".equals(eType.getTypeName()) ? VisualMessages.getString("ComponentProxyAdapter.Out_of_memory") : MessageFormat.format(VisualMessages.getString("ComponentProxyAdapter.Image_collection_exception"), eType.getTypeName());
                }
                IErrorHolder.ErrorType err = new IErrorHolder.ErrorType(MessageFormat.format(VisualMessages.getString("ComponentProxyAdapter.Image_collection_failed"), eMsg), 1);
                this.processError(IMAGE_DATA_COLLECTION_ERROR_KEY, err);
                ComponentProxyAdapter componentProxyAdapter2 = this;
                synchronized (componentProxyAdapter2) {
                    this.fImageValid = 1;
                }
            }
        }
    }

    public synchronized void removeComponentListener(IVisualComponentListener aListener) {
        this.fComponentListeners.remove(aListener);
        if (this.fComponentManager != null) {
            this.fComponentManager.removeComponentListener(aListener);
        }
    }

    public synchronized void removeImageListener(IImageListener aListener) {
        if (this.imSupport != null) {
            this.imSupport.removeImageListener(aListener);
        }
    }

    public void childInvalidated(IComponentProxyHost childProxy) {
        IComponentProxyHost parent = this.getParentComponentProxyHost();
        if (parent != null) {
            parent.childInvalidated(childProxy);
        }
    }

    public void childValidated(IComponentProxyHost childProxy) {
        IComponentProxyHost parent = this.getParentComponentProxyHost();
        if (parent != null) {
            parent.childValidated(childProxy);
        }
    }

    public void invalidateBeanProxy() {
        if (this.getVisualComponentBeanProxy() != null) {
            IBeanProxy componentBean = this.getVisualComponentBeanProxy();
            BeanAwtUtilities.invoke_invalidate(componentBean);
            IComponentProxyHost parentBean = this;
            while (parentBean != null) {
                if (parentBean.hasImageListeners()) {
                    parentBean.invalidateImage();
                }
                parentBean = parentBean.getParentComponentProxyHost();
            }
            this.childInvalidated(this);
        }
    }

    public void validateBeanProxy() {
        if (this.getVisualComponentBeanProxy() != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (ComponentProxyAdapter.this.isBeanProxyInstantiated()) {
                        ArrayList<IComponentProxyHost> allImageListeners = new ArrayList<IComponentProxyHost>(5);
                        IComponentProxyHost nextParentBean = ComponentProxyAdapter.this.getParentComponentProxyHost();
                        IComponentProxyHost parentBean = ComponentProxyAdapter.this;
                        if (parentBean.hasImageListeners()) {
                            allImageListeners.add(parentBean);
                        }
                        while (nextParentBean != null) {
                            parentBean = nextParentBean;
                            if (parentBean.hasImageListeners()) {
                                allImageListeners.add(parentBean);
                            }
                            nextParentBean = parentBean.getParentComponentProxyHost();
                        }
                        Iterator listeners = allImageListeners.iterator();
                        while (listeners.hasNext()) {
                            ((IComponentProxyHost)listeners.next()).refreshImage();
                        }
                    }
                }
            });
            this.childValidated(this);
        }
    }

    public void setParentComponentProxyHost(IComponentProxyHost parent) {
        this.fParentComponent = parent;
        if (this.fComponentManager != null) {
            this.fComponentManager.setRelativeParentComponentBeanProxy(this.fParentComponent != null ? this.fParentComponent.getVisualComponentBeanProxy() : null);
        }
    }

    protected void primReinstantiateBeanProxy() {
        if (this.getParentComponentProxyHost() != null) {
            this.getParentComponentProxyHost().reinstantiateChild((IBeanProxyHost)this);
            return;
        }
        super.primReinstantiateBeanProxy();
    }

    protected void clearError(EStructuralFeature sf, Object object) {
        super.clearError(sf, object);
    }

    protected void processError(EStructuralFeature sf, Throwable exc, Object object) throws BeanProxyAdapter.ReinstantiationNeeded {
        super.processError(sf, exc, object);
    }

    public boolean isTrulyValidFeature(EStructuralFeature sf, Object object) {
        return super.isValidFeature(sf, object);
    }

    static /* synthetic */ Notifier access$0(ComponentProxyAdapter componentProxyAdapter) {
        return ((AdapterImpl)componentProxyAdapter).target;
    }

    static /* synthetic */ Object access$1() {
        return IMAGE_DATA_COLLECTION_ERROR_KEY;
    }

    static /* synthetic */ void access$2(ComponentProxyAdapter componentProxyAdapter, Object object, IErrorHolder.ErrorType errorType) {
        componentProxyAdapter.processError(object, errorType);
    }
}

