/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jem.internal.beaninfo.MethodProxy;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.Method;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFCreationTool;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class FrameConstructorCreationPolicy
implements EMFCreationTool.CreationPolicy {
    public Command getCommand(Command aCommand, EditDomain domain, final CreateRequest aCreateRequest) {
        AbstractCommand setInitStringCommand = new AbstractCommand(){

            public void execute() {
                JavaClass javaClass = (JavaClass)aCreateRequest.getNewObjectType();
                Iterator behaviors = javaClass.getEOperations().iterator();
                boolean hasNullConstructor = false;
                while (behaviors.hasNext()) {
                    Method javaMethod = ((MethodProxy)behaviors.next()).getMethod();
                    if (!javaMethod.isConstructor()) continue;
                    EList methodInputParms = javaMethod.getParameters();
                    if (methodInputParms.isEmpty()) {
                        hasNullConstructor = true;
                        break;
                    }
                    if (methodInputParms.size() != 1) continue;
                    Object inputParm = methodInputParms.iterator().next();
                    inputParm.toString();
                }
                if (hasNullConstructor) {
                    return;
                }
                IJavaObjectInstance newJavaObject = (IJavaObjectInstance)aCreateRequest.getNewObject();
                String qualifiedClassName = ((JavaClass)newJavaObject.getJavaType()).getQualifiedNameForReflection();
                String initString = "new " + qualifiedClassName + "(new java.awt.Frame())";
                newJavaObject.setInitializationString(initString);
            }

            public void redo() {
            }

            public boolean canExecute() {
                return true;
            }
        };
        CompoundCommand result = new CompoundCommand(aCommand.getLabel());
        result.append((Command)setInitStringCommand);
        result.append(aCommand);
        return result;
    }

    public String getDefaultSuperString(EClass superClass) {
        Iterator behaviors = superClass.getEOperations().iterator();
        boolean hasNullConstructor = false;
        boolean hasAnyConstructors = false;
        while (behaviors.hasNext()) {
            Method javaMethod = ((MethodProxy)behaviors.next()).getMethod();
            if (!javaMethod.isConstructor()) continue;
            hasAnyConstructors = true;
            EList methodInputParms = javaMethod.getParameters();
            if (methodInputParms != null && !methodInputParms.isEmpty()) continue;
            hasNullConstructor = true;
            break;
        }
        if (hasNullConstructor) {
            return "super()";
        }
        if (!hasAnyConstructors && ((JavaClass)superClass).getSupertype() != null) {
            return this.getDefaultSuperString((EClass)((JavaClass)superClass).getSupertype());
        }
        return "super(new java.awt.Frame())";
    }
}

