/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.StatusLine;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ve.internal.jfc.core.IconController;
import org.eclipse.ve.internal.jfc.core.IconScreenDisplay;
import org.eclipse.ve.internal.jfc.core.SingleImageDisplay;
import org.eclipse.ve.internal.jfc.core.VisualMessages;

public class IconDialog
extends Dialog {
    private IconController icc = null;
    private String value;
    protected IProject myProject = null;
    private StatusLineManager statusLineManager;
    private Button projRadioButton;
    private Button fileRadioButton;
    private static final int GRID_IMAGE_WIDTH = 32;
    private static final int GRID_IMAGE_HEIGHT = 32;
    private static final int GRID_ROWS = 5;
    private static final int GRID_COLS = 8;

    public IconDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x80 | 0x400 | 0x10);
        this.myProject = project;
    }

    protected Label createLabel(Composite group, String aLabelString) {
        Label label = new Label(group, 16384);
        label.setText(aLabelString);
        return label;
    }

    protected Group createGroup(Composite aParent, String title, int numColumns) {
        Group group = new Group(aParent, 0);
        group.setText(title);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(1808));
        group.setFont(aParent.getFont());
        return group;
    }

    protected Text createLabelText(Composite parent, String label, int textStyle) {
        Composite c = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        c.setLayout((Layout)gridLayout);
        c.setLayoutData((Object)new GridData());
        Label l = this.createLabel(c, label);
        l.setLayoutData((Object)new GridData(40));
        Text text = new Text(c, textStyle);
        GridData data = new GridData(768);
        data.horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        text.setLayoutData((Object)data);
        return text;
    }

    protected Combo createLabelCombo(Composite parent, String label, int comboStyle) {
        Composite c = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        c.setLayout((Layout)gridLayout);
        c.setLayoutData((Object)new GridData());
        Label l = this.createLabel(c, label);
        l.setLayoutData((Object)new GridData(40));
        Combo combo = new Combo(c, comboStyle);
        GridData data = new GridData(768);
        data.horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Label createLabeledLabel(Composite parent, String labelText, int textStyle) {
        Composite c = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        c.setLayout((Layout)gridLayout);
        Label l = this.createLabel(c, labelText);
        l.setLayoutData((Object)new GridData(32));
        Label label = this.createLabel(c, "");
        GridData data = new GridData(768);
        data.horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        label.setLayoutData((Object)data);
        return label;
    }

    protected SingleImageDisplay createSingleImageDisplay(Composite group) {
        SingleImageDisplay sid = new SingleImageDisplay(group, 768);
        return sid;
    }

    protected Tree createTree(Composite group) {
        Tree tree = new Tree(group, 2060);
        return tree;
    }

    protected List createList(Composite group, int style) {
        List list = new List(group, style);
        return list;
    }

    protected IconScreenDisplay createIconScreenDisplay(Composite parent, int style, int rows, int cols, int width, int height, boolean enableSelectable, boolean enableToolTip, int offset, int borderOffset) {
        IconScreenDisplay disp = new IconScreenDisplay(parent, style, rows, cols, width, height, enableSelectable, enableToolTip, offset, borderOffset);
        return disp;
    }

    protected Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        return button;
    }

    protected Button createButton(Composite group, String label) {
        Button button = new Button(group, 16392);
        button.setText(label);
        button.setLayoutData((Object)new GridData());
        return button;
    }

    protected Button createRadioButton(Composite group, String label) {
        Button button = new Button(group, 16400);
        button.setText(label);
        return button;
    }

    protected GridData createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData(34);
        spacer.setLayoutData((Object)data);
        return data;
    }

    protected Control createDialogArea(Composite parent) {
        int smallIndent;
        Composite panel = (Composite)super.createDialogArea(parent);
        GridLayout gl = (GridLayout)panel.getLayout();
        gl.numColumns = 2;
        Group locGroup = this.createGroup(panel, VisualMessages.getString("IconDialog.Group.Browse"), 1);
        GridData data = (GridData)locGroup.getLayoutData();
        data.verticalSpan = 2;
        this.projRadioButton = this.createRadioButton((Composite)locGroup, VisualMessages.getString("IconDialog.Radio.BrowseProject"));
        this.projRadioButton.setLayoutData((Object)new GridData(32));
        this.fileRadioButton = this.createRadioButton((Composite)locGroup, VisualMessages.getString("IconDialog.Radio.BrowseFiles"));
        this.projRadioButton.setLayoutData((Object)new GridData(32));
        Label locLabel = this.createLabel((Composite)locGroup, VisualMessages.getString("IconDialog.Label.Location"));
        data = new GridData(32);
        data.horizontalIndent = smallIndent = this.convertHorizontalDLUsToPixels(7);
        locLabel.setLayoutData((Object)data);
        Tree direcTree = this.createTree((Composite)locGroup);
        data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.widthHint = this.convertWidthInCharsToPixels(30);
        data.horizontalIndent = smallIndent;
        direcTree.setLayoutData((Object)data);
        Button crawlButton = this.createCheckBox((Composite)locGroup, VisualMessages.getString("IconDialog.Checkbox.SearchSubDirs"));
        data = new GridData(32);
        data.horizontalIndent = smallIndent;
        crawlButton.setLayoutData((Object)data);
        int leftMargin = this.convertHorizontalDLUsToPixels(20);
        Combo filter = this.createLabelCombo(panel, VisualMessages.getString("IconDialog.Text.Filter"), 4);
        data = (GridData)filter.getLayoutData();
        data.widthHint = this.convertWidthInCharsToPixels(20);
        filter.setToolTipText(VisualMessages.getString("IconDialog.Msg"));
        String[] patterns = new String[IconController.VALID_EXTENSIONS.length + 1];
        patterns[0] = "";
        int i = 0;
        while (i < IconController.VALID_EXTENSIONS.length) {
            patterns[i + 1] = String.valueOf('*') + IconController.VALID_EXTENSIONS[i];
            ++i;
        }
        filter.setItems(patterns);
        data = new GridData(768);
        data.horizontalIndent = leftMargin;
        filter.getParent().setLayoutData((Object)data);
        Composite filesComposite = new Composite(panel, 0);
        data = new GridData(1808);
        data.horizontalIndent = leftMargin;
        filesComposite.setLayoutData((Object)data);
        GridLayout filesLayout = new GridLayout();
        filesLayout.verticalSpacing = 0;
        filesLayout.marginWidth = 0;
        filesLayout.marginHeight = 0;
        filesComposite.setLayout((Layout)filesLayout);
        filesComposite.setFont(panel.getFont());
        Label filesLabel = this.createLabel(filesComposite, VisualMessages.getString("IconDialog.Label.Files"));
        filesLabel.setLayoutData((Object)new GridData());
        List fileList = this.createList(filesComposite, 2568);
        data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.widthHint = this.convertWidthInCharsToPixels(30);
        fileList.setLayoutData((Object)data);
        this.createSpacer(panel);
        this.createSpacer(panel);
        Group availableImages = this.createGroup(panel, VisualMessages.getString("IconDialog.Group.AvailableIcons"), 1);
        IconScreenDisplay drawingBoard = this.createIconScreenDisplay((Composite)availableImages, 2568, 5, 8, 32, 32, true, true, 5, 10);
        data = new GridData(1808);
        data.widthHint = 256;
        data.heightHint = 160;
        drawingBoard.setLayoutData(data);
        Group selectedImage = this.createGroup(panel, VisualMessages.getString("IconDialog.Group.SelectedImage"), 1);
        data = (GridData)selectedImage.getLayoutData();
        data.heightHint = 160;
        data.widthHint = 150;
        data.horizontalIndent = leftMargin;
        SingleImageDisplay imageDisplay = this.createSingleImageDisplay((Composite)selectedImage);
        imageDisplay.setLayoutData(new GridData(1808));
        Label path = this.createLabeledLabel(panel, VisualMessages.getString("IconDialog.Text.PathOfFile"), 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        path.getParent().setLayoutData((Object)data);
        this.icc = new IconController(this, this.myProject, direcTree, fileList, drawingBoard, path, imageDisplay, panel.getDisplay(), crawlButton, locGroup, filter);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IconDialog.this.icc.dispose();
            }
        });
        this.projRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    IconDialog.this.icc.setSearchScope(0);
                }
            }
        });
        this.fileRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    IconDialog.this.icc.setSearchScope(1);
                }
            }
        });
        this.getShell().setText(VisualMessages.getString("IconDialog.Shell.Text"));
        return panel;
    }

    protected void okPressed() {
        String initStr = this.icc.getInitString();
        if (initStr.equals("")) {
            this.cancelPressed();
        } else {
            this.setValue(this.icc.getInitString());
            super.okPressed();
        }
    }

    public void setValue(String pathname) {
        if (pathname != null && !pathname.equals("")) {
            this.value = pathname;
        }
    }

    public String getValue() {
        return this.value;
    }

    protected Button getButton(int id) {
        return super.getButton(id);
    }

    protected StatusLineManager getStatusLineManager() {
        return this.statusLineManager;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        super.getButton(0).setEnabled(false);
    }

    protected Control createContents(Composite parent) {
        Composite panel = (Composite)super.createContents(parent);
        this.statusLineManager = new StatusLineManager();
        StatusLine statusLine = this.statusLineManager.createControl(panel);
        statusLine.setLayoutData((Object)new GridData(768));
        switch (this.icc.setInitialValue(this.getValue())) {
            case 0: {
                this.projRadioButton.setSelection(true);
                break;
            }
            case 1: {
                this.fileRadioButton.setSelection(true);
            }
        }
        return panel;
    }
}

