/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanProxyAdapter;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.jfc.core.VisualMessages;

public class IconProxyAdapter
extends BeanProxyAdapter {
    EditDomain fEditDomain;

    public IconProxyAdapter(IBeanProxyDomain domain) {
        super(domain);
        this.fEditDomain = domain.getEditDomain();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IBeanProxy instantiateWithString(IBeanTypeProxy targetClass, String initString) throws ThrowableProxy, InstantiationException {
        File iconFile;
        int index = initString.lastIndexOf("getClass().getResource");
        if (index != -1) {
            int lastQuoteIndex;
            int firstQuoteIndex = initString.indexOf(34, index);
            if (firstQuoteIndex == -1 || (lastQuoteIndex = initString.indexOf(34, firstQuoteIndex + 1)) == -1) return super.instantiateWithString(targetClass, initString);
            String pathString = initString.substring(firstQuoteIndex + 1, lastQuoteIndex).trim();
            IFile file = null;
            try {
                IProject project = ((FileEditorInput)this.fEditDomain.getEditorPart().getEditorInput()).getFile().getProject();
                IJavaProject jproject = JavaCore.create((IProject)project);
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IPackageFragmentRoot[] roots = jproject.getAllPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    IResource res = workspaceRoot.findMember(roots[i].getPath().append(pathString));
                    if (res instanceof IFile) {
                        file = (IFile)res;
                        break;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
            if (file == null) throw new InstantiationException(MessageFormat.format(VisualMessages.getString("IconProxyAdapter.CannotReadFileError_EXC_"), pathString));
            String fullPath = file.getLocation().toString();
            initString = String.valueOf(initString.substring(0, index)) + BeanUtilities.createStringInitString((String)fullPath) + initString.substring(lastQuoteIndex + 2);
            return super.instantiateWithString(targetClass, initString);
        }
        String filename = "";
        int firstQuoteIndex = initString.indexOf(34);
        if (firstQuoteIndex == -1) return super.instantiateWithString(targetClass, initString);
        int lastQuoteIndex = initString.indexOf(34, firstQuoteIndex + 1);
        if (lastQuoteIndex != -1) {
            filename = initString.substring(firstQuoteIndex + 1, lastQuoteIndex).trim();
        }
        if (filename.length() <= 0 || (iconFile = new File(filename)).canRead()) return super.instantiateWithString(targetClass, initString);
        throw new InstantiationException(MessageFormat.format(VisualMessages.getString("IconProxyAdapter.CannotReadFileError_EXC_"), filename));
    }
}

